/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k89s
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	import net.wonderfl.math.*;
	
    public class FlashTest extends Sprite {
        private var txt:TextField;
		private var sp:Sprite;
		private var line:Sprite;
		
		public function FlashTest() {
            // write as3 code here..
            txt = new TextField;
			txt.text = true.toString();
			sp = new Sprite;
			line = new Sprite;
			
			var g:Graphics;
			g = sp.graphics;
			g.lineStyle(1, 0x000000, 1.0);
			g.beginFill(0x808080, 1.0);
			g.drawCircle(100, 100, 100);
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			
			addChild(sp);
			addChild(txt);
        }
		
		private var lastMouseX:Number;
		private var lastMouseY:Number;
		private var cnt:Number = 0;
		
		private function enterFrameHandler(e:Event):void {
			cnt++;
			if (cnt % 20 == 0) {
				cnt = 0;
				var x:Number = mouseX;
				var y:Number = mouseY;
				var g:Graphics;
				g = line.graphics;
				g.clear();
				g.lineStyle(1, 0x000000, 1.0);
				g.moveTo(lastMouseX, lastMouseY);
				g.lineTo(x, y);
				g.drawCircle(lastMouseX, lastMouseY, 2);
				addChild(line);
				txt.text = checkCrclLine(new WVector2D(100, 100),100,
					new WVector2D(lastMouseX, lastMouseY),
					new WVector2D(x - lastMouseX, y - lastMouseY)).toString();
				lastMouseX = x;
				lastMouseY = y;
			}
		}
		// 円と半直線の交差判定
		private function checkCrclLine(crclPos:WVector2D, crclRadius:Number, linePos:WVector2D, lineVec:WVector2D):Boolean {
            lineVec.normalize();
            // 半直線の始点から円の中心へのベクトル
            var C:WVector2D = crclPos.copy();
            C.subtract(linePos);
            // Cと半直線のベクトルの内積
            var dot:Number = WMath.dot2D(C, lineVec);
            // dot < 0 のとき、円の中心に向かって線が伸びていない
            if (dot < 0){
                if (C.length < crclRadius) // Cの長さが円の半径より小さければ交差
                    return true;
                else
                    return false;
            } else {
                //円の中心から直線に降ろした足のベクトルを計算
                lineVec.scale(dot);
                C.subtract(lineVec);
                if (C.length < crclRadius) //足の長さが半径より小さければ交差
                    return true;
                else
                    return false;
            }
		}
    }
}