/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k6rT
 */





package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Graphics;   
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.BlendMode;    
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.display.BitmapDataChannel;
    import flash.geom.Matrix;
    import flash.geom.Point; 
    import flash.geom.ColorTransform;   
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    
    public class AmbientLight extends Sprite 
    {
        private var _shinelist:Array;
        private var _step:int;        
        private var _lightcanvas:BitmapData;
        private var _shinecanvas:BitmapData;
        
        private static const SUN_X:Number = WIDTH / 2;
        private static const SUN_Y:Number = HEIGHT / 2;
         
        private var _colorfilter:ColorMatrixFilter;
        private var _blurfilter:BlurFilter;
                
        private var _buffercanvas:BitmapData;
        private var _canvas:BitmapData;
        
// MapData
        private var _wave:BitmapData;
        private var _waveOffset:Point;
        
        public function AmbientLight():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
// Entry Point            
            var gradientMat:Matrix = new Matrix();
            gradientMat.createGradientBox( WIDTH, HEIGHT, 0, 0, 0 );
            
            graphics.beginGradientFill("radial", [0x0C08FF, 0x0604FF, 0x0302FF, 0x0302A0], [1, 1, 1, 1], [0, 20 , 64, 255], gradientMat);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            _buffercanvas = new BitmapData( WIDTH, HEIGHT, true, 0 );
            _canvas = new BitmapData(WIDTH, HEIGHT, true, 0 );
            addChild( new Bitmap(_canvas) );
            
            
            _colorfilter = new ColorMatrixFilter([
                1, 0, 0, 0, 0,
                0, 1, 0, 0, 0,
                0, 0, 1, 0, 0,
                0, 0, 0, 0.99, 0
            ]); 
            _blurfilter = new BlurFilter(10,10,2);            
            _shinecanvas = new BitmapData( WIDTH, HEIGHT, true, 0 );
            _wave = new BitmapData( WIDTH, HEIGHT, true, 0 );
            _waveOffset = new Point();
            _step = 0;
            _shinelist = [];
            
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
        }
        
        private function EnterFrameHandler( e:Event ) : void
        {            
            var color:ColorTransform = new ColorTransform(1, 1, 1, 0.9);
            
            var shinenum:int = _shinelist.length;
            
            _shinecanvas.lock();
            //_shinecanvas.fillRect( _shinecanvas.rect, 0 );
            _shinecanvas.applyFilter( _shinecanvas, _shinecanvas.rect, new Point(), _colorfilter );
            _shinecanvas.applyFilter( _shinecanvas, _shinecanvas.rect, new Point(), _blurfilter );            
            
            for ( var i:int = shinenum - 1; i >= 0; i-- )
            {
                _shinelist[i].Update();
                
                if ( _shinelist[i].life <= 0 ) {
                    _shinelist.splice( i, 1 );
                }else
                {
                    _shinecanvas.draw( 
                        _shinelist[i].shape,
                        new Matrix(1, 0, 0, 1, _shinelist[i].x - _shinelist[i].size / 2, _shinelist[i].y - _shinelist[i].size / 2 ),
                        null,
                        BlendMode.ADD
                        );                    
                }
            }    
            _shinecanvas.applyFilter( _shinecanvas, _shinecanvas.rect, new Point(),
                new DisplacementMapFilter(
                    _wave,
                    new Point(),
                    BitmapDataChannel.RED, // 
                    BitmapDataChannel.RED, // 
                    20,
                    20,
                    DisplacementMapFilterMode.CLAMP,
                    0,
                    0
                )
            );
            _shinecanvas.unlock();
            
            var mat:Matrix = new Matrix();
            mat.createBox( 
                1.3,
                1.3,
                0,
                -(_canvas.width * 1.3 - _canvas.width) / 2,
                -(_canvas.height * 1.3 - _canvas.height) / 2
            );
            _canvas.lock();
            _canvas.fillRect(_canvas.rect, 0 );
            _canvas.draw( _shinecanvas );
            _canvas.draw( _buffercanvas, mat, color );        
            _canvas.unlock();
            _buffercanvas.lock();
            _buffercanvas.fillRect( _buffercanvas.rect, 0 );
            _buffercanvas.draw( _canvas );
            _buffercanvas.applyFilter( _buffercanvas, _shinecanvas.rect, new Point(), _blurfilter );    
            _buffercanvas.unlock();
                        
            if ( _step % 1 == 0 )    AddShine();    
            _step++;
            
//    Map Data
            Wave();
        }
        
        private function AddShine() : void
        {
            var shine:ShineParticle = new ShineParticle();
            var angle:Number = Math.random() * 360;
            var len:Number = 1;
           // var x:Number = Math.cos( angle * Math.PI / 180 ) * len + SUN_X;
           // var y:Number = Math.sin( angle * Math.PI / 180 ) * len + SUN_Y;
            shine.x = mouseX;
            shine.y = mouseY;        
            _shinelist.push( shine );
        }
        
        private function Wave() : void
        {
            _waveOffset.x += 2;
            _waveOffset.y += 2;
            
            _wave.perlinNoise(
                50,
                50,
                1,
                128,
                true,
                true,
                1,
                false,
                [_waveOffset]
            );
        }
    }
}
import flash.display.Shape;

const WIDTH:Number = 465;
const HEIGHT:Number = 465;

class ShineParticle {
    public var x:Number;
    public var y:Number;
    public var size:Number;
    public var life:Number;
    
    public var shape:Shape;
    
    public function ShineParticle() {
        size = Math.random() * 10 + 1;
        life = Math.random() * 30 + 20;
        x = 0;
        y = 0;
        shape = new Shape();
        shape.graphics.beginFill( 0xFFFFFF );
        shape.graphics.drawCircle( 0, 0, size );
        shape.graphics.endFill();
    }
    public function Update() : void
    {
        life--;
    }
}
