/**
 * Copyright bennett.yeates ( http://wonderfl.net/user/bennett.yeates )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k6k6
 */

package {
    import flash.display.Bitmap;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.Event;
    
    [SWF(backgroundColor=0)]
    public class TilesTest extends Sprite {
        
        private var tiles:Vector.<BitmapData>;
        private var shape:Shape;
        private var currentX:int;
        private var currentAngle:Number;
        
        public function TilesTest() {
           shape = new Shape();
           addChild( shape );
           tiles = new Vector.<BitmapData>(); 
            
           currentAngle = 0;
           drawBackground( 3 );
           addEventListener( Event.ENTER_FRAME, oef ); 
        }
        
        private function drawBackground( layers:int ):void {
            var i:int;
            
            var bmd:BitmapData = new BitmapData( 12, 12 );
            var ct:ColorTransform = new ColorTransform( 0.4, 0.4, 0.4, 1 );
            bmd.fillRect( new Rectangle(1, 1, 9, 9), 0x0F666666 );
            
            for ( ; i < layers; ++i ) {
                bmd.colorTransform( bmd.rect, ct );
                tiles.push( bmd );
                bmd = bmd.clone();
            } 
        }

        
        private function oef( e:Event ):void {
            shape.graphics.clear();            
            var i:int;
            for ( ; i < tiles.length; ++i ) {
                var m:Matrix = new Matrix();
                m.identity();
                m.translate( i * (++currentX/5) + 1, 0 );
                m.scale( i*3+10, i*3+10 );
                m.rotate( getAngle() );
                shape.graphics.beginBitmapFill( tiles[i], m );
                shape.graphics.drawRect( 0, 0, 465, 465 );
                shape.graphics.endFill();
            }
        }
        
        private function getAngle():Number {
           currentAngle += 0.1; 
           return currentAngle * Math.PI / 180; 
        }


    }
}