/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k6IC
 */

// forked from yprops's DebugText
package {
    import flash.net.URLVariables;
    import flash.events.*;
    import flash.utils.*;
    import flash.display.*;
    import flash.text.*;
    public class DebugText extends Sprite {
        private var box :TextField;
        
        public function DebugText() {
            addDeb(450, 400);
            deb.y = 50;
            
            box = new TextField();
            box.type = TextFieldType.INPUT;
            box.border = true;
            box.background = true;
            box.width = 450;
            box.height = 30;
            box.x = 0;
            box.y = 0;
            box.text = "テストテキスト";
            box.addEventListener(Event.CHANGE, redraw);
            
            addChild(box);
            
            redraw();
        }
        
        private function redraw(ev:Event = null) :void{
            deb.text = "";
            var basestr :String = box.text;
            var str :String;
            addDebLine("元の文字列", basestr);
            str = escape(basestr);
            addDebLine("escape()", str);
            addDebLine("\t→unescape()", unescape(str));
            addDebLine("\t→unescapeMultiByte()", unescapeMultiByte(str));
            addDebLine();
            
            addDebLine("元の文字列", basestr);
            str = escapeMultiByte(basestr);
            addDebLine("escapeMultiByte()", str);
            addDebLine("\t→unescape()", unescape(str));
            addDebLine("\t→unescapeMultiByte()", unescapeMultiByte(str));
            addDebLine();
            
        }
        //-------------------------------
        private var deb :TextField;
        private function addDeb(w:uint, h:uint) :void{
                deb = new TextField();
                deb.wordWrap = true;
                deb.width = w;
                deb.height = h;
                deb.border = true;
                deb.borderColor = 0;
                deb.background = true;
                deb.backgroundColor = 0x99ffffff;
                deb.text = "beginDebugText-------\n";
                addChild(deb);
        }
        private function addDebLine(...args) :void{
                deb.appendText(args.join("\t") + "\n");
                deb.scrollV = deb.maxScrollV;
        }
    }
}