/**
 * Copyright Jacky.Riawan ( http://wonderfl.net/user/Jacky.Riawan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k5f1
 */

//click to shoot
//left-right - accelerate/decelerate
//up - down - rotate tank
package
{
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2CircleDef;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.Joints.b2DistanceJoint;
    import Box2D.Dynamics.Joints.b2DistanceJointDef;
    import Box2D.Dynamics.Joints.b2RevoluteJoint;
    import Box2D.Dynamics.Joints.b2RevoluteJointDef;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    /**
     * ...
     * @author Jacky Riawan
     */
    public class tank extends Sprite
    {
        private const ratio:uint=30
        private var world:b2World;
        private var main:b2Body;
        private var speed:Number=0
        private var jointR:b2RevoluteJoint;
        private var jointL:b2RevoluteJoint;
        private var sprite:Sprite;
        public function tank()
        {
            setupWorld()
            setupDebugDraw()
            putTank(50, 350)
            setupLevel()
            
            for (var j:int = 0; j < 10; j++) {
                addChain(203+j*150,290,20)
                putBuilding(250 + j * 120, 391, 1, uint(20 * Math.random() + 5))
                
            }
            world.Step(1/20,10)
            addEventListener(Event.ENTER_FRAME, update)
            stage.addEventListener(MouseEvent.CLICK, doClick)
            stage.addEventListener(KeyboardEvent.KEY_DOWN,dostuff)
        }
        
        private function dostuff(e:KeyboardEvent):void 
        {
            if (e.keyCode == 37) {//left
                speed--
            }else if (e.keyCode == 39) {//right
                speed+=3
            }
            if (e.keyCode == 38) {
                main.SetAngularVelocity(-1)
            }else if (e.keyCode == 40) {
                main.SetAngularVelocity(1)
            }
        }
        
        private function doClick(e:MouseEvent):void 
        {
            shoot()
        }
        
        private function shoot():void
        {
            var bulletBodyDef:b2PolygonDef = new b2PolygonDef()
            bulletBodyDef.SetAsBox(3/ratio, 2/ratio)
            bulletBodyDef.density=200
            var bulletBD:b2BodyDef = new b2BodyDef()
            var myPos:b2Vec2 = main.GetWorldPoint(new b2Vec2(23 / ratio, -14 / ratio))
            var myPos2:b2Vec2 = main.GetWorldPoint(new b2Vec2(100 / ratio, -30 / ratio))
            bulletBD.position.SetV(myPos)
            var bullet:b2Body = world.CreateBody(bulletBD)
            bullet.CreateShape(bulletBodyDef)
            bullet.SetMassFromShapes()
            myPos2.Subtract(myPos)
            myPos2.Multiply(3)
            bullet.SetBullet(true)
            bullet.SetLinearVelocity(myPos2)
        }

        private function setupLevel():void
        {
            var groundShape:b2PolygonDef = new b2PolygonDef()
            groundShape.SetAsBox(1250 / ratio, 10 / ratio)
            var groundBD:b2BodyDef = new b2BodyDef()
            groundBD.position.Set(1250 / ratio, 400 / ratio)
            var ground:b2Body = world.CreateBody(groundBD)
            ground.CreateShape(groundShape)
            ground.SetMassFromShapes()
        }

        private function update(e:Event):void
        {
            sprite.y=300-main.GetPosition().y*ratio
            sprite.x=200-main.GetPosition().x*ratio
            speed*=.9
            jointL.SetMotorSpeed(speed)
            jointR.SetMotorSpeed(speed)
            world.Step(1/20,10)
        }
        private function putBuilding(posx:Number,posy:Number,width:int,height:int) {
            var blokShape:b2PolygonDef = new b2PolygonDef()
            blokShape.SetAsBox(1.5 / ratio, 1.5 / ratio)
            blokShape.density = Math.random()*10
            blokShape.friction = 1
            blokShape.restitution=0
            for (var x:uint = 0; x < width; x++) {
                for (var y:uint = 0; y < height; y++) {
                    blokShape.density*=1.1
                    var BD:b2BodyDef = new b2BodyDef()
                    BD.position.Set((posx + x * 3) / ratio, (posy - y * 3.03) / ratio)
                    var body:b2Body = world.CreateBody(BD)
                    body.CreateShape(blokShape)
                    body.PutToSleep()
                    body.SetMassFromShapes()
                }
            }
        }
        private function putTank(posx:int,posy:int):void
        {
            //tankbody
            var cannon:b2PolygonDef = new b2PolygonDef()
            cannon.SetAsOrientedBox(10 / ratio, 3 / ratio, new b2Vec2(22 / ratio, -15 / ratio), 0)
            cannon.density = 40
            var turret:b2PolygonDef = new b2PolygonDef()
            turret.SetAsOrientedBox(13 / ratio, 7 / ratio, new b2Vec2(0, -14 / ratio))
            turret.density=40
            var mainBody:b2PolygonDef = new b2PolygonDef()
            mainBody.SetAsBox(30 / ratio, 10 / ratio)
            mainBody.density = 40
            var mainBD:b2BodyDef = new b2BodyDef()
            mainBD.position.Set(posx / ratio, posy / ratio)
            main = world.CreateBody(mainBD)
            main.CreateShape(mainBody) 
            main.CreateShape(turret)
            main.CreateShape(cannon)
            main.SetMassFromShapes()
            //
            var wheelShape:b2CircleDef = new b2CircleDef()
            wheelShape.radius = 13 / ratio
            wheelShape.density = 40
            wheelShape.friction=1
            // left wheel
            var wheelBDL:b2BodyDef=new b2BodyDef()
            wheelBDL.position.Set((posx - 20) / ratio, (posy + 10) / ratio)
            var wheelL:b2Body = world.CreateBody(wheelBDL)
            wheelL.CreateShape(wheelShape)
            wheelL.SetMassFromShapes()
            //left joint
            var revJointL:b2RevoluteJointDef = new b2RevoluteJointDef()
            revJointL.Initialize(main, wheelL, wheelL.GetPosition())
            jointL = world.CreateJoint(revJointL) as b2RevoluteJoint
            jointL.EnableMotor(true)
            jointL.SetMaxMotorTorque(100)
            //right wheel
            var wheelBDR:b2BodyDef=new b2BodyDef()
            wheelBDR.position.Set((posx + 20) / ratio, (posy + 10) / ratio)
            var wheelR:b2Body = world.CreateBody(wheelBDR)
            wheelR.CreateShape(wheelShape)
            wheelR.SetMassFromShapes()
            //right joint
            var revJointR:b2RevoluteJointDef = new b2RevoluteJointDef()
            revJointR.Initialize(main, wheelR, wheelR.GetPosition())
            jointR = world.CreateJoint(revJointR) as b2RevoluteJoint
            jointR.EnableMotor(true)
            jointR.SetMaxMotorTorque(100)
            

            
        }
        private function addChain(posx:int, posy:int,num:uint) {
            // create chain
            var chainShape:b2PolygonDef = new b2PolygonDef()
            chainShape.density=1
            chainShape.SetAsBox(.5 / ratio, 3 / ratio)
            var chainList:Array = new Array()
            var chainBD:b2BodyDef
            var chain:b2Body
            //create anchor
            var anchorBD:b2BodyDef = new b2BodyDef()
            anchorBD.position.Set(posx / ratio, posy / ratio)
            var anchor:b2Body = world.CreateBody(anchorBD)
            anchor.SetMassFromShapes()
            chainList.push(anchor)
            //chain body
            for (var i:int=0; i < num; i++) {
                chainBD = new b2BodyDef()
                chainBD.position.Set((posx) / ratio, (posy+3+i*3) / ratio)
                chain = world.CreateBody(chainBD)
                chain.CreateShape(chainShape)
                chain.SetMassFromShapes()
                chainList.push(chain)
            }
            //link chains
            var B2:b2Body
            var B1:b2Body
            var distanceJointD:b2RevoluteJointDef
            var distJoint:b2RevoluteJoint
            for (i = 0; i < chainList.length-1; i++) {
                B1 = chainList[i]
                B2=chainList[i+1]
                distanceJointD = new b2RevoluteJointDef()
                if (i == 0) {
                    distanceJointD.Initialize(B1, B2, new b2Vec2(posx / ratio, (posy) / ratio))
                }else{
                    distanceJointD.Initialize(B1, B2, new b2Vec2(posx / ratio, (posy + i * 3) / ratio))
                }
                distJoint=world.CreateJoint(distanceJointD) as b2RevoluteJoint
            }
        }
        private function setupDebugDraw():void
        {
            sprite = new Sprite()
            addChild(sprite)
            var debugDraw:b2DebugDraw = new b2DebugDraw()
            debugDraw.m_drawScale = ratio
            debugDraw.m_sprite = sprite
            debugDraw.SetFlags(b2DebugDraw.e_shapeBit)
            world.SetDebugDraw(debugDraw)
        }

        private function setupWorld():void
        {
            var AABB:b2AABB = new b2AABB()
            AABB.upperBound.Set( 3000 / ratio, 1000 / ratio)
            AABB.lowerBound.Set(-1000 / ratio, -1000 / ratio)
            world = new b2World(AABB, new b2Vec2(0, 2), false)

        }
    }

}
