/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k5KE
 */

package {
    import flash.display.*;
    import flash.events.*;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var bmd:BitmapData = new BitmapData(465, 465, false, 0x0);
            var bmp:Bitmap = new Bitmap(bmd);
            addChild(bmp);
            
            var particles:Array = [];
            for(var i:int=0; i<1000; i++) {
                var p:Particle = new Particle();
                p.x = 465 / 2;
                p.y = 465 / 2;
                p.vx = 10 * (Math.random() - 0.5);
                p.vy = 10 * (Math.random() - 0.5);
                p.color = 0xffffff;
                particles[i] = p;
            }
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            function enterFrameHandler(e:Event):void {
                bmd.fillRect(bmd.rect, 0x000000);
                
                for(var i:int=0; i<particles.length; i++) {
                    var p:Particle = particles[i];
                    
                    p.x += p.vx;
                    p.y += p.vy;
                    bmd.setPixel(p.x, p.y, p.color);
                }
            }            
        }
    }
}

class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var color:uint;
}
