/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k5DC
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    [SWF(width = 465, height = 465, frameRate = 60)]
    public class PixelArt extends Sprite {
        private const WIDTH:int = 465;
        private const HEIGHT:int = 465;
        private var prevMouseX:int;
        private var prevMouseY:int;
        private var world:BitmapData;
        private var rect:Rectangle;
        private var mousePressed:Boolean;
        private var useVector:Boolean;
        private var line:Shape;
        private var g:Graphics;
        private var dbg:Debug;
        public function PixelArt() {
            initialize();
        }

        private function initialize():void {
            stage.quality = StageQuality.LOW;
            world = new BitmapData(WIDTH, HEIGHT, false, 0);
            addChild(new Bitmap(world));
            rect = world.rect;
            stage.addEventListener(MouseEvent.MOUSE_DOWN,
                function():void {
                    mousePressed = true;
                });
            stage.addEventListener(MouseEvent.MOUSE_UP,
                function():void {
                    mousePressed = false;
                });
            stage.addEventListener(KeyboardEvent.KEY_UP,
                function():void {
                    useVector = !useVector;
                    dbg.lbStr = "useVector: " + String(useVector) + "\n";
                });
            line = new Shape();
            g = line.graphics;
            dbg = new Debug("useVector: " + String(useVector) + "\n");
            stage.addChild(dbg);
            addEventListener(Event.ENTER_FRAME, frame);
        }

        private function frame(e:Event):void {
            dbg.startSample();
            var i:int,
                j:int,
                r:int = WIDTH - 1,
                b:int = HEIGHT - 1;
            world.lock();
            if(mousePressed) {
                g.clear();
                g.beginFill(0xffffff);
                g.drawCircle(mouseX, mouseY, 3);
                g.endFill();
                g.lineStyle(10, 0xffffff);
                g.moveTo(prevMouseX, prevMouseY);
                g.lineTo(mouseX, mouseY);
                g.lineStyle(0);
                g.drawRect(0, 0, r, b);
                world.draw(line);
            }
            prevMouseX = mouseX;
            prevMouseY = mouseY;
            if (useVector) {
                var v:Vector.<uint> = world.getVector(rect);
                for(i = 1; i < r; i++) {
                    for(j = 1; j < b; j++) {
                        var p:int = i + j * WIDTH;
                        v[p] = (
                              v[p - 1 >> 0]
                            + v[p + 1 >> 0]
                            + v[p - WIDTH >> 0]
                            + v[p + WIDTH >> 0]
                        ) >> 2;
                    }
                }
                world.setVector(rect, v);
            } else {
                for(i = 1; i < r; i++) {
                    for(j = 1; j < b; j++) {
                        world.setPixel(i, j, (
                              world.getPixel(i - 1, j    )
                            + world.getPixel(i    , j - 1)
                            + world.getPixel(i + 1, j    )
                            + world.getPixel(i    , j + 1)
                        ) >> 2);
                    }
                }
            }
            world.unlock();
            dbg.endSample();
        }
    }
}

import flash.text.TextField;
import flash.utils.getTimer;
class Debug extends TextField
{
    private static const NUM_SAMPLE:int = 60;
    
    public var lbStr:String;
    
    private var cCnt:int;
    private var cPre:int;
    private var sCnt:int;
    private var sPre:int;
    private var sVec:Vector.<int>;
    private var output:Boolean;
    
    public function Debug(labelText:String = "")
    {
        autoSize = "left";
        border = true;
        background = true;
        lbStr = labelText;
        sVec = new Vector.<int>(NUM_SAMPLE, true);
    }
    
    public function startSample():void
    {
        var cur:int = getTimer();
        cCnt++;
        if (cur - cPre >= 1000) {
            cPre = cur;
            output = true;
        }
        sPre = cur;
    }
    
    public function endSample():void
    {
        var cur:int = getTimer();
        sVec[sCnt]  = cur - sPre;
        sCnt = (sCnt + 1) % NUM_SAMPLE;
        if (output) {
            for (var i:int, sum:int; i < NUM_SAMPLE; i++) sum += sVec[i];
            text = lbStr + String(cCnt) + "\n" + String(sum);
            cCnt = 0;
            output = false;
        }
    }
}
