/**
 * Copyright takawo ( http://wonderfl.net/user/takawo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k5Br
 */

// forked from takawo's flash on 2009-6-21
package  {
    import flash.display.Stage;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.display.Sprite;
    import flash.events.Event;

    [SWF(backgroundColor="#CCCCCC", frameRate="60")]

    public class LoadImage extends Sprite {
        //--------------------------------------
        // CLASS CONSTANTS
        //--------------------------------------

        //--------------------------------------
        //  CONSTRUCTOR
        //--------------------------------------
        public function LoadImage()
        {
            //Stage設定//
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;

            //XMLファイルを読み込む
            _xmlLoader = new XMLLoader("http://ttttest.net/study/photo.xml");

            //イベントリスナーの登録
            _xmlLoader.addEventListener(XMLLoader.LOAD_COMPLETE, onXMLloaded);
        }

        //--------------------------------------
        //  PRIVATE VARIABLES
        //--------------------------------------
        private var _xmlLoader:XMLLoader;
        private var _photoXml:XML;
        private var _photoWidth:Number = 240;
        private var _photoHeight:Number = 180;

        //--------------------------------------
        //  GETTER/SETTERS
        //--------------------------------------

        //--------------------------------------
        //  PUBLIC METHODS
        //--------------------------------------

        //--------------------------------------
        //  EVENT HANDLERS
        //--------------------------------------
        //XMLロード完了後実行
        private function onXMLloaded(event:Event):void {
            //ロードしたXMLを取得
            _photoXml = _xmlLoader.getXML();

            //XMLに記述されたURLの数だけ繰り返し
            var i:int = 0;
            for each (var url:String in _photoXml.photoURL){
                    //イメージをロードしてグリッド状に配置
                    var img:ImageLoader = new ImageLoader(url, _photoWidth, _photoHeight);
                    img.x = (i%3)*_photoWidth;
                    img.y = int(i/3)*_photoHeight;
                    addChild(img);
                    i++;
                }
        }

        //--------------------------------------
        //  PRIVATE & PROTECTED INSTANCE METHODS
        //--------------------------------------
    }
}
    import flash.events.EventDispatcher;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.System;
    import flash.events.Event;

    class XMLLoader extends EventDispatcher {

        //--------------------------------------
        // CLASS CONSTANTS
        //--------------------------------------
        public static const LOAD_COMPLETE:String = "load_complete";

        //--------------------------------------
        //  CONSTRUCTOR
        //--------------------------------------
        public function XMLLoader(url:String)
        {
            //URLLoader作成
            _xmlLoader = new URLLoader();
            _xmlLoader.dataFormat = URLLoaderDataFormat.TEXT;
            _xmlLoader.addEventListener(Event.COMPLETE, onXMLloaded);
            //URL
            var urlReq:URLRequest = new URLRequest(url);
            //読み込み開始
            _xmlLoader.load(urlReq);
        }

        //--------------------------------------
        //  PRIVATE VARIABLES
        //--------------------------------------
        private var _xmlLoader:URLLoader;
        private var _my_xml:XML;

        //--------------------------------------
        //  GETTER/SETTERS
        //--------------------------------------

        //--------------------------------------
        //  PUBLIC METHODS
        //--------------------------------------

        //XMLオブジェクトを返す（他のクラスからのアクセスに対応）
        public function getXML():XML{
            return _my_xml;
        }

        //--------------------------------------
        //  EVENT HANDLERS
        //--------------------------------------

        //読み込み完了
        private function onXMLloaded(event:Event):void {
            try {
                //XMLオブジェクトに変換する
                _my_xml = new XML(_xmlLoader.data);
                //カスタムイベントを配信する
                dispatchEvent(new Event(LOAD_COMPLETE));
            } catch (err:TypeError) {
                trace(err.message);
            }
        }
    }
    
   //表示関連
    import flash.display.Sprite;

    //外部ファイル読み込み関連のパッケージ
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.ProgressEvent;
    import flash.events.IOErrorEvent;

    //テキストフィールド関連パッケージ
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;

    class ImageLoader extends Sprite {

        //--------------------------------------
        // CLASS CONSTANTS
        //--------------------------------------

        //--------------------------------------
        //  CONSTRUCTOR
        //--------------------------------------
        public function ImageLoader(url:String, w:Number, h:Number)
        {
            //パラメータを格納
            _url = url;
            _width = w;
            _height = h;

            //％表示フィールド表示
            setupPercentField();

            //loader作成
            _imgLoader = new Loader();
            addChild(_imgLoader);

            //イベントリスナー定義
            _imgLoader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, onProgress); //読みこみ中
            _imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE,onLoaded); //読みこみ完了


            //読み込み開始
            var urlReq:URLRequest=new URLRequest(_url);
            _imgLoader.load(urlReq);
        }

        //--------------------------------------
        //  PRIVATE VARIABLES
        //--------------------------------------

        private var _url:String;
        private var _imgLoader:Loader;
        private var _perFld:TextField;
        private var _width:Number;
        private var _height:Number;

        //--------------------------------------
        //  GETTER/SETTERS
        //--------------------------------------

        //--------------------------------------
        //  PUBLIC METHODS
        //--------------------------------------

        //--------------------------------------
        //  EVENT HANDLERS
        //--------------------------------------

        //読み込み完了
        private function onLoaded(event:Event):void {
            //プログレスフィールド削除
            removeChild(_perFld);
            _perFld = null;
            _imgLoader.width = _width;
            _imgLoader.height = _height;
        }

        //ロード経過表示
        private function onProgress(event:ProgressEvent):void {
            var per:Number = Math.round(event.bytesLoaded/event.bytesTotal*100);
            _perFld.text = per + " %";
        }

        //--------------------------------------
        //  PRIVATE & PROTECTED INSTANCE METHODS
        //--------------------------------------

        //%フィールド作成
        private function setupPercentField():void {
            _perFld = new TextField();
            _perFld.x = 20;
            _perFld.y = 20;
            _perFld.autoSize = TextFieldAutoSize.LEFT;
            var textFormat:TextFormat = new TextFormat();
            textFormat.font = "verdana";
            textFormat.size = 10;
            _perFld.defaultTextFormat = textFormat;
            addChild(_perFld);
        }
    }

    