/**
 * Copyright Horiuchi_H ( http://wonderfl.net/user/Horiuchi_H )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k4xT
 */

package  
{
	import flash.display.SimpleButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TextEvent;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	
	[SWF(width = 465, height = 465, backgroundColor = 0xEEEEEE, frameRate = 24)]
	
        /**
        * 左のTextFieldに10進の数値を入力すると、16進に変換して右のフィールドに表示します。
        * また、0xで始まる16進の数値や、0bで始まる2進の数値、0で始まる8進の数値のいずれかが
        *　入力された場合には、10進に変換して出力します。
        *
        * 扱える数値は、9007199254740992(2^53) までです。
        */
	public class ConvertNumber extends Sprite
	{
		private var inputField:TextField = createInputField();
		private var outputField:TextField = createOutputField();
		
		public function ConvertNumber() 
		{
			addChild(inputField);
			addChild(createConvertLabel());
			addChild(outputField);
		}
		
		public function convertNumber(event:Event):void
		{
			var input:String = inputField.text;
			var matched:Array = input.match(/^0(?:x|)(?:\d+)/i);
			if (matched != null) {
				outputField.text = Number(input).toString();
			} else {
				outputField.text = Number(input).toString(16);
			}
		}
		
		private function createInputField():TextField
		{
			var field:TextField = new TextField();
			field.type = TextFieldType.INPUT;
			field.width = 150;
			field.height = 20;
			field.text = "Type convert value.";
			field.x = 10;
			field.y = 10;
			field.background = true;
			field.addEventListener(Event.CHANGE, convertNumber);
			return field;
		}
		
		private function createConvertLabel():TextField
		{
			var field:TextField = new TextField();
			field.text = "→";
			field.x = 170;
			field.y = 10;
			return field;
		}
		
		private function createOutputField():TextField
		{
			var field:TextField = new TextField();
			field.width = 150;
			field.height = 20;
			field.x = 200;
			field.y = 10;
			field.background = true;
			return field;
		}
		
		private function createConvertButton():SimpleButton
		{
			var button:SimpleButton = new SimpleButton();
			return button;
		}
	}
}
