/**
 * Copyright 084 ( http://wonderfl.net/user/084 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k3o3
 */

package {
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.text.TextField;
	public class MouseDistance extends Sprite {
		private var sprite1:Sprite;
		private var textField:TextField;
		private var color24:Number = 0x00 << 16 | 0x55 << 8 | 0xf3;
		public function MouseDistance() {
			init();
		}
		private function init():void {
			sprite1 = new Sprite();
			addChild(sprite1);
			sprite1.graphics.beginFill(color24);
			sprite1.graphics.drawRect( -2, -2, 4, 4);
			sprite1.graphics.endFill();
			sprite1.x = stage.stageWidth / 2;
			sprite1.y = stage.stageHeight / 2;
			
			textField = new TextField();
			addChild(textField);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
		}
		public function onMove(event:MouseEvent):void {
			graphics.clear();
			graphics.lineStyle(1, color24 , 1);
			graphics.moveTo(sprite1.x, sprite1.y);
			graphics.lineTo(mouseX, mouseY);
			var dx:Number = sprite1.x - mouseX;
			var dy:Number = sprite1.y - mouseY;
			var dist:Number = Math.sqrt(dx * dx + dy * dy);
			textField.text = dist.toString();
		}
	}
}