/**
 * Copyright ookubo625 ( http://wonderfl.net/user/ookubo625 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k3NN
 */

// forked from ProjectNya's Firefly3D
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] Fireflyクラスに挑戦！ (4)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=941
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private static var max:uint = 40;
        private static var cx:int = 232;
        private static var cy:int = 232;
        private static var cz:int = 0;
        private var perspective:Perspective;
        private static var radius:uint = 70;

        public function Main() {
            Wonderfl.capture_delay(2);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            perspective = new Perspective();
            perspective.init(cx, cy);
            for (var n:uint = 0; n < max; n++) {
                var firefly:Object3D = new Object3D();
                perspective.register(firefly, n);
                var angle:Number = 360/max*n;
                firefly.init(0, 0, 0, angle);
                firefly.size(1.5, 0.5, 1);
                addChild(firefly);
                var a:Number = (n%2*2 - 1)*3/(n+1);
                var rx:Number = n+1;
                var ry:Number = 4;
                var rz:Number = n+2;
                firefly.fly(150, a, rx, ry, rz, 0.2);
            }
            perspective.screen(0, radius*2);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            perspective.transform();
        }

    }

}


class Perspective {
    private var objList:Array;
    private var fl:Number = 250;
    private var vp:Object;
    private var view:Object;
    private var ax:Number = 0;
    private var ay:Number = 0;
    private var az:Number = 0;
    private var brighted:Boolean = false;
    private var front:Number = -100;
    private var back:Number = 100;
    private var depthList:Array;

    public function Perspective() {
        objList = new Array();
        vp = {x: 0, y: 0};
        view = {x: 0, y: 0, z: 0};
        depthList = new Array();
    }

    public function init(x:int, y:int):void {
        vp = {x: x, y: -y};
    }
    public function register(obj:Object3D, n:uint):void {
        objList.push(obj);
        obj.id = n;
    }
    public function transform():void {
        for (var n:uint = 0; n < objList.length; n++) {
            var obj:Object3D = objList[n];
            setPerspective(obj);
        }
        manageDepths();
    }
    private function setPerspective(obj:Object3D):void {
        if (obj.pz + view.z > - fl + 50) {
            var scale:Number = fl/(fl + obj.pz + view.z);
            obj.scale = scale;
            obj.x = vp.x + (obj.px - view.x)*scale;
            obj.y = - vp.y - (obj.py + view.y)*scale;
            if (brighted) obj.brightness = -100*(obj.pz + view.z - front)/(back - front);
            obj.visible = true;
        } else {
            obj.visible = false;
        }
    }
    private function manageDepths():void {
        objList.sortOn(["pz", "id"], [Array.DESCENDING | Array.NUMERIC, Array.DESCENDING | Array.NUMERIC]);
        for (var n:uint = 0; n < objList.length; n++) {
            var obj:Object3D = objList[n];
            obj.stage.addChildAt(obj, n+1);
        }
    }
    public function screen(f:Number, b:Number):void {
        if (front == back) {
            brighted = false;
        } else {
            brighted = true;
            front = f;
            back = b;
        }
    }
    public function setView(x:Number, y:Number, z:Number):void {
        view.x = x;
        view.y = -y;
        view.z = -z;
        transform();
    }

}


import flash.display.Sprite;
import flash.geom.ColorTransform;
import flash.events.Event;

class Object3D extends Sprite {
    private var firefly:Firefly;
    private var blink:Number;
    private var b:Number;
    private static var color1:uint = 0xCCFF00;
    private static var color2:uint = 0x66FF00;
    private var trans:ColorTransform;
    public var id:uint;
    public var px:Number;
    public var py:Number;
    public var pz:Number;
    private var tx:Number;
    private var ty:Number;
    private var tz:Number;
    private var cx:Number;
    private var cy:Number;
    private var cz:Number;
    private var sx:Number = 1;
    private var sy:Number = 1;
    private var sz:Number = 1;
    private var r:Number;
    private var angle:Number;
    private var a:Number;
    private var rx:Number;
    private var ry:Number;
    private var rz:Number;
    private static var radian:Number = Math.PI/180;
    private static var deceleration:Number = 0.2;
    private var _scale:Number = 1;
    private var colorTrans:ColorTransform;
    private var _brightness:Number = 0;

    public function Object3D() {
        firefly = new Firefly();
        addChild(firefly);
        trans = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
        colorTrans = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
    }

    public function init(x:int, y:int, z:int, a:Number):void {
        px = cx = x;
        py = cy = y;
        pz = cz = z;
        angle = a;
        _blink(angle, 10);
    }
    public function size(x:Number, y:Number, z:Number):void {
        if (x) sx = x;
        if (y) sy = y;
        if (z) sz = z;
    }
    private function _blink(blink:Number, b:Number):void {
        this.blink = blink;
        this.b = b;
    }
    private function blinking():void {
        blink += b;
        setRGB(Math.sin(blink*radian));
        firefly.transform.colorTransform = trans;
    }
    private function setRGB(percent:Number):void {
        var r1:int = (color1 >> 16 & 0xFF);
        var g1:int = (color1 >> 8 & 0xFF);
        var b1:int = (color1 & 0xFF);
        var r2:int = (color2 >> 16 & 0xFF);
        var g2:int = (color2 >> 8 & 0xFF);
        var b2:int = (color2 & 0xFF);
        trans.alphaMultiplier = 0.75 + 0.5*percent;
        trans.redOffset = (r1 + r2)*0.5 + (r2 - r1)*0.5*percent;
        trans.greenOffset = (g1 + g2)*0.5 + (g2 - g1)*0.5*percent;
        trans.blueOffset = (b1 + b2)*0.5 + (b2 - b1)*0.5*percent;
    }
    public function fly(r:Number, a:Number, rx:Number, ry:Number, rz:Number, dec:Number):void {
        this.r = r;
        this.a = a;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        deceleration = dec;
        addEventListener(Event.ENTER_FRAME, flying, false, 0, true);
    }
    private function flying(evt:Event):void {
        blinking();
        angle += a;
        tx = cx + r*Math.sin(angle*rx*radian)*Math.cos(angle*radian)*sx;
        ty = cy + r*Math.sin(angle*ry*radian)*sy;
        tz = cz + r*Math.sin(angle*rz*radian)*Math.sin(angle*radian)*sz;
        px += (tx - px)*deceleration;
        py += (ty - py)*deceleration;
        pz += (tz - pz)*deceleration;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }
    public function get brightness():Number {
        return _brightness;
    }
    public function set brightness(param:Number):void {
        _brightness = param;
        var percent:Number = 100 - Math.abs(param);
        var offset:Number = (param > 0) ? (255*param*0.01) : 0;
        setColorTrans(percent, offset);
    }
    private function setColorTrans(percent:Number, offset:Number):void {
        colorTrans.redMultiplier = percent*0.01;
        colorTrans.greenMultiplier = percent*0.01;
        colorTrans.blueMultiplier = percent*0.01;
        colorTrans.redOffset = offset;
        colorTrans.greenOffset = offset;
        colorTrans.blueOffset = offset;
        colorTrans.alphaMultiplier = alpha;
        colorTrans.alphaOffset = 0;
        this.transform.colorTransform = colorTrans;
    }

}


import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;

class Firefly extends Shape {
    private static var center:Number = 2.5;
    private static var light:Number = 12;
    private static var color:uint = 0xFFFFFF;

    public function Firefly() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, center);
        graphics.endFill();
        var colors:Array = [color, color];
        var alphas:Array = [0.6, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(light*2, light*2, 0, -light, -light);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix);
        graphics.drawCircle(0, 0, light);
        graphics.endFill();
    }

}
