/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k2go
 */

// forked from bradsedito's forked from: DotLight + SoundMixer (6)
// forked from ProjectNya's DotLight + SoundMixer (6)
////////////////////////////////////////////////////////////////////////////////
// DotLight + SoundMixer (6)
//
// [AS3.0] ドットの光 (4)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1093
//
// 参照 : Force Field [http://wonderfl.net/c/71Zy]
// 参照 : Force Field with Bresenham's line and Sparkle [http://wonderfl.net/c/lTpz]
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageDisplayState;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    //import net.hires.debug.Stats;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private var base:Shape;
        private var light:DotLight;
        private var controller:Sprite;
        private var fullscreenBtn:Btn;
        private var normalBtn:Btn;

        public function Main() {
            Wonderfl.capture_delay(45);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.MEDIUM;
            stage.addEventListener(Event.RESIZE, resize, false, 0, true);
            init();
            //addChild(new Stats());
        }

        private function init():void {
            base = new Shape();
            addChild(base);
            base.graphics.beginFill(0x000000);
            base.graphics.drawRect(0, 0, 465, 465);
            base.graphics.endFill();
            //
            light = new DotLight(new Rectangle(0, 0, 1000, 750));
            addChild(light);
            //light.start();
            //
            controller = new Sprite();
            addChild(controller);
            controller.x = 232;
            controller.y = 445;
            fullscreenBtn = new Btn();
            controller.addChild(fullscreenBtn);
            fullscreenBtn.init({label: "full screen", type: 2, width: 100});
            fullscreenBtn.addEventListener(MouseEvent.CLICK, click, false, 0, true);
            normalBtn = new Btn();
            controller.addChild(normalBtn);
            normalBtn.init({label: "normal", type: 2, width: 100});
            normalBtn.addEventListener(MouseEvent.CLICK, click, false, 0, true);
            normalBtn.visible = false;
            resize();
        }
        private function resize(evt:Event = null):void {
            update();
            screenMode();
        }
        private function update():void {
            var sw:uint = stage.stageWidth;
            var sh:uint = stage.stageHeight;
            base.width = sw;
            base.height = sh;
            var xscale:Number = sw/1000;
            var yscale:Number = sh/750;
            var scale:Number = Math.max(1, Math.max(xscale, yscale));
            light.x = - int((1000*scale - sw)/2);
            light.y = - int((750*scale - sh)/2);
            light.scaleX = light.scaleY = scale;
            controller.x = uint(sw/2);
            controller.y = sh - 20;
        }
        private function screenMode():void {
            if (stage.displayState == StageDisplayState.NORMAL) {
                fullscreenBtn.visible = true;
                normalBtn.visible = false;
            } else {
                fullscreenBtn.visible = false;
                normalBtn.visible = true;
            }
        }
        private function click(evt:MouseEvent):void {
            if (stage.displayState == StageDisplayState.NORMAL) {
                stage.displayState = StageDisplayState.FULL_SCREEN;
            } else {
                stage.displayState = StageDisplayState.NORMAL;
            }
        }

    }

}


//////////////////////////////////////////////////
// DotLightクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.PixelSnapping;
import flash.display.BlendMode;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.filters.BlurFilter;
import flash.events.Event;
import flash.utils.getTimer;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundLoaderContext;
import flash.media.SoundMixer;
import flash.utils.ByteArray;
import flash.net.URLRequest;
import flash.system.Security;

class DotLight extends Sprite {
    private var rect:Rectangle;
    private var canvas:BitmapData;
    private var map:BitmapData;
    private var sparkle:BitmapData;
    private var afterglow:BitmapData;
    private static var scale:uint = 4;
    private var aMatrix:Matrix;
    private var colorTrans:ColorTransform;
    private var blur:BlurFilter;
    private var sMatrix:Matrix;
    private var offsets:Array;
    private var seed:uint;
    private var light:EmitLight;
    private var sound:Sound;
    private var channel:SoundChannel;
    private static var soundPath:String = "http://commondatastorage.googleapis.com/bradsedito/Manchester%20Orchestra%20-%20Shake%20It%20Out.mp3";
    private var byteArray:ByteArray;
    private static var channels:uint = 256;
    private static var factors:uint = 0;

    public function DotLight(r:Rectangle) {
        rect = r;
        init();
    }

    private function init():void {
        afterglow = new BitmapData(rect.width*2/scale, rect.height*2/scale, false, 0xFF000000);
        var aBitmap:Bitmap = new Bitmap(afterglow, PixelSnapping.AUTO, true);
        aBitmap.scaleX = aBitmap.scaleY = scale/2;
        addChild(aBitmap);
        canvas = new BitmapData(rect.width, rect.height, true, 0x00000000);
        var cBitmap:Bitmap = new Bitmap(canvas);
        cBitmap.blendMode = BlendMode.ADD;
        addChild(cBitmap);
        map = new BitmapData(rect.width/scale, rect.height/scale, false, 0xFF000000);
        offsets = [new Point(), new Point()];
        seed = Math.floor(Math.random()*1000);
        sparkle = new BitmapData(rect.width/scale, rect.height/scale, true, 0x00000000);
        var sBitmap:Bitmap = new Bitmap(sparkle);
        sBitmap.smoothing = true;
        sBitmap.blendMode = BlendMode.ADD;
        sBitmap.scaleX = sBitmap.scaleY = scale;
        addChild(sBitmap);
        aMatrix = new Matrix(2/scale, 0, 0, 2/scale, 0, 0);
        //colorTrans = new ColorTransform(0.1, 0.1, 0.1);
        colorTrans = new ColorTransform(0.108, 0.108, 0.108);
        blur = new BlurFilter(2, 2, 1);
        sMatrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
        light = new EmitLight(canvas, map, scale);
        //
        sound = new Sound();
        sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
        sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
        byteArray = new ByteArray();
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Event.COMPLETE, complete);
        start();
    }
    private function start():void {
        channel = sound.play(0, 1000);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, update);
    }
    private function update(evt:Event):void {
        SoundMixer.computeSpectrum(byteArray, true, factors);
        var data:Array = new Array();
        for (var c:uint = 0; c < 2; c++) {
            data[c] = new Array();
            for (var n:uint = 0; n < channels; n++) {
                var p:Number = byteArray.readFloat();
                data[c].push(p);
            }
        }
        draw(data);
    }
    private function draw(data:Array):void {
        var time:uint = getTimer();
        //var offset:Number = time*0.05;
        var offset:Number = time*0.08;
        offsets[0].x = offsets[1].y = offset;
        map.perlinNoise(rect.width/scale, rect.height/scale, 2, seed, true, true, 3, false, offsets);
        light.create(12, time);
        canvas.lock();
        canvas.fillRect(canvas.rect, 0x00000000);
        light.emit(data);
        canvas.unlock();
        sparkle.lock();
        sparkle.fillRect(sparkle.rect, 0x00000000);
        sparkle.draw(canvas, sMatrix);
        sparkle.unlock();
        afterglow.lock();
        afterglow.draw(canvas, aMatrix, colorTrans, BlendMode.ADD);
        afterglow.applyFilter(afterglow, afterglow.rect, new Point(), blur);
        afterglow.unlock();
    }

}


//////////////////////////////////////////////////
// EmitLightクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import __AS3__.vec.Vector;
import frocessing.color.ColorHSV;

class EmitLight {
    private var canvas:BitmapData;
    private var map:BitmapData;
    private var rect:Rectangle;
    private var scale:uint;
    private var dots:Vector.<Dot>;
    //private static var speed:Number = 0.5;
    //private static var speed:Number = 0.6;
    //private static var deceleration:Number = 0.01;
    private static var deceleration:Number = 0.008;
    private static var length:Number = 2;
    private var color:ColorHSV;
    private var manager:Bresenham;

    public function EmitLight(c:BitmapData, m:BitmapData, s:uint) {
        canvas  = c;
        map = m;
        rect = canvas.rect;
        scale = s;
        init();
    }

    private function init():void {
        dots = new Vector.<Dot>();
        color = new ColorHSV(0, 0.5);
        manager = new Bresenham(canvas);
    }
    public function create(max:uint, time:uint):void {
        for (var n:uint = 0; n < max; n++) {
            var angle:Number = time + Math.random()*Math.PI;
            //var px:Number = rect.width*0.5 + Math.cos(angle)*5;
            //var py:Number = rect.height*0.5 + Math.sin(angle)*5;
            var c:uint = n/max*Math.PI*3;
            var px:Number = rect.width*0.5 + Math.cos(time/1000+c)*120 + Math.cos(angle)*40;
            var py:Number = rect.height*0.5 + Math.sin(time/1000+c)*120 + Math.sin(angle)*40;
            color.h = time/100;
            var dot:Dot = new Dot(px, py, angle, color.value);
            dot.vx = Math.cos(angle);
            dot.vy = Math.sin(angle);
            dots.push(dot);
        }
    }
    public function emit(data:Array):void {
        for (var n:uint = 0; n < dots.length; n++) {
            var dot:Dot = dots[n];
            var c:uint = map.getPixel(dot.x/scale, dot.y/scale);
            var d:uint = n%2;
            var p:Array = data[d];
            var speed:Number = p[n%p.length]*10;
            dot.vx += (((c >> 16) & 0xFF) - 0x80) / 0x80*speed;
            dot.vy += (((c >> 8) & 0xFF) - 0x80) / 0x80*speed;
            dot.x += dot.vx;
            dot.y += dot.vy;
            dot.energy -= deceleration;
            var x0:int = dot.x;
            var y0:int = dot.y;
            var x1:int = dot.x - (dot.x - dot.px)*length;
            var y1:int = dot.y - (dot.y - dot.py)*length;
            //manager.draw(x0, y0, x1, y1, dot.rgb, dot.energy*0.5);
            manager.draw(x0, y0, x1, y1, dot.rgb, dot.energy);
            dot.px = dot.x;
            dot.py = dot.y;
            if (dot.energy < 0 || dot.x < rect.left || dot.x > rect.right || dot.y < rect.top || dot.y > rect.bottom) {
                dots.splice(n, 1);
                dot = null;
            }
        }
    }

}


//////////////////////////////////////////////////
// Dotクラス
//////////////////////////////////////////////////

class Dot {
    public var x:Number = 0;
    public var y:Number = 0;
    public var px:Number = 0;
    public var py:Number = 0;
    public var angle:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var energy:Number = 2;
    public var rgb:uint = 0xFFFFFF;

    public function Dot(_x:Number, _y:Number, a:Number, c:uint = 0xFFFFFF):void {
        x = _x;
        y = _y;
        px = x;
        py = y;
        angle = a;
        rgb = c;
    }

}


//////////////////////////////////////////////////
// Bresenhamクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;

class Bresenham {

    private var canvas:BitmapData;

    public function Bresenham(c:BitmapData) {
        canvas = c;
    }

    public function draw(x0:int, y0:int, x1:int, y1:int, color:uint, alpha:Number):void {
        var steep:Boolean = Math.abs(y1 - y0) > Math.abs(x1 - x0);
        var t:int;
        if (steep) {
            t = x0;
            x0 = y0;
            y0 = t;
            t = x1;
            x1 = y1;
            y1 = t;
        }
        if (x0 > x1) {
            t = x0;
            x0 = x1;
            x1 = t;
            t = y0;
            y0 = y1;
            y1 = t;
        }
        var dx:int = x1 - x0;
        var dy:int = Math.abs(y1 - y0);
        var e:int = dx*0.5;
        var ys:int = (y0 < y1) ? 1 : -1;
        var y:int = y0;
        for (var x:int = x0; x <= x1; x++) {
            if (steep) {
                plot(y, x, color, alpha);
            } else {
                plot(x, y, color, alpha);
            }
            e = e - dy;
            if (e < 0) {
                y = y + ys;
                e = e + dx;
            }
        }
    }
    private function plot(x:int, y:int, c:uint, a:Number):void {
        canvas.setPixel32(x, y, c | ((a*0xFF) << 24));
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
            case 1 :
                bColor = 0xFFFFFF;
                sColor = 0x000000;
                upColor = 0x666666;
                overColor = 0x333333;
                offColor = 0x999999;
                break;
            case 2 :
                bColor = 0x000000;
                sColor = 0xFFFFFF;
                upColor = 0x666666;
                overColor = 0x999999;
                offColor = 0x333333;
                break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}
