/**
 * Copyright naoto5959 ( http://wonderfl.net/user/naoto5959 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k2WJ
 */

package  
{
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.text.TextField;
  import flash.text.TextFormat;
  
  [SWF(width=465,height=465,backgroundColor=0xFFFFFF,frameRate=30)]
  /**
   * Wonderfl APIの実験
   * 
   * WonderflAPIClient Usage
   * 
   * // set your api key
   * WonderflAPIClient.apiKey = "your_wonderfl_api_key";
   * 
   * // create client
   * var client:WonderflAPIClient = new WonderflAPIClient();
   * 
   * // listen
   * client.addEventListener(WonderflAPIClient.GET_USER_COMPLETE, hander);
   * 
   * // get user info
   * client.getUser();
   * 
   * // handler
   * function hander(event:Event):void
   * {
   *   trace(client.user.name);
   * }
   * @author naoto koshikawa
   */
  public class WonderflAPIDemo extends Sprite
  {
    // locale　で試す場合は、自分のWonderfl API Keyを入れる
    private var _apiKey:String = "";
    
    private var _tf:TextField;
    
    public function WonderflAPIDemo() 
    {
      // create TextField for demo
      createTF();
      
      // if api key is empty, get open key.
      if (_apiKey == "") getOpenAPIKey();
      
      // set wonderfl api key
      WonderflAPIClient.apiKey = _apiKey;
      
      // crete WonderflAPIClient
      var apiClient:WonderflAPIClient = new WonderflAPIClient();
      
      // listen event
      apiClient.addEventListener(WonderflAPIClient.GET_USER_COMPLETE,
        function(event:Event):void
        {
          _tf.appendText("apiClient.getUser complete: \n");
          _tf.appendText(" you can access apiClient.user \n\n");
        }
      );
      apiClient.addEventListener(WonderflAPIClient.GET_USER_CODES_COMPLETE,
        function(event:Event):void
        {
          _tf.appendText("apiClient.getUserCodes complete: \n");
          _tf.appendText(" you can access apiClient.userCodes \n\n");
        }
      );
      apiClient.addEventListener(WonderflAPIClient.GET_CODE_COMPLETE,
        function(event:Event):void
        {
          _tf.appendText("apiClient.getCode complete: \n");
          _tf.appendText(" you can access apiClient.code \n\n");
        }
      );
      apiClient.addEventListener(WonderflAPIClient.GET_CODE_FORKS_COMPLETE,
        function(event:Event):void
        {
          _tf.appendText("apiClient.getCodeForks complete: \n");
          _tf.appendText(" you can access apiClient.codeForks \n\n");
        }
      );
      
      // execute
      _tf.appendText('apiClient.getUser("naoto5959");' + "\n");
      apiClient.getUser("naoto5959");
      
      _tf.appendText('apiClient.getUserCodes("naoto5959");' + "\n");
      apiClient.getUserCodes("naoto5959");
      
      _tf.appendText('apiClient.getCode("8c80c437763e2b477076d3328e0cf6fded8dff6a");' + "\n");
      apiClient.getCode("8c80c437763e2b477076d3328e0cf6fded8dff6a");
      
      _tf.appendText('apiClient.getCodeForks("8c80c437763e2b477076d3328e0cf6fded8dff6a");' + "\n\n");
      apiClient.getCodeForks("8c80c437763e2b477076d3328e0cf6fded8dff6a");
      
    }
    
    private function createTF():void
        {
            _tf = new TextField();
            _tf.defaultTextFormat = new TextFormat("_sans", 12);
            _tf.width = 465;
            _tf.height = 465;
            _tf.multiline = true;
            _tf.wordWrap = true;
            addChild(_tf);
        }
    
    private function getOpenAPIKey():void
    {
      if (loaderInfo.parameters 
        && loaderInfo.parameters.open_api_key is String)
      {
        _apiKey = loaderInfo.parameters.open_api_key;
      }
    }
  }
}

/**
 * Wonderfl API client
 */
import com.adobe.serialization.json.JSON;
import flash.events.AsyncErrorEvent;
import flash.events.ErrorEvent;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IOErrorEvent;
import flash.events.SecurityErrorEvent;
import flash.net.URLLoader;
import flash.net.URLRequest;

class WonderflAPIClient extends EventDispatcher
{
  public static const GET_USER_COMPLETE:String = "getUserComplete";
  public static const GET_USER_CODES_COMPLETE:String = "getUserCodesComplete";
  public static const GET_CODE_COMPLETE:String = "getCodeComplete";
  public static const GET_CODE_FORKS_COMPLETE:String = "getCodeForksComplete";
  
  public static const END_POINT:String = "http://api.wonderfl.net/";
  public static const STATUS_OK:String = "ok";
  public static const STATUS_NG:String = "fail";
  
  public static const GET_USER:String = "user/%USER_NAME%";
  public static const GET_USER_CODES:String = "user/%USER_NAME%/codes";
  public static const GET_CODE:String = "code/%CODE_ID%";
  public static const GET_CODE_FORKS:String = "code/%CODE_ID%/forks";
  
  private static var _apiKey:String = "";
  public static function get apiKey():String
  {
    return _apiKey;
  }
  public static function set apiKey(value:String):void
  {
    _apiKey = value;
  }
  
  
  private var _user:Object = { };
  public function get user():Object
  {
    return _user;
  }
  private var _userCodes:Array = [];
  public function get userCodes():Object
  {
    return _userCodes;
  }
  private var _code:Object = { };
  public function get code():Object
  {
    return _code;
  }
  private var _codeForks:Array = [];
  public function get codeForks():Array
  {
    return _codeForks;
  }
  
  public function WonderflAPIClient()
  {
    
  }
  
  public function getUser(userName:String):void
  {
    var url:String = END_POINT + GET_USER;
    url = url.replace("%USER_NAME%", userName);
    url += "?api_key=" + _apiKey;
    load(url, arguments.callee);
  }
  
  public function getUserCodes(userName:String):void
  {
    var url:String = END_POINT + GET_USER_CODES;
    url = url.replace("%USER_NAME%", userName);
    url += "?api_key=" + _apiKey;
    load(url, arguments.callee);
  }
  
  public function getCode(codeID:String):void
  {
    var url:String = END_POINT + GET_CODE;
    url = url.replace("%CODE_ID%", codeID);
    url += "?api_key=" + _apiKey;
    load(url, arguments.callee);
  }

  public function getCodeForks(codeID:String):void
  {
    var url:String = END_POINT + GET_CODE_FORKS;
    url = url.replace("%CODE_ID%", codeID);
    url += "?api_key=" + _apiKey;
    load(url, arguments.callee);
  }
  
  private function load(url:String, method:Function):void
  {
    var urlLoader:URLLoader =new URLLoader();
    urlLoader.addEventListener(Event.COMPLETE, function(event:Event):void {
      urlLoader.removeEventListener(Event.COMPLETE, arguments.callee);
      var json:String = urlLoader.data;
      var obj:Object = JSON.decode(json);
      if (obj.stat == STATUS_NG)
      {
        dispatchEvent(new ErrorEvent(ErrorEvent.ERROR, false, false, obj.message));
        return;
      }
      var eventName:String;
      switch (method)
      {
        case getUser:
          _user = obj;
          eventName = GET_USER_COMPLETE;
          break;
        case getUserCodes:
          _userCodes = obj.codes;
          eventName = GET_USER_CODES_COMPLETE;
          break;
        case getCode:
          _code = obj;
          eventName = GET_CODE_COMPLETE;
          break;
        case getCodeForks:
          _codeForks = obj.forks;
          eventName = GET_CODE_FORKS_COMPLETE;
          break;
      }
      dispatchEvent(new Event(eventName));
    });
    urlLoader.addEventListener(IOErrorEvent.IO_ERROR, dispatchEvent);
    urlLoader.addEventListener(AsyncErrorEvent.ASYNC_ERROR, dispatchEvent);
    urlLoader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, dispatchEvent);
    urlLoader.load(new URLRequest(url));
  }
}
