/**
 * Copyright y_tti ( http://wonderfl.net/user/y_tti )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k1G4
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0x000000")]
	public class ytti_drawTriTest extends Sprite
	{
		private var _xCount:int = 10;
		private var _yCount:int = 10;
		private var _pts:Array;
		
		public function ytti_drawTriTest()
		{
			addEventListener(Event.ADDED_TO_STAGE , _init );
		}
		
		private function _init(e:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE , _init );
			
			_pts = [];
			var w:Number = stage.stageWidth / _xCount;
			var h:Number = stage.stageHeight / _yCount;
			for(var iy:int = 0;iy <= _yCount;iy++ ){
				for(var ix:int = 0;ix <= _xCount ;ix++ ){
					var pt:Pt = new Pt( ix*w , iy*h );
					addChild(pt);
					_pts.push(pt);
				}
			}
			
			
			addEventListener(Event.ENTER_FRAME , _loop )
		}
		
		private function _loop(e:Event):void {
			_update();
			_draw();
		}
		
		private function _update():void {
			for(var i:int = 0;i < _pts.length;i++ ){
				var pt:Pt = _pts[i];
				var dx:Number = mouseX - pt.x;
				var dy:Number = mouseY - pt.y;
				var dist:Number = Math.sqrt( dx*dx + dy*dy);
				var rad:Number = Math.atan2(dy,dx);
				
				pt.x = pt.initX + Math.cos(rad) * 100;
				pt.y = pt.initY + Math.sin(rad) * 100;
				
			}
		}
		
		private function _draw():void {
			
		}

	}
}
	import flash.display.Shape;
	import mx.states.AddChild;
	import flash.display.Sprite;
	

class Pt extends Sprite {
	public var initX:Number;
	public var initY:Number;
	public var shape:Shape;
	public function Pt($x:Number,$y:Number){
		this.x = this.initX = $x;
		this.y = this.initY = $y;
		
		this.graphics.beginFill(0xCCCCCC , 1 );
		this.graphics.drawCircle(0,0,4);
		this.graphics.endFill();
	}
}