/**
 * Copyright ser1zw ( http://wonderfl.net/user/ser1zw )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k0X9
 */

/*
TextFieldとMinimalCompsのVScrollBarで手っ取り早く
日本語が使えるスクロールバー付きTextFieldを作るサンプル
(MinimalCompsのTextAreaのソースコードを参考にしています)
*/
package {
  import flash.display.Sprite;
  import flash.text.TextField;
  import flash.text.TextFieldType;
  import flash.events.Event;
  import com.bit101.components.VScrollBar;

  public class ScrollableTextFieldSample extends Sprite {
    private var tf:TextField;
    private var vScrollBar:VScrollBar;

    public function ScrollableTextFieldSample() {
      tf = new TextField();
      tf.text = "手っ取り早く日本語が使えるスクロールバー付きTextFieldが欲しい時のサンプルです。"
      + "ちょっと必要になったので作ってみました(とっくに誰か作ってそうな気もするけど)。"
      + "MinimalCompsのソースをいじれない環境でちょっと使う分にはそこそこ便利かと思います。";
      tf.x = 100;
      tf.y = 30;
      tf.border = true;
      tf.multiline = true;
      tf.wordWrap = true;
      tf.type = TextFieldType.INPUT;
      addChild(tf);

      vScrollBar = new VScrollBar(this, tf.x + tf.width, tf.y, function(e:Event):void {
      // スクロールバーのスクロール時にTextFieldの位置を合わせる
      tf.scrollV = vScrollBar.value;
    });

      vScrollBar.height = tf.height;
      tf.addEventListener(Event.SCROLL, function(e:Event):void {
      adjustScrollBar();
    });
      adjustScrollBar();
    }

    /** TextFieldに合わせてスクロールバーを設定 */
    private function adjustScrollBar():void {
      var visibleLines:int = tf.numLines - tf.maxScrollV + 1;
      var percent:Number = visibleLines / tf.numLines;
      vScrollBar.setSliderParams(1, tf.maxScrollV, tf.scrollV);
      vScrollBar.setThumbPercent(percent);
      vScrollBar.value = tf.scrollV;
    }
  }
}
