/**
 * Copyright 9balls ( http://wonderfl.net/user/9balls )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/k0U4
 */

package
{
    import flash.display.Bitmap;
    import a24.tween.Tween24;
    import com.adobe.utils.AGALMiniAssembler;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Stage3D;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display3D.Context3D;
    import flash.display3D.Context3DProgramType;
    import flash.display3D.Context3DRenderMode;
    import flash.display3D.Context3DTextureFormat;
    import flash.display3D.Context3DVertexBufferFormat;
    import flash.display3D.IndexBuffer3D;
    import flash.display3D.Program3D;
    import flash.display3D.textures.Texture;
    import flash.display3D.VertexBuffer3D;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix3D;
    import flash.text.TextField;
    import flash.ui.Multitouch;
    import flash.ui.MultitouchInputMode;
    import flash.utils.ByteArray;
    import net.hires.debug.Stats;
    
    /**
     * ...
     * @author
     */
    public class Main extends Sprite
    {
        //
        private var stage3D:Stage3D;
        private var context3D:Context3D;
        //
        private var program:Program3D;
        private var indexBuffer:IndexBuffer3D;
        //
        private var textures:Vector.<Texture>;
        private var dxy:Vector.<Number>;
        private var rgb:Vector.<Number>;
        private var tween:Tween24;
        
        private var colorTf:TextField;
        public var colorSource:Sprite;
        
        //private var sc:BitmapData　=　new BitmapData(465,　465,　false);
        
        public function Main():void
        {
            Wonderfl.disable_capture();
            //addChild(new Bitmap(sc));
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            // entry point
            
            addChild(new Stats());
            stage.frameRate = 60;
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            //
            stage3D = stage.stage3Ds[0];
            stage3D.x = 0;
            stage3D.y = 0;
            stage3D.addEventListener(Event.CONTEXT3D_CREATE, onContextCreate);
            stage3D.requestContext3D(Context3DRenderMode.AUTO);
        }
        
        private function onContextCreate(e:Event):void
        {
            stage3D.removeEventListener(Event.CONTEXT3D_CREATE, onContextCreate);
            context3D = stage3D.context3D;
            
            init();
        }
        
        private function init():void
        {
            //context3D.enableErrorChecking = true;
            context3D.configureBackBuffer(466, 426, 0, true);
            //create
            createShaders();
            setConstant();
            setBuffer();
            textures = new Vector.<Texture>(6);
            for (var i:int = 0; i < 6; i++)
            {
                textures[i] = createRandomTexture(256 >> i)
            }
            //set
            context3D.setProgram(program);
            context3D.setTextureAt(0, textures[0]);
            context3D.setTextureAt(1, textures[1]);
            context3D.setTextureAt(2, textures[2]);
            context3D.setTextureAt(3, textures[3]);
            context3D.setTextureAt(4, textures[4]);
            context3D.setTextureAt(5, textures[5]);
            context3D.setRenderToBackBuffer();
            //tween
            colorSource = new Sprite();
            colorSource.graphics.beginFill(0x0);
            colorSource.graphics.drawRect(0, 0, 466, 40);
            colorSource.graphics.endFill();
            addChild(colorSource);
            colorSource.y = 426;
            Tween24.prop(colorSource).color(0xFFFFFF).play();
            onComplete();
            //text
            var tf:TextField = new TextField();
            tf.wordWrap = true;
            tf.autoSize = "left";
            tf.text = context3D.driverInfo;
            tf.y = stage.stageHeight - 20;
            addChild(tf);
            
            colorTf = new TextField();
            colorTf.wordWrap = true;
            colorTf.autoSize = "left";
            colorTf.text = context3D.driverInfo;
            colorTf.x = stage.stageWidth>>1;
            colorTf.y = stage.stageHeight - 20;
            addChild(colorTf);
            //run
            addEventListener(Event.ENTER_FRAME, onEnter);
        }
        
        private function onEnter(e:Event):void
        {
            context3D.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 2, rgb, 1);
            context3D.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 3, dxy, 1);
            dxy[0] += 0.004;
            dxy[1] += 0.0008;
            
            tween.manualUpdate();
            var color:uint = colorSource.transform.colorTransform.color;
            rgb[0] = (color >> 16) / 255;
            rgb[1] = ((color & 0xFF00) >> 8) / 255;
            rgb[2] = (color & 0xFF) / 255;
            
            colorTf.text = "0x" + color.toString(16).toUpperCase();
            //
            context3D.clear(0, 0, 0, 1);
            context3D.drawTriangles(indexBuffer);
            //context3D.drawToBitmapData(sc);
            context3D.present();
        }
        
        private function onComplete():void
        {
            tween = Tween24.tween(colorSource, 5.0).color(Math.random() * 0x1000000).onComplete(onComplete);
            tween.manualPlay();
        }
        
        //
        
        private function createRandomTexture(size:uint):Texture
        {
            var bd:BitmapData = new BitmapData(size, size, false);
            bd.noise(Math.random() * 0xFFFFFFFF >> 0, 0, 255, 7, true);
            var texture:Texture = context3D.createTexture(size, size, Context3DTextureFormat.BGRA, false);
            texture.uploadFromBitmapData(bd);
            return texture;
        }
        
        private function createShaders():void
        {
            //create shaders
            var agalAssembler:AGALMiniAssembler = new AGALMiniAssembler();
            //
            //vertex
            var vertexShader:ByteArray = agalAssembler.assemble(Context3DProgramType.VERTEX, "m44 op, va0, vc0 \n" + "mov v0, va1\n");
            //
            //fragment
            var code:String = "";
            //load and blend texture
            code += "mov ft0 v0\n";
            code += "add ft0.xy, ft0.xy fc3.xy\n";
            code += "tex ft1, ft0, fs0<2d,repeat,linear>\n";
            code += "mul ft1, ft1, fc1.y\n";
            code += "tex ft2, ft0, fs1<2d,repeat,linear>\n";
            code += "mul ft2, ft2, fc1.x\n";
            code += "add ft1, ft1, ft2\n";
            code += "tex ft2, ft0, fs2<2d,repeat,linear>\n";
            code += "mul ft2, ft2, fc0.w\n";
            code += "add ft1, ft1, ft2\n";
            code += "add ft0.xy, ft0.xy fc3.xy\n";
            code += "tex ft2, ft0, fs3<2d,repeat,linear>\n";
            code += "mul ft2, ft2, fc0.z\n";
            code += "add ft1, ft1, ft2\n";
            code += "tex ft2, ft0, fs4<2d,repeat,linear>\n";
            code += "mul ft2, ft2, fc0.y\n";
            code += "add ft1, ft1, ft2\n";
            code += "tex ft2, ft0, fs5<2d,repeat,linear>\n";
            code += "mul ft2, ft2, fc0.x\n";
            code += "add ft1, ft1, ft2\n";
            code += "mov ft0, ft1\n";
            //set color
            code += "mul ft0, ft0, fc2\n";
            code += "mov oc, ft0\n";
            var fragmentShader:ByteArray = agalAssembler.assemble(Context3DProgramType.FRAGMENT, code);
            //
            //set shaders to program
            program = context3D.createProgram();
            program.upload(vertexShader, fragmentShader);
        }

        private function setConstant():void
        {
            //vc
            var mtx:Matrix3D = new Matrix3D();
            context3D.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, mtx, true);
            //ft
            var blend:Vector.<Number> = new Vector.<Number>(6);
            var max:Number = 0.6;
            for (var i:int = 0; i < 6; i++)
            {
                blend[i] = max;
                max /= 2;
            }
            context3D.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, Vector.<Number>([blend[0], blend[1], blend[2], blend[3]]), 1);
            context3D.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 1, Vector.<Number>([blend[4], blend[5], 0, 0]), 1);
            rgb = Vector.<Number>([1, 1, 1, 0]);
            dxy = Vector.<Number>([0, 0, 0, 0]);
        }

        

        private function setBuffer():void
        {
            //vertex buffer
            var vertexBuffer:VertexBuffer3D = context3D.createVertexBuffer(4, 4);
            context3D.setVertexBufferAt(0, vertexBuffer, 0, Context3DVertexBufferFormat.FLOAT_2);
            context3D.setVertexBufferAt(1, vertexBuffer, 2, Context3DVertexBufferFormat.FLOAT_2);
            vertexBuffer.uploadFromVector(Vector.<Number>([-1, -1, 0, 1, -1, 1, 0, 0, 1, -1, 1, 1, 1, 1, 1, 0]), 0, 4);
            //index buffer
            indexBuffer = context3D.createIndexBuffer(6);
            indexBuffer.uploadFromVector(Vector.<uint>([0, 1, 2, 1, 2, 3]), 0, 6);
        }

    }

}