/**
 * Copyright bigfish ( http://wonderfl.net/user/bigfish )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jzDo
 */

// forked from bigfish's cellular automata #1
package {

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.Rectangle;
    import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * rule: if either neighbour was black --> make black
	 * if both neighbours were white --> white
	 */
    public class CellularAutomata1 extends Sprite {
		
		private var bmd:BitmapData;
		private var canvas:Bitmap;
		private var rows:int = 400;
		private var cols:int = 400;
		private var left:int = cols + 1;
		private var right:int = cols - 1;
		private var rect:Rectangle = new Rectangle(0, 0, cols, rows);
		private var numPixels:int = rows*cols;
		private var pixelVector:Vector.<uint> = new Vector.<uint>(numPixels);

        public function CellularAutomata1() {
            init();
        }
		/**
		 * set up canvas
		 */
		private function init():void
		{
			
			bmd = new BitmapData(cols,rows,true,0xFFFFFFFF);
			//seed pixel
			bmd.setPixel(200,0,0xFF000000);
			canvas = new Bitmap(bmd);
			canvas.x = 20;
			canvas.y = 20;
			addChild(canvas);
			iterate();
			//addEventListener(Event.ENTER_FRAME, iterate);
		}


		/**
		 * apply rule to image (one iteration)
		 */
		//private function iterate(e:Event):void
		private function iterate():void
		{
			pixelVector = bmd.getVector(rect);
			for(var i:int = cols; i < numPixels; ++i)
			{
				//part 1 - if either neighbour is black --> black
				if(i%cols > 0 && ( pixelVector[i - left] == 0xFF000000 )){
					pixelVector[i] = 0xFF000000;
				
				/*} else if(pixelVector[i - cols] == 0xFF000000) {
					pixelVector[i] = 0xFF000000;*/
				
				} else if(i%cols < right && pixelVector[i - right] == 0xFF000000) {
					pixelVector[i] = 0xFF000000;
				
				//part two - if both neighbours are white --> make white
				} else if((i%cols > 0 && ( pixelVector[i - left] == 0xFFFFFFFF )) && (i%cols < right && pixelVector[i - right] == 0xFFFFFFFF)) {
				
					pixelVector[i] = 0xFFFFFFFF;
				}
			}

			bmd.setVector(rect, pixelVector);


		}



    }
}
