/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jyyP
 */

package {
    import flash.display.Sprite;
    import flash.system.Security;
    import org.libspark.thread.Thread;
    import org.libspark.thread.EnterFrameThreadExecutor;
    
    [SWF(backgroundColor="#333333", width="465", height="465", frameRate="30")]
    
    public class FlashTest extends Sprite {
        private var filePath:String = "http://www.project-nya.jp/images/flash/thread.data.xml";
        private var thread:MainThread;
        
        public function FlashTest() {
            init();
        }
        
        private function init():void {
            graphics.beginFill(0x333333);
            graphics.drawRect(0,0,465,465);
            graphics.endFill();
            
            if(!Thread.isReady) Thread.initialize(new EnterFrameThreadExecutor());
            start();
        }
        private function start():void {
            Security.allowDomain("www.project-nya.jp");
            Security.loadPolicyFile("http://www.project-nya.jp/crossdomain.xml");
            thread = new MainThread(this, filePath);
            thread.start();
        }
    }
}

import flash.display.Sprite;
import flash.net.URLRequest;
import org.libspark.thread.Thread;
import org.libspark.thread.threads.net.URLLoaderThread;

class MainThread extends Thread {
    private var container:Sprite;
    private var filePath:String;
    private var loader:URLLoaderThread;
    private var photos:Array;
    private static var basePath:String = "http://www.project-nya.jp";
    
    public function MainThread(c:Sprite, f:String) {
        container = c;
        filePath = f;
    }
    
    override protected function run():void {
        loader = new URLLoaderThread(new URLRequest(filePath));
        loader.start();
        loader.join();
        next(parse);
    }
    
    private function parse():void {
        var xml:XML = new XML(loader.loader.data);
        photos = new Array();
        for(var n:uint = 0; n < xml.photo.length(); n++) {
            var photo:XML = xml.photo[n];
            photos.push(basePath + String(photo));
        }
        next(load);
    }
    private function load():void {
        var loader:PhotoLoaderThread = new PhotoLoaderThread(container, photos);
        loader.start();
    }
    override protected function finalize():void {
        
    }
}

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.Bitmap;
import flash.net.URLRequest;
import org.libspark.thread.Thread;
import org.libspark.thread.threads.display.LoaderThread;

class PhotoLoaderThread extends Thread {
    private var container:Sprite;
    private var photos:Array;
    private var loader:LoaderThread;
    private var currentId:uint = 0;
    private var sw:uint;
    private var sh:uint;
    
    public function PhotoLoaderThread(c:Sprite, list:Array) {
        container = c;
        photos = list;
        sw = container.stage.stageWidth;
        sh = container.stage.stageHeight;
    }
    
    override protected function run():void {
        currentId = 0;
        load();
    }
    private function load():void {
        var filePath:String = photos[currentId];
        loader = new LoaderThread(new URLRequest(filePath));
        loader.start();
        loader.join();
        next(loaded);
    }
    private function loaded():void {
        var loader:Loader = loader.loader;
        var content:Bitmap = Bitmap(loader.content);
        container.addChild(content);
        content.x = 12 + 90 * (currentId%5) + (80 - content.height)/2;
        content.y = 12 + 90 * uint(currentId/5) + (80 - content.height)/2;
        if(currentId < photos.length - 1) {
            currentId++;
            next(load);
        }
    }
    override protected function finalize():void {
        
    }
}

