/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jxbs
 */

/*
 * Picasa Web Albums Data API
 * http://code.google.com/intl/ja/apis/picasaweb/docs/2.0/reference.html
 * 
*/
package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.filters.DropShadowFilter;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.Security;
	import com.adobe.serialization.json.JSONDecoder;
	public class Main extends Sprite {
		public function Main() {
			//検索結果のロード
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener(Event.COMPLETE, onCompleteJSON);
			var jsonURL:String = "http://photos.googleapis.com/data/feed/base/all?alt=json&kind=photo&q=waterdrop&imglic=commercial&max-results=3&imgmax=288";
			//クロスドメインポリシーファイルの位置を指定
			Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");
			myURLLoader.load(new URLRequest(jsonURL));
		}
		
		private function onCompleteJSON(e:Event):void {
			//取得したデータをJSON型にする
			var decoder:JSONDecoder = new JSONDecoder(e.currentTarget.data);
			var json:Object = decoder.getValue();
			
			//JSONを解析
			var titleStr:String = json.feed.entry[0].title.$t;
			var linkURL:String = json.feed.entry[0].link[1].href;
			var creditStr:String = json.feed.entry[0].media$group.media$credit[0].$t;		//*1
			var imgURL:String = json.feed.entry[0]["media$group"].media$content[0].url;		//*2
			
			var textData:String = "";
			textData += titleStr + "\n";
			textData += linkURL + "\n";
			textData += creditStr + "\n";
			textData += imgURL + "\n";
			textData += "******\n";
			textData += e.currentTarget.data;
			
			//背景のグレーの文字。JSONの文字列を流し込んでいる。
			var tf:TextField = new TextField();
			tf.text = textData;
			tf.wordWrap = true;
			tf.width = tf.height = 465;
			addChild(tf);
		}
	}
}
