/**
 * Copyright mach51 ( http://wonderfl.net/user/mach51 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jxXr
 */

package 
{
    import flash.events.*;
    import flash.display.MovieClip;
    import flash.ui.Keyboard;
    
    [SWF(width = '500', height = '500', backgroundColor = '0x000000', frameRate = '30')]
    
    public class MovingAroundAndStuff extends MovieClip
    {
        
        public var player:MovingClip = new MovingClip(30, 45, 20, 10, 5);
        
        public function MovingAroundAndStuff()
        {
            addChild(player);
            player.x = stage.stageWidth / 2;
            player.y = (stage.stageHeight - player.height) / 2;
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, move);
            stage.addEventListener(KeyboardEvent.KEY_UP, stopMove);
            stage.addEventListener(Event.ENTER_FRAME, step);    
        }
        
        public function move(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.LEFT:
                player.xDir = -1;
                if(!isSecondKey()){
                    player.rotation = 270;
                }
                break;
                case Keyboard.RIGHT:
                player.xDir = 1;
                if(!isSecondKey()){
                    player.rotation = 90;
                }
                break;
                case Keyboard.UP:
                player.yDir = -1;
                if(!isSecondKey()){
                    player.rotation = 0;
                }
                break;
                case Keyboard.DOWN:
                player.yDir = 1;
                if(!isSecondKey()){
                    player.rotation = 180;
                }
                break;
            }
        }
        
        public function stopMove(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.LEFT:
                player.xDir = 0;
                break;
                case Keyboard.RIGHT:
                player.xDir = 0;
                break;
                case Keyboard.UP:
                player.yDir = 0;
                break;
                case Keyboard.DOWN:
                player.yDir = 0;
                break;
            }
        }
        
        public function step(e:Event):void
        {
            if(Math.abs(player.xSpeed) < player.topSpeed && player.xDir != 0){
                player.xSpeed += player.xDir * (player.topSpeed / player.framesTillTop);
            }
            else if(Math.abs(player.xSpeed) > 0 && player.xDir == 0){
                player.xSpeed += -Math.abs(player.xSpeed) / player.xSpeed * (player.topSpeed / player.framesTillTop);
            }

            if(Math.abs(player.ySpeed) < player.topSpeed && player.yDir != 0){
                player.ySpeed += player.yDir * (player.topSpeed / player.framesTillTop);
            }
            else if(Math.abs(player.ySpeed) > 0 && player.yDir == 0){
                player.ySpeed += -Math.abs(player.ySpeed) / player.ySpeed * (player.topSpeed / player.framesTillTop);
            }

            
            player.x += player.xSpeed;
            player.y += player.ySpeed;
        }
        
        public function isSecondKey():Boolean
        {
            return (player.xDir != 0 && player.yDir != 0);
        }

    }// end class
}
import flash.events.Event; // end package

import flash.display.MovieClip;

class MovingClip extends MovieClip
{
    
    public var player:Vector.<Number>;
    public var xDir:int = 0;
    public var yDir:int = 0;
    public var xSpeed:Number = 0;
    public var ySpeed:Number = 0;
    public var topSpeed:Number;
    public var framesTillTop:int;
    
    public function MovingClip(width:Number, height:Number, cutSize:Number, topSpeed:Number = 0, framesTillTop:Number = 1):void
    {
        this.topSpeed = topSpeed;
        this.framesTillTop = framesTillTop;
        player = Vector.<Number>([0,0, width/2,height, 0,height - cutSize, -width/2,height, 0,0]);
        var commands:Vector.<int> = Vector.<int>([1, 2, 2, 2, 2]);
        
        graphics.lineStyle(2, 0x000000);
        graphics.drawPath(commands, player);
        
    }
}
