/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jxGk
 */

package {
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#000000")]
    
    public class FlashTest extends Sprite {
        
        private const SW:int = stage.stageWidth;
        private const SH:int = stage.stageHeight;
        private const CX:Number = SW / 2;
        private const CY:Number = SH / 2;
        
        private var perlinBmd_:BitmapData;
        private var perlinBm_:Bitmap;
        
        private const PERLIN_WIDTH:int = 31;
        private const PERLIN_HEIGHT:int = 31;
        
        private var offsets_:Array = [new Point(), new Point()];
        private const OCTAVES:uint = offsets_.length;
        
        private var isDisp:Boolean = false;
        
        private var lineCanvas_:Shape;
        
        private const INTERVAL_WIDTH:Number = SW / (PERLIN_WIDTH - 1);
        private const INTERVAL_HEIGHT:Number = 0xFF / SH;
        private const INTERVAL_COLOR:Number = 360 / PERLIN_HEIGHT;
        
        private var g_:Graphics;
        private var colors_:Vector.<uint>;
        
        private var viewBmd_:BitmapData;
        
        private const RECT:Rectangle = new Rectangle(0, 0, SW, SH);
        private const ZERO_POINT:Point = new Point();
        private const BLUR:BlurFilter = new BlurFilter(16, 16, BitmapFilterQuality.HIGH);
        private const COLOR_TRANS:ColorTransform = new ColorTransform(1, 1, 1, 0.25);
        
        
        public function FlashTest() {
            setup();
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.CLICK, clickHandler);            
        }
        
        private function setup():void {
            perlinBmd_ = new BitmapData(PERLIN_WIDTH, PERLIN_HEIGHT, false, 0x000000);
            perlinBm_ = new Bitmap(perlinBmd_);
            addChild(perlinBm_);
            
            clickHandler(null);
            
            viewBmd_ = new BitmapData(SW, SH, true, 0xff000000);
            addChild(new Bitmap(viewBmd_));
            
            lineCanvas_ = new Shape();
            g_ = lineCanvas_.graphics;
            
            colors_ = new Vector.<uint>();
            var angle:Number = 0;
            for(var i:int = 0; i < PERLIN_HEIGHT; i++) {
                colors_.push(CycleRGB.getColor(angle));
                angle += INTERVAL_COLOR;
            }
            colors_.fixed = true;
        }
        
        private function update(e:Event):void {
            updatePerlinNoise();
            updateLines();
            updateView();
        }
        private function updatePerlinNoise():void {
            var offsetX:Number = (mouseX / CX - 1) * 0.5;
            var offsetY:Number = (mouseY / CY - 1) * 0.5;
            offsets_[0].x += offsetX;
            offsets_[0].y += offsetY;
            offsets_[1].x -= offsetX;
            offsets_[1].y -= offsetY;
            perlinBmd_.perlinNoise(PERLIN_WIDTH, PERLIN_HEIGHT, OCTAVES, 0xff, true, true, 1, true, offsets_);
        }
        
        private function updateLines():void {
            g_.clear();
            for(var h:int=0; h<PERLIN_HEIGHT; h++) {
                g_.moveTo(-20, h);
                g_.lineStyle(0, colors_[h], 1);
                for(var w:int = 0; w < PERLIN_WIDTH; w++) {
                    var value:Number = (perlinBmd_.getPixel(w, h) & 0xff)/INTERVAL_HEIGHT;
                    g_.lineTo(w * INTERVAL_WIDTH, value);
                }
            }
        }
        
        private function updateView():void {
            viewBmd_.lock();
            viewBmd_.fillRect(RECT, 0xff000000);
            viewBmd_.draw(lineCanvas_);
            viewBmd_.applyFilter(viewBmd_, RECT, ZERO_POINT, BLUR);
            viewBmd_.draw(lineCanvas_, null, COLOR_TRANS);
            viewBmd_.unlock();
        }
        private function clickHandler(e:MouseEvent):void {
            perlinBm_.visible = isDisp;
            isDisp = !isDisp;
        }
    }
}
class CycleRGB {
static public function get alpha():uint { return _alpha; }
static public function set alpha(value:uint):void {
    _alpha = (value > 0xff) ? 0xff : value;
}
private static var _alpha:uint = 0xff;

private static const PI:Number = Math.PI;
private static const DEGREE90:Number = PI / 2;
private static const DEGREE180:Number = PI;

public static function getColor(angle:Number):uint {
    var radian:Number = angle * PI / 180;
    var valR:uint = (Math.cos(radian) + 1) * 0xff >> 1;
    var valG:uint = (Math.cos(radian + DEGREE90)+1) * 0xff >> 1;
    var valB:uint = (Math.cos(radian + DEGREE180)+1) * 0xff >> 1;
    return valR << 16 | valG << 8 | valB;
}

public static function getColor32(angle:Number):uint {
    return _alpha << 24 | getColor(angle);
}

}

