/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jwx0
 */

// forked from yd_niku's I LOVE WARABI-MOCHI
package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.utils.*;
    
    [SWF(frameRate=60,width=400,height=160)]
    public class FlashTest extends Sprite {
        private const NODE_LENGTH:int = 35;
        
        private const COL:int = 4;
        private const ROW:int = 4;
        
        private var _drawList:Vector.<IDrawable> = new Vector.<IDrawable>();
        private var _updateList:Vector.<IUpdatable> = new Vector.<IUpdatable>();
        
        private var _rect:Rectangle;
        
        private var _canvas:Sprite;
        private var _hitArea:Sprite;
        
        private var _titleField:TextField;
        
        public function FlashTest() {
            addEventListener( Event.ADDED_TO_STAGE, onInit );
        }
        private function onInit( e:Event ):void {
            removeEventListener( Event.ADDED_TO_STAGE, onInit );
            addEventListener( Event.ENTER_FRAME, update );
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode= StageScaleMode.NO_SCALE;
            stage.addEventListener( Event.RESIZE, onResize );
            
            _canvas = addChild( new Sprite() ) as Sprite;
            
            //_rect = new Rectangle( 0, 0, stage.stageWidth, stage.stageHeight );
            _rect = new Rectangle( 0, 0, stage.stageWidth, 160 );
            
            _hitArea = addChild( new RectSprite( _rect )) as Sprite;
            _hitArea.addEventListener( MouseEvent.MOUSE_UP, releaseHandler );
            _hitArea.addEventListener( MouseEvent.MOUSE_DOWN, pressHandler );
            
            var offsetX:Number = (_rect.width-(COL-1)*NODE_LENGTH)*0.5>>0;
            var offsetY:Number = 1;
            var points :Vector.<SpringPoint> = new Vector.<SpringPoint>();
            for( var w:int = 0; w<COL; ++w ) {
                for( var h:int = 0; h<ROW; ++h ) {
                    var p:SpringPoint = new SpringPoint(
                            w*NODE_LENGTH + offsetX,
                            h*NODE_LENGTH  + offsetY
                    );
                    points.push( p );
                    //_drawList.push( p );
                    _updateList.push( p );
                }
            }
            const BLOCK_COL:int= COL-1;
            const BLOCK_ROW:int= ROW-1;
            const ANOTHER_LENGTH :Number = Math.sqrt(2) * NODE_LENGTH; 
            for( var bx:int=0; bx<BLOCK_COL; ++bx ) {
                for( var by:int=0; by<BLOCK_ROW; ++by ) {
                    var bi:int = by + BLOCK_ROW * bx;
                    
                    var i:int = bi+ bx;
                    var p0:SpringPoint = points[ i ]; //0
                    var p1:SpringPoint = points[ i + 1 ]; // 1
                    var p2:SpringPoint = points[ i + COL ]; // 2
                    var p3:SpringPoint = points[ i + COL +1 ]; // 3
                    
                    /*
                        0 ------ 1
                        |          |
                        |          |
                        2 ------ 3
                    */
                    var segPoints0:Vector.<SpringPoint> = new Vector.<SpringPoint>();
                    segPoints0.push( p0, p1 );
            
                    var segPoints1:Vector.<SpringPoint> = new Vector.<SpringPoint>();
                    segPoints1.push( p0, p2 );
            
                    var segPoints2:Vector.<SpringPoint> = new Vector.<SpringPoint>();
                    segPoints2.push( p1, p3 );
            
                    var segPoints3:Vector.<SpringPoint> = new Vector.<SpringPoint>();
                    segPoints3.push( p2, p3 );
            
                    var segPoints4:Vector.<SpringPoint> = new Vector.<SpringPoint>();
                    segPoints4.push( p0, p3 );
            
                    var segPoints5:Vector.<SpringPoint> = new Vector.<SpringPoint>();
                    segPoints5.push( p1, p2 );
            
                    var s0:Segment = new Segment( segPoints0, NODE_LENGTH );
                    var s1:Segment = new Segment( segPoints1, NODE_LENGTH );
                    var s2:Segment = new Segment( segPoints2, NODE_LENGTH );
                    var s3:Segment = new Segment( segPoints3, NODE_LENGTH );
            
                    var s4:Segment = new Segment( segPoints4, ANOTHER_LENGTH );
                    var s5:Segment = new Segment( segPoints5, ANOTHER_LENGTH );
                    //_segments.push( s0, s1, s2, s3, s4, s5 );
                    
                    _updateList.push( s0, s1, s2, s3, s4, s5 );
                    //_drawList.push( s0, s1, s2, s3, s4, s5 );
                    
                    var m0:Mesh = new Mesh( p0, p1, p3 ), m1:Mesh = new Mesh( p0, p3, p2 )
                    //_mesh.push( m0, m1 );
                    
                    _drawList.push( m0, m1 );
                }
            }
            
            var o0:SpringPoint = points[0]; 
            var o1:SpringPoint = points[(COL-1)*ROW];
            var o2:SpringPoint = points[ROW-1];
            var o3:SpringPoint = points[COL*ROW-1];
            
            var holizonalLength:Number = NODE_LENGTH *BLOCK_COL;
            var verticalLength:Number = NODE_LENGTH *BLOCK_ROW;
            var oPoints0:Vector.<SpringPoint> = new Vector.<SpringPoint>();
            oPoints0.push( o0, o1 );
            var oPoints1:Vector.<SpringPoint> = new Vector.<SpringPoint>();
            oPoints1.push( o0, o2 );
            var oPoints2:Vector.<SpringPoint> = new Vector.<SpringPoint>();
            oPoints2.push( o1, o3 );
            var oPoints3:Vector.<SpringPoint> = new Vector.<SpringPoint>();
            oPoints3.push( o2, o3 );
            
            var oPoints4:Vector.<SpringPoint> = new Vector.<SpringPoint>();
            oPoints4.push( o0, o3 );
            var oPoints5:Vector.<SpringPoint> = new Vector.<SpringPoint>();
            oPoints5.push( o1, o2 );
            
            var oSeg0:Segment = new Segment(  oPoints0, holizonalLength );
            var oSeg1:Segment = new Segment( oPoints1, verticalLength );
            var oSeg2:Segment = new Segment( oPoints2, holizonalLength );
            var oSeg3:Segment = new Segment( oPoints3, verticalLength );
            
            var oSeg4:Segment = new Segment( oPoints4, Math.sqrt(2)*verticalLength );
            var oSeg5:Segment = new Segment( oPoints5, Math.sqrt(2)*verticalLength );
            
            _updateList.push( oSeg0, oSeg1, oSeg2, oSeg3, oSeg4, oSeg5 );
            
            addChild( _titleField = new TextField() );
            _titleField.width = _rect.width;
            _titleField.height= 36;
            _titleField.y = (   _rect.height - _titleField.height ) * 0.5 >>0;
            _titleField.mouseEnabled = false;
            
            var textFormat:TextFormat = new TextFormat( "_serif", 24, true );
            textFormat.color = 0x66cc33;
            textFormat.align= TextFormatAlign.CENTER;
            _titleField.defaultTextFormat = textFormat;
            
            _titleField.text = "I LOVE ワラビモチ";
        }
        private function onResize( e:Event ):void {
            trace("resize");
            _rect = new Rectangle( 0, 0, stage.stageWidth, stage.stageHeight );
            
            RectSprite(_hitArea).update( _rect, 0x0 );
            
            _titleField.width = _rect.width;
            _titleField.y = ( _rect.height- _titleField.height ) * 0.5 >>0;
        }
        private var _isPress:Boolean = false;
        private function releaseHandler(e:MouseEvent):void {
            _isPress = false;
        }
        private function pressHandler(e:MouseEvent):void {
            _isPress = true;
        }
        
        private static const G:Point = new Point( 0, 0.30 );
        private function update( e:Event ):void {
            calcurate();
            draw( _canvas.graphics );
        }
        public function calcurate():void {
            if( _isPress ) {
                var np:SpringPoint = SpringPoint.getNearestPoint( new Point( mouseX, mouseY ) );
                np.x = mouseX, np.y = mouseY;
                np.vx = np.vy = 0;
            }
            
            var points:Vector.<SpringPoint> = SpringPoint.points;
            for each( var sp:SpringPoint in points ) {
                sp.applyVector( G.x, G.y );
                sp.checkBounce( _rect );
            }
            
            for each( var u:IUpdatable in _updateList ) u.update();
        }
        public function draw( g:Graphics ) :void {
            g.clear();
            for each( var d:IDrawable in _drawList ) d.draw( g );
        }
        
    }
}


import flash.display.*;
import flash.events.*;
import flash.net.*;
import flash.geom.*;
import flash.utils.*;

interface IDrawable {
    function draw( g:Graphics ):void;
}

interface IUpdatable {
    function update():void;
}

class SpringPoint extends Point implements IDrawable, IUpdatable {
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    private static const FRICTION:Number = 0.98;
    private static const BOUND:Number = -0.75;
    
    private static var _points:Vector.<SpringPoint> = new Vector.<SpringPoint>();
    public static function get points():Vector.<SpringPoint> { return _points.slice(); }
    public function SpringPoint( x:Number = 0, y:Number = 0 ) {
          super( x, y );
          _points.push( this );
    }
    public function draw( g:Graphics ) :void {
        g.lineStyle( 5, 0x00 );
        g.moveTo( x, y );
        g.lineTo( x+0.5, y+0.5 );
    }
    public function update():void {
        vx *= FRICTION;
        vy *= FRICTION;
        x += vx;
        y += vy;
    }
    public function applyVector( vvx:Number, vvy:Number ):void {
        vx += vvx;
        vy += vvy;
    }
    public function checkBounce( rect:Rectangle ) :void {
        if( rect.left > x  ) {
            vx *= BOUND;
            x = rect.left +1;
        }
        else if( rect.right < x ) {
            vx *= BOUND;
            x = rect.right -1;
        }
        if( rect.top > y  ) {
            vy *= BOUND;
            y = rect.top +1;
        }
        else if( rect.bottom < y ) {
            vy *= BOUND;
            y = rect.bottom-1;
        }
    }
    public static function getNearestPoint( target:Point ):SpringPoint{
        var nearest:Point = _points[0] as Point;
        for each( var p:Point in _points ) {
            if( Point.distance( target, p ) < Point.distance( target, nearest ) ) {
                nearest  = p;
            }
        }
        return nearest as SpringPoint;    
    }
}


class Segment implements IDrawable, IUpdatable {
    private var _length:Number;
    private var _points:Vector.<SpringPoint>;
    
    private var _strong:Number = 0.35;
    public function Segment( points:Vector.<SpringPoint>, length:Number ) {
        _points = points;
        _length = length;
    }
    public function draw( g:Graphics ) :void {
        var p0:SpringPoint= _points[0];
        var p1:SpringPoint= _points[1];
        g.lineStyle( 0, 0x999999 );
        g.moveTo( p0.x, p0.y );
        g.lineTo( p1.x, p1.y );
    }
    public function update():void {
        var p0:SpringPoint= _points[0];
        var p1:SpringPoint= _points[1];
        
        var diff:Point=p0.subtract(p1);
        
        var distance:Number = diff.length - _length;
        var refrection:Number = distance/2 *_strong;
        
        var maxVelocity:Number = _length*0.075;
        diff.normalize( Math.min( maxVelocity, Math.max( -maxVelocity, refrection ) ) );

        
        p0.vx = p0.vx + -diff.x;
        p0.vy = p0.vy + -diff.y;
        p1.vx = p1.vx +  diff.x;
        p1.vy = p1.vy +  diff.y;
    }
}

class Mesh implements IDrawable {
    private var _points:Vector.<Point>= new Vector.<Point>();
    public function Mesh( ...rest ) {
        for each( var p:Point in rest ) _points.push(p);
    }
    public function draw( g:Graphics ):void {
        var $area:Number = area;
        g.lineStyle( undefined );
        g.beginFill( 0xf0f099,  $area );
        for( var i:int =0; i<_points.length; ++i  ) {
             var p:Point = _points[i];
             if( i == 0 ) g.moveTo( p.x, p.y );
             else g.lineTo( p.x, p.y );
         }
        g.beginFill( 0xf0f099 );
    }
    public function get area():Number {
        var p0:Point = _points[0];
        var p1:Point = _points[1];
        var p2:Point = _points[2];
        var $area:Number = ( p0.x * p1.y + p1.x * p2.y + p2.x * p0.y - p0.y * p1.x - p1.y * p2.x -  p2.y * p0.x  ) * 0.5;
        return 550/Math.abs( $area );
    }
}


class RectSprite extends Sprite{
    public function RectSprite( rect:Rectangle, color:uint = 0x0 ) {
        super();
        update( rect, color );
    }
    public function update(rect:Rectangle, color:uint ):void {
        var $color:uint  = color | (0xFF<<24);
        var $alpha:uint = (color & 0xFF<<24)>>24;
        
        graphics.beginFill( $color, $alpha/256 );
        graphics.drawRect( rect.x, rect.y, rect.width, rect.height );
        graphics.endFill();
    }
}
