/**
 * Copyright nishink ( http://wonderfl.net/user/nishink )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jwJP
 */

// マウス操作のサンプル
// 以前作ったものを改造
// ボタンを押した場所と離した場所の間に線を引く処理を追加
package {
	import flash.display.Sprite;
	// 土台のSprite
	public class FlashTest extends Sprite {
		public function FlashTest() {
			// 土台のSprite(FlashTest)は
			// なぜかマウスイベントを受信できないようなので
			// 受信用のSprite(RenderField)を作って
			// addChildする
			addChild(new RenderField());
		}
	}
}

import flash.display.Sprite;
import flash.events.MouseEvent;

// マウスイベント受信用のSprite
class RenderField extends Sprite {
	private var downX:int;
	private var downY:int;
	public function RenderField() {
		// 色を塗る
		graphics.beginFill(0xFFFFCC);
		graphics.drawRect(0, 0, 465, 465);
		graphics.endFill();
		// マウスイベントが発生したときに動く処理を指定
		addEventListener(MouseEvent.CLICK, click);
		addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
	}

	// クリックイベント
	// マウスのボタンを離したタイミングで発生する
	private function click(ev:MouseEvent):void {
		// マウスの位置に四角形を描画
		graphics.beginFill(0x0000FF);
		graphics.drawRect(ev.stageX, ev.stageY, 10, 10);
		// ボタンを押した場所から離した場所まで線を引く
		graphics.lineStyle(1, 0x000000);
		graphics.moveTo(downX+5, downY+5);
		graphics.lineTo(ev.stageX+5, ev.stageY+5);
		graphics.lineStyle();
		graphics.endFill();
	}

	// ボタン押下イベント
	// マウスのボタンを押したタイミングで発生する	
	private function mouseDown(ev:MouseEvent):void {
		downX = ev.stageX;
		downY = ev.stageY;
		// マウスの位置に四角形を描画
		graphics.beginFill(0x008800);
		graphics.drawRect(ev.stageX, ev.stageY, 10, 10);
		graphics.endFill();
	}
}
