/**
 * Copyright chez_sugi ( http://wonderfl.net/user/chez_sugi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jvxK
 */

/*
RunDemo for GTween by Grant Skinner, gskinner.com/blog/

This sample demonstrates 5 concepts:
1) Synchronizing timeline animations with time based tweens by tweening currentFrame.
2) using GTweenTimeline as both a tween and as a timeline.
3) achieving complex animations by using multiple tweens to affect a single target.
4) callbacks.
5) pausing tweens.

Test the movie, and click to pause the tween. Notice that the run cycle also pauses,
but the fire animation doesn't, because it isn't synchronized to the tween.

Also note that you can change the FLA framerate, and the animation will always run for 3 seconds,
and the run cycle always stays synchronized, but the fire will play according to the framerate.
*/

package  {
    
    import com.gskinner.motion.easing.*;
    import com.gskinner.motion.GTween;
    import com.gskinner.motion.GTweenTimeline;
    import com.gskinner.motion.plugins.CurrentFramePlugin;
    
    import flash.display.MovieClip;
    import flash.events.MouseEvent;
    
    public class GTweenRunDemo extends MovieClip {
        
    // Constants:
        
    // Public Properties:
        public var fire:MovieClip;
        public var dude:MovieClip;
        
    // Protected Properties:
        protected var moveTween:GTweenTimeline;
        
    // Initialization:
        public function GTweenRunDemo() {
            CurrentFramePlugin.install();

            dude.stop();
            var animationTween:GTween = new GTween(dude,0.5,{currentFrame:dude.totalFrames},{repeatCount:0});
            // we'll use two tweens for the jump, one for up, one for down.
            var jumpUpTween:GTween = new GTween(dude,0.2,{y:dude.y},{ease:Sine.easeOut});
            var jumpDownTween:GTween = new GTween(dude,0.25,{y:dude.y},{ease:Sine.easeIn});
            
            // we could do the jump with one tween that uses reflect, but then we couldn't have
            // different durations or a delay between up and down (while he's running on the box).
            // it would look something like this:
            //var jumpTween:GTween = new GTween(dude,0.3,{y:dude.y-box.height},{ease:Sine.easeOut,reflect:true,repeat:1});
            
            // we can use this GTweenTimeline instance to both tween the x position, and sequence
            // the dependent tweens. Note that we are using the short form fifth parameter for
            // adding tweens instead of addTween [tween, startPosition, ...]
            moveTween = new GTweenTimeline(dude,3,{x:545},{repeatCount:0},null,[0,animationTween,1.4,jumpUpTween,1.8,jumpDownTween]);
            
            // add callbacks to show and hide the fire at the right time.
            // of course these won't work correctly if the tween was played in reverse, or reflected.
            moveTween.addCallback(1.5,showFire,[true]);
            moveTween.addCallback(moveTween.duration,showFire,[false]);
            
            fire.visible = false;
            
            // instead of setting up a custom function, we could have used the built in method for setting property values on objects.
            // it would look something like this:
            // moveTween.addCallback(1.5,GTweenTimeline.setPropertyValue,[fire,"visible",true]);
            
            // add mouseMove listener, to change timeScale.
            stage.addEventListener(MouseEvent.MOUSE_MOVE,handleMove);
            
            // add click listener, to pause on click.
            stage.addEventListener(MouseEvent.CLICK,handleClick);
        }
        
    // Public getter / setters:
        
    // Public Methods:
        
    // Protected Methods:
        
        protected function showFire(value:Boolean):void {
            fire.visible = value;
        }
        
        protected function handleClick(evt:MouseEvent):void {
            // toggle paused property:
            moveTween.paused = !moveTween.paused;
        }
        
        protected function handleMove(evt:MouseEvent):void {
            moveTween.timeScale = mouseX/275;
        }
    }
    
}