/**
 * Copyright roboprez ( http://wonderfl.net/user/roboprez )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jvIs
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	/**
	 * ...
	 * @author roboprez
	 */
	public class Main extends Sprite
	{
		private var bitData:BitmapData
		private var bit:Bitmap
		private var points:Array;
		private var seed:int;
		
		public function Main() 
		{
			    //http://www.adobe.com/livedocs/flash/9.0/ActionScriptLangRefV3/flash/display/BitmapData.html#perlinNoise()
			bitData = new BitmapData(200, 200)
			bit = new Bitmap(bitData)
			bit.width = bit.height = 600
			addChild(bit)
			
			points = new Array()
			points.push(new Point())
			points.push(new Point())
			
			seed = Math.floor(Math.random()*30)
			bitData.perlinNoise(200, 200, 2, seed, false, false, 7, false, points)
			addEventListener(Event.ENTER_FRAME, enterFrame)
		}
		
		private function enterFrame(e:Event):void 
		{
			points[0].x += (mouseX-300)/50
			points[0].y += (mouseY-300)/50
			points[1].x += -(mouseX-300)/50
			points[1].y += -(mouseY-300)/50
			bitData.perlinNoise(200, 200, 2, seed, false, false, 7, false, points)
		}
		
	}

}