/**
 * Copyright applicott ( http://wonderfl.net/user/applicott )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/juNb
 */

package
{
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.sampler.getSampleCount;
    
    import frocessing.color.ColorHSV;
    
    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.cameras.SpringCamera3D;
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.objects.primitives.PaperPlane;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    
    [SWF(backgroundColor=0x0)]    
    public class pv4 extends BasicView
    {
        private var vec:Vector.<Text3D>=new Vector.<Text3D>;
        private var str:String;
        private var t:Number=0;
        private var pp:PaperPlane;
        private var s:Number=0;
        private const length:int = 1600;
        private var dd:Number=0;
        
        private var mat:Letter3DMaterial = new Letter3DMaterial(0xFFFFFF);
        private var font:HelveticaBold = new HelveticaBold();
        private var theta:Number;
        private var hi:Text3D;
        
        private var hsv:ColorHSV;
        
        public function pv4()
        {
            graphics.beginFill(0x0);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            graphics.endFill();
            
            Wonderfl.capture_delay(5);
            super(465, 465, true, false, CameraType.SPRING);
            var wmat:WireframeMaterial=new WireframeMaterial(0x0000ff);
            wmat.doubleSided=true;
            pp=new PaperPlane(wmat);
            camera.target=pp;
            
            scene.addChild(new ParticleField(new ParticleMaterial(0xffffff, 0.8, 0), 12000, 2, 4300, 4000, 4000));
            scene.addChild(pp);
            
            
            hsv = new ColorHSV(0, 1, 1);
            
            //各パラメータの設定
            SpringCamera3D(camera).mass = 50;
            SpringCamera3D(camera).damping = 30;
            SpringCamera3D(camera).stiffness = 4;
            SpringCamera3D(camera).positionOffset = new Number3D(0,100,0);
            SpringCamera3D(camera).lookOffset = new Number3D(0,100,0);
            
            startRendering();
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
            
            hi=new Text3D("",font,mat);
            scene.addChild(hi);
        }
        public function onEnterFrame(e:Event):void{
            t+=0.2+dd;
            
            hsv.h+=0.1;
            
            var d:Date = new Date();
            //飛行機
            var angle:Number = (t / 100) * 360 * Math.PI / 180;
            pp.x = Math.cos(angle) * length;
            pp.z = Math.sin(angle) * length;
            pp.y = 0.3 * Math.cos(angle) * length + 300;   
            pp.rotationY=-toDegree(pp.x,pp.z);
            
            //時間
            if(s!=d.getSeconds()){
                mat.doubleSided = true;
                s= d.getSeconds();
                var str:String=to2time(d.getHours()) + ":" + to2time(d.getMinutes()) + ":" + to2time(d.getSeconds());
                
                var tmat:Letter3DMaterial = new Letter3DMaterial(hsv.toRGB().value);
                tmat.doubleSided=true;
                var text:Text3D=new Text3D(str,font,tmat);
                text.x = Math.cos(angle+90) * length;
                text.z = Math.sin(angle+90) * length;
                text.y = 0.3 * Math.cos(angle+90) * length + 300;
                text.rotationY=-toDegree(text.x,text.z);
                
                if(d.getSeconds()%10==0){
                    dd=Math.random()*0.25;
                    var h:String=d.getFullYear()  + "/" + 1 + "/" + d.getDate() +" ";
                    hi.text=h;
                    hi.x = Math.cos(angle+90) * length;
                    hi.z = Math.sin(angle+90) * length;
                    hi.y = 0.3 * Math.cos(angle+90) * length + 420;
                    hi.rotationY=-toDegree(text.x,text.z);
                    
                    SpringCamera3D(camera).stiffness = 1+Math.random()*10;
                    
                }
                            
            if(d.getSeconds()%10==5){
                hi.text="";
            }
                vec.push(text);
                scene.addChild(text);
            }
            
            //時間削除
            if(vec.length>8) {
                var c:Text3D = vec[0];
                vec.splice(0, 1);
                scene.removeChild(c);
            }
            
            
        }
        
        private function to2time(i:Number):String {
            if(i<10) return "0"+i.toString();
            else return i.toString();
        }
        
        private function toDegree( x:Number , y:Number ):Number {
            var i:Number = 0;
            // x と y が 0 の時は算出できない
            if ( ( x == 0 ) && ( y == 0 ) ) return 0;
            // 角度θを算出
            i = Math.acos( x / Math.sqrt( x * x + y * y ) );
            // ラジアンを度へ変換
            i = ( i / Math.PI ) * 180;
            // θ>πの時
            if ( y < 0 ) i = 360 - i;
            return i;
        }
    }
}
