/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jte4
 */

package {
    import flash.display.*;
    import flash.events.*;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            drawRect1();
            drawRect2();
            
            //
            var resource:BitmapDataResource = new BitmapDataResource(ResourceMap .IMG);
            resource.addEventListener( Event.COMPLETE, onComplete );
            resource.load();
        }
        
        private function onComplete(e:Event):void {
            var bitmapData:BitmapData = BitmapDataResource.getResource( ResourceMap.IMG );
            var bmp :DisplayObject = addChild( new Bitmap(bitmapData) );
            bmp.x = 230;
            bmp.y = 10;
            
            drawBitmapRect();
        }

        // @see http://help.adobe.com/ja_JP/ActionScript/3.0_ProgrammingAS3/WS84753F1C-5ABE-40b1-A2E4-07D7349976C4.html
        private function drawRect1():void {
            var rect:Sprite = new Sprite();
            rect.graphics.beginFill(0xFF8000); 
            rect.graphics.drawTriangles( 
                Vector.<Number>([ 
                0,0,  100,0,  0,100, 
                100,0, 100,100, 0,100]));
            rect.graphics.endFill();
            rect.x = rect.y = 10;
            addChild( rect );
        }
         
       // @see http://help.adobe.com/ja_JP/ActionScript/3.0_ProgrammingAS3/WS84753F1C-5ABE-40b1-A2E4-07D7349976C4.html
       private function drawRect2():void {
            var rect:Sprite = new Sprite();
            rect.graphics.beginFill(0xFF5000); 
            rect.graphics.drawTriangles( 
                Vector.<Number>([0,0, 100,0, 0,100, 100,100]), 
                Vector.<int>([0,1,2, 2,1,3 ]));
            rect.graphics.endFill();
            rect.x = 120;
            rect.y = 10;
            addChild( rect);
        }
        
        
        private function drawBitmapRect():void{
            var bitmapData:BitmapData = BitmapDataResource.getResource( ResourceMap.IMG );
            
            var rect:Sprite = new RotationNiku( bitmapData );
            rect.x = 230+48;
            rect.y = 110;
            addChild(rect);    
        }
    }
}



import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.net.*;
import flash.utils.*;
import flash.system.*;


internal class RotationNiku extends Sprite {
    private var _texture:BitmapData;
    
    private var _points:Vector.<Number> = new Vector.<Number>();
    private var _indeces:Vector.<int> = new Vector.<int>();
    private var _uv:Vector.<Number> = new Vector.<Number>();
    
    private var _points3D:Vector.<Number> = new Vector.<Number>();
    
    private var _matrix:Matrix3D= new Matrix3D();
    
    public function RotationNiku( bitmapdata:BitmapData ) {
        _texture = bitmapdata;
        _points.push(
            0,0,
            0,100,
            100,0,
            100,100
        );
        _points3D.push(
            0,0,100,      // 0 left-top
            0,100,-100,   // 1 left-bottom
            100,0,50,    // 2 right-top
            100,100,0    // 2 right-top
        );
        
        _indeces.push( 0,1,2, 2,1,3 );
        
        //_uv.push( 0,0, 0,1, 1,0, 1,1 );
        _uv.push( 0,0,0, 0,1,0, 1,0,0, 1,1,0 );
        
        addEventListener( Event.ENTER_FRAME, enterframeHandler );
    }
    
    private function enterframeHandler(e:Event):void {
        _matrix.appendRotation( 1, Vector3D.X_AXIS );
        update();
        drawRect();
    }
    
    private function update():void{
        Utils3D.projectVectors( _matrix, _points3D, _points, _uv );
        //trace(_points3D.length)
        //trace(_points.length)
    }
    
    private function drawRect():void {
        graphics.clear();
        graphics.beginBitmapFill(_texture); 
        graphics.drawTriangles( _points, _indeces, _uv );
        graphics.endFill();
    }
}


internal class ResourceMap {
    public static const IMG:String = "http://assets.wonderfl.net/images/related_images/7/74/741f/741fc0b9afc2ddb3db777a9d2c3c4705dc064054";
}

internal class BitmapDataResource extends EventDispatcher {
        private static var _resources:Dictionary = new Dictionary();
        
        private var _key: String;
        public function BitmapDataResource ( key:String ) {
            _key = key;
        }
        public function load():void {
            var req:URLRequest = new URLRequest(_key);
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onLoadComplete );
            loader.load( req, new LoaderContext(true) );
        }
        private function onLoadComplete(e:Event):void {
            var loaderInfo :LoaderInfo = e.target as LoaderInfo;
            var content:Bitmap = Loader( loaderInfo.loader ).content as Bitmap;
            _resources[ _key ] = content.bitmapData;
            
            dispatchEvent( new Event(Event.COMPLETE) );
        }
        
        public static function getResource( key:String ) :BitmapData{
            return _resources[ key ] as BitmapData;
        }
}