/**
 * Copyright toburau ( http://wonderfl.net/user/toburau )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jsvS
 */

// 赤い丸をクリックすると回転スタート
// 
package {
    import flash.display.Sprite;
    import flash.text.*;
    import flash.events.MouseEvent;
    import flash.events.Event;

    public class angle extends Sprite {
        public function angle() {
        init();
    }

    private var sprite:Sprite = new Sprite();
    private const R:Number = 100;
    private var rad:Number = 0;
    public function init():void {
        sprite.graphics.beginFill(0xff0000);
        sprite.graphics.drawCircle(0,0,20);
        sprite.graphics.endFill();
        setPos(rad);
        drawLine(rad);
        addChild(sprite);
        sprite.addEventListener(MouseEvent.CLICK, onClick);
    }

    public function drawLine(n:Number):void {
        graphics.clear();
        graphics.lineStyle(2,0x0000ff);
        var cx:Number = stage.stageWidth/2;
        var cy:Number = stage.stageHeight/2;
        graphics.drawCircle(cx,cy,R);
        graphics.lineStyle(2,0x00ff00);
        graphics.moveTo(cx,cy);
        graphics.lineTo(cx + R * Math.cos(n), cy + R * Math.sin(n));
    }
    public function setPos(n:Number):void {
        sprite.x = stage.stageWidth/2 + R * Math.cos(n);
        sprite.y = stage.stageHeight/2 + R * Math.sin(n);
    }        

    public function onClick(e:MouseEvent):void {
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    public function onEnterFrame(e:Event):void {
        rad += 0.1;
        if(rad > Math.PI*2.0) rad -= Math.PI*2.0;
        setPos(rad);
        drawLine(rad);
    }
    }
}
