/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jsfJ
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
    public class FlashTest extends Sprite {
		private var _container:Sprite;
		
		private const COLORS:Array = new Array(
			0xff4040,
			0x40ff40,
			0x4040ff,
			0xffff40,
			0xff40ff,
			0x40ffff
		);
		
        public function FlashTest() {
			stage.frameRate = 60;
			
			this.graphics.beginFill(0x000000);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			var floor:Sprite = new Sprite();
			floor.graphics.beginFill(0x808080);
			floor.graphics.drawRect(-200, -200, 400, 400);
			floor.graphics.endFill();
			floor.rotationX = 90;
			
            _container = new Sprite();
			_container.x = 232.5;
			_container.y = 220;
			_container.rotationX = 20;
			this.addChild(_container);
			
			_container.addChild(floor);
			
			var bodyRoot:Sprite = new Sprite();
			var shadowRoot:Sprite = new Sprite();
			
			_container.addChild(shadowRoot);
			_container.addChild(bodyRoot);
			
			var array:Array = new Array();
			for (var index:uint = 0; index < 20; ++index) {
			}
			
			var tf:TextField = new TextField();
			tf.textColor = 0xffffff;
			tf.width = 400;
			this.addChild(tf);
			
			var frame:uint = 0;
			var proc:Function = function(e:Event):void {
				++frame;
				if (frame > 3) {
					frame = 0;
					var color:uint = COLORS[uint(Math.random() * COLORS.length)];
					var s:Sphere = new Sphere(bodyRoot, shadowRoot, color);
					s.x = 0;
					s.z = 0;
					array.push(s);
				}

				for (var index:uint = 0; index < array.length; ++index) {
					if (array[index].isFade) {
						array.splice(index, 1);
						--index;
						continue;
					}
				}
				
				
			}
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
    }
}

import flash.events.Event;
import flash.display.Sprite;
import flash.geom.Point;
import caurina.transitions.Tweener;

class Sphere extends Sprite
{
	private var _body:Sprite;
	private var _shadow:Sprite;
	private var _speed:Point;
	private var _speedV:Number;
	private var _isBound:Boolean;
	private var _isFade:Boolean;
	
	public function get isFade():Boolean { return _isFade; }
	
	public function Sphere(bodyRoot:Sprite, shadowRoot:Sprite, color:uint) {
		_body = new Sprite();
		_body.graphics.lineStyle(2, color);
		_body.graphics.beginFill(0xffffff);
		_body.graphics.drawCircle(0, -4, 4);
		_body.graphics.endFill();
		_body.y = -50;
		
		_shadow = new Sprite();
		_shadow.graphics.beginFill(0x000000, 0.5);
		_shadow.graphics.drawEllipse(-5, -2, 10, 4);
		_shadow.graphics.endFill();
		_shadow.rotationX = -70;
		
		var maxSpeed:Number = 2.5;
		var minSpeed:Number = 1.0;
		var speed:Number = Math.random() * (maxSpeed - minSpeed) + minSpeed;
		var rad:Number = Math.random() * Math.PI * 2;
		_speed = new Point(Math.cos(rad) * speed, Math.sin(rad) * speed);
		
		var maxSpeedV:Number = 3.0;
		var minSpeedV:Number = 1.0;
		_speedV = -(Math.random() * (maxSpeedV - minSpeedV) + minSpeedV);
		
		_isFade = false;
		_isBound = false;

		shadowRoot.addChild(_shadow);
		bodyRoot.addChild(_body);
		
		this.addEventListener(Event.ENTER_FRAME, proc);
		
		proc(new Event(Event.ENTER_FRAME));
	}
	
	private function proc(e:Event):void {
		if (_isBound) return;
		
		_body.x += _speed.x;
		_body.z += _speed.y;
		_shadow.x += _speed.x;
		_shadow.z += _speed.y;
		
		_speedV += 0.1;
		_body.y += _speedV;
		
		if (_body.y > 0) {
			_body.y = 0;
			_speedV *= -0.95;
			
			_isBound = true;
			
			var boundScaleX:Number = 1.1;
			var boundScaleY:Number = 0.8;
			var frame:uint = 2;
			Tweener.addTween(_body,
				{
					scaleX:boundScaleX,
					scaleY:boundScaleY,
					time:frame,
					useFrames:true
				}
			);
			Tweener.addTween(_body,
				{
					scaleX:1,
					scaleY:1,
					delay:frame,
					time:2,
					useFrames:true,
					onComplete:function():void {
						_isBound = false;
					}
				}
			);
		}
		
		if (!_isFade) {
			if (Math.abs(_body.x) > 200 || Math.abs(_body.z) > 200) {
				_isFade = true;
				var param:Function = function(obj:Sprite):Object {
					return {
						alpha:0,
						time:20,
						useFrames:true,
						onComplete:function():void {
							obj.parent.removeChild(obj);
						}
					}
				}
				
				Tweener.addTween(_body, param(_body));
				Tweener.addTween(_shadow, param(_shadow));
				this.removeEventListener(Event.ENTER_FRAME, proc);
			}
	    }
	}
}