/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jsc7
 */

package {
    import flash.utils.ByteArray;
    import flash.net.URLRequest;
    import flash.net.URLStream;
    import flash.media.SoundChannel;
    import flash.events.*;
    import flash.media.Sound;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var _sound:Sound;
        private var _channel:SoundChannel;
        private var _isPlaying:Boolean = false;
        public function FlashTest() {
            
            var url:URLRequest = new URLRequest('http://www.takasumi-nagai.com/soundfiles/sound001.mp3');
            _sound  = new Sound();
            _sound.load(url);
            _sound.addEventListener(SampleDataEvent.SAMPLE_DATA, dataHandler);
            _channel = _sound.play();
            _isPlaying = true;
            
            stage.addEventListener(MouseEvent.MOUSE_UP, function(): void{
                if ( _isPlaying ) {
                    _isPlaying = false;
                    _channel.stop();
                }
                else{
                    _isPlaying = true;
                    _channel = _sound.play();
                }
            });
        }
        
        private function dataHandler(e:SampleDataEvent):void{
            var bytes:ByteArray = new ByteArray();
            var avail:Number = _sound.extract(bytes, 8192);
            e.data.writeBytes(upOctave(bytes));
        }
        
private function upOctave(bytes:ByteArray):ByteArray
{
    var returnBytes:ByteArray = new ByteArray();
    bytes.position = 0;
    while(bytes.bytesAvailable > 0)
    {
        returnBytes.writeFloat(bytes.readFloat());
        returnBytes.writeFloat(bytes.readFloat());
        if (bytes.bytesAvailable > 0)
        {
            bytes.position += 8;
        }
    }
    return returnBytes;
}
    }
}