/**
 * Copyright chez_sugi ( http://wonderfl.net/user/chez_sugi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jq9Z
 */

package  
{
    import a24.tween.*;
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
        
    public class Main extends MovieClip 
    {
        private var _box1:Sprite;
        private var _box2:Sprite;
        private var _box3:Sprite;
        private var _box4:Sprite;
        private var _box5:Sprite;
        private var _box6:Sprite;
        private var _box7:Sprite;
        
        public function Main() 
        {
            // グリッドガイドを描画
            drawGrid();
            
            /*
             * =============================================================================
             * 
             * 
             * 通常のトゥイーン
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            // ↓ 行頭の "/" を1つ外すとコメントアウトされ、2つつけるとコメントが外れます
            //* <====================================================
            
            // ■ を作ります。
            createBoxes(1);
            
            // box1を、1秒かけてX座標400にトゥイーンします
            Tween24.tween(_box1, 1).x(400).play();
            
            // ----------------------------------------------------> */
            
            
            
            /* <====================================================
            
            // ターゲットに配列を指定することで、複数のターゲットを同時にトゥイーンさせることもできます
            
            createBoxes(3);
            
            var boxes:Array = [_box1, _box2, _box3];
            Tween24.tween(boxes, 1).x(400).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * プロパティ設定
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(1);
            
            // box1をX座標220、45度に回転
            Tween24.prop(_box1).x(220).rotation(45).play();
            
            // ----------------------------------------------------> */
            
            
            
            /* <====================================================
            
            createBoxes(3);
            
            // ターゲットに配列を指定することで、複数のターゲットを同時にプロパティ設定することもできます
            var boxes:Array = [_box1, _box2, _box3];
            Tween24.prop(boxes).x(220).rotation(45).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * イージングの設定
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(1);
            
            // Ease24クラスを使う場合
            Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).x(400).play();
            
            // ----------------------------------------------------> */
            
            
            
            /* <====================================================
            
            createBoxes(1);
            
            // Tween24.easeを使う場合
            Tween24.tween(_box1, 1, Tween24.ease.ExpoInOut).x(400).play();
            
            // ----------------------------------------------------> */
            
            
            
            /* <====================================================
            
            createBoxes(1);
            
            // デフォルトのイージングをTweenerと同じにする
            Tween24.defaultEasing = Ease24._6_ExpoOut;
            Tween24.tween(_box1, 1).x(400).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * 直列トゥイーン
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(3);
            var boxes:Array = [_box1, _box2, _box3];
            
            // トゥイーンを順番に再生します。
            Tween24.serial(
                Tween24.prop(boxes).fadeOut(),
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).x(400).fadeIn(),
                Tween24.tween(_box2, 1, Ease24._6_ExpoInOut).x(400).fadeIn(),
                Tween24.tween(_box3, 1, Ease24._6_ExpoInOut).x(400).fadeIn()
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * 並列トゥイーン
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(3);
            var boxes:Array = [_box1, _box2, _box3];
            
            // トゥイーンを同時に再生します。
            Tween24.parallel(
                Tween24.prop(boxes).fadeOut(),
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).x(400).fadeIn(),
                Tween24.tween(_box2, 1, Ease24._6_ExpoInOut).x(400).fadeIn(),
                Tween24.tween(_box3, 1, Ease24._6_ExpoInOut).x(400).fadeIn()
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * 時間差トゥイーン
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(5);
            var boxes:Array = [_box1, _box2, _box3, _box4, _box5];
            
            // ターゲットを配列で指定し、時間差でトゥイーンを再生します。
            // Tween24.lag(遅延時間、トゥイーン...)
            Tween24.lag(0.3,
                Tween24.prop(boxes).fadeOut(),
                Tween24.tween(boxes, 1, Ease24._BackOut).x(400).fadeIn()
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * 繰り返しトゥイーン
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(1);
            
            // トゥイーンを繰り返し再生します。
            // Tween24.loop(繰り返し回数、トゥイーン...)
            Tween24.loop(3,
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).x(400),
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).x(60)
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * 相対値トゥイーン その1
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(1);
            
            // $付きパラメータを使うことで、現在の値からの相対値で指定できます。
            Tween24.serial(
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).$x(340),
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).$x(0),
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).$y(180),
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).$y(0)
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * 相対値トゥイーン その2
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(1);
            
            // $$付きパラメータを使うことで、トゥイーンが再生される直前の値からの相対値で指定できます。
            Tween24.serial(
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).$$x(340),
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).$$x(-340),
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).$$y(180),
                Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).$$y(-180)
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * グローバル座標トゥイーン
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            // globalX, globalY プロパティを使うことで、グローバル座標での値を指定できます。
            
            createBoxes(7);
            var boxes:Array = [_box1, _box2, _box3, _box4, _box5, _box6, _box7];
            
            // コンテナを生成、画面の外へ移動
            var container:Sprite = new Sprite();
            container.x = container.y = 1000;
            addChild(container);
            
            Tween24.serial(
                // ボックスをコンテナに入れる
                Tween24.addChild(container, boxes),
                // 画面内のランダムな位置へ移動
                Tween24.prop(_box1).globalX(Math.random() * 460).globalY(Math.random() * 460),
                Tween24.prop(_box2).globalX(Math.random() * 460).globalY(Math.random() * 460),
                Tween24.prop(_box3).globalX(Math.random() * 460).globalY(Math.random() * 460),
                Tween24.prop(_box4).globalX(Math.random() * 460).globalY(Math.random() * 460),
                Tween24.prop(_box5).globalX(Math.random() * 460).globalY(Math.random() * 460),
                Tween24.prop(_box6).globalX(Math.random() * 460).globalY(Math.random() * 460),
                Tween24.prop(_box7).globalX(Math.random() * 460).globalY(Math.random() * 460),
                // 1秒待機
                Tween24.wait(1),
                // 中央にトゥイーン
                Tween24.tween(boxes, 1, Ease24._6_ExpoInOut).globalX(220).globalY(220)
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * ベジェトゥイーン
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(1);
            
            // bezier プロパティを使うことで、曲線を描くように座標トゥイーンさせることができます。
            Tween24.serial(
                Tween24.tween(_box1, 1).x(400).bezier(230, 50),
                Tween24.tween(_box1, 1).x(60).bezier(300, 400).bezier(200, 0)
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * フィルタトゥイーン
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(6);
            
            Tween24.serial(
                // ブラーフィルタ
                Tween24.prop(_box1).blur(0, 0),
                Tween24.tween(_box1, 0.8).blur(16, 16),
                
                // グローフィルタ
                Tween24.prop(_box2).glow(0x000000, 0, 0, 0), 
                Tween24.tween(_box2, 0.8).glow(0x000000, 1, 16, 16),
                
                // ドロップシャドウ
                Tween24.prop(_box3).dropShadow(0, 45, 0x000000, 0, 0, 0), 
                Tween24.tween(_box3, 0.8).dropShadow(8, 135, 0x000000, 1, 8, 8),
                
                // 着色
                Tween24.tween(_box4, 0.8).color(0xCC3333, 1),
                
                // 彩度 (値 0~1)
                Tween24.tween(_box5, 0.8).saturation(0),
                
                // 明度 (値 0~2.55)
                Tween24.tween(_box6, 0.8).bright(2.55)
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * 条件分岐トゥイーン その1
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(1);
            
            // タイマー
            var timer:Timer = new Timer(1000, 0);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
            
            function onTimer(e:TimerEvent):void
            {
                Tween24.serial(
                    Tween24.wait(0.4),
                    
                    // タイマーのカウントが奇数の時
                    Tween24.ifCase(timer.currentCount % 2 == 1,
                        // trueなら、右へ移動
                        Tween24.tween(_box1, 0.6, Ease24._6_ExpoInOut).$$x(340)
                        
                        // falseなら、左へ移動
                        ,Tween24.tween(_box1, 0.6, Ease24._6_ExpoInOut).$$x(-340)
                    ),
                    // 移動後、回転する
                    Tween24.tween(_box1, 0.4, Ease24._6_ExpoOut).$$rotation(90)
                ).play();
            }
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * 条件分岐トゥイーン その2
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(1);
            
            // 右へ移動するトゥイーン
            var tween:Tween24 = Tween24.tween(_box1, 4).$x(340);
            tween.play();
            
            // タイマーカウント時に再生するトゥイーン
            var timerTween:Tween24 = Tween24.serial(
                // トゥイーンが再生中かどうか
                Tween24.ifCaseByProp(tween, "playing",
                    // トゥイーンが再生中なら、彩度を落として一時停止
                    Tween24.serial(
                        Tween24.func(tween.pause),
                        Tween24.prop(_box1).saturation(0)
                    ),
                    // トゥイーンが停止中なら、彩度を戻して再生
                    Tween24.serial(
                        Tween24.func(tween.play),
                        Tween24.prop(_box1).saturation(1)
                    )
                ),
                // 回転する
                Tween24.tween(_box1, 0.4, Ease24._6_ExpoOut).$$rotation(90)
            );
            
            // タイマー
            var timer:Timer = new Timer(1000, 6);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
            
            function onTimer(e:TimerEvent):void
            {
                timerTween.play();
            }
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * 関数トゥイーン
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            Tween24.tweenFunc(draw, 1, [50, 10], [320, 100]).delay(1).play();
            
            function draw(_x:Number, _size:Number):void {
                graphics.lineStyle(1, 0x999999);
                graphics.drawCircle(_x, 220, _size);
            }
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * トゥイーンの途中で、次のトゥイーンへ移行する
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(4);
            
            // Tween24.skip()を使う場合
            var boxes:Array = [_box1, _box2, _box3, _box4];
            
            Tween24.serial(
                Tween24.prop(boxes).fadeOut(),
                Tween24.parallel(
                    Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).x(400).fadeIn(),
                    Tween24.tween(_box2, 1, Ease24._6_ExpoInOut).x(400).fadeIn().delay(1),
                    Tween24.skip(1) // 1秒後に連続したトゥイーンを抜け出し
                ),
                // 次のトゥイーンに移行します
                Tween24.parallel(
                    Tween24.tween(_box3, 1, Ease24._6_ExpoInOut).x(400).fadeIn(),
                    Tween24.tween(_box4, 1, Ease24._6_ExpoInOut).x(400).fadeIn().delay(1)
                )
            ).play();
            
            
            // ----------------------------------------------------> */
            
            
            
            /* <====================================================
            
            createBoxes(4);
            
            // skip()を使う場合
            var boxes:Array = [_box1, _box2, _box3, _box4];
            
            Tween24.serial(
                Tween24.prop(boxes).fadeOut(),
                Tween24.parallel(
                    Tween24.tween(_box1, 1, Ease24._6_ExpoInOut).x(400).fadeIn().skip(), // このトゥイーンが完了したら
                    Tween24.tween(_box2, 1, Ease24._6_ExpoInOut).x(400).fadeIn().delay(1)
                ),
                // 次のトゥイーンに移行します
                Tween24.parallel(
                    Tween24.tween(_box3, 1, Ease24._6_ExpoInOut).x(400).fadeIn(),
                    Tween24.tween(_box4, 1, Ease24._6_ExpoInOut).x(400).fadeIn().delay(1)
                )
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * IDやグループでのトゥイーンの操作
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(1);
            
            // IDを登録
            Tween24.serial(
                Tween24.prop(_box1).$x(0),
                Tween24.tween(_box1, 3).x(400)
            ).id("box1");
            
            // IDでトゥイーンを操作する
            Tween24.serial(
                Tween24.playById("box1"),
                Tween24.wait(1),
                Tween24.pauseById("box1"),
                Tween24.wait(1),
                Tween24.playById("box1"),
                Tween24.wait(1),
                Tween24.stopById("box1"),
                Tween24.wait(1),
                Tween24.playById("box1")
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            /* <====================================================
            
            // Groupを登録
            var boxes:Array = createBoxes(3);
            
            Tween24.prop(boxes).$x(0).group("boxes");
            Tween24.tween(_box1, 3).x(400).group("boxes");
            Tween24.tween(_box2, 3).x(400).group("boxes");
            Tween24.tween(_box3, 3).x(400).group("boxes");
            
            // Groupでトゥイーンを操作する
            Tween24.serial(
                Tween24.playByGroup("boxes"),
                Tween24.wait(1),
                Tween24.pauseByGroup("boxes"),
                Tween24.wait(1),
                Tween24.playByGroup("boxes"),
                Tween24.wait(1),
                Tween24.stopByGroup("boxes"),
                Tween24.wait(1),
                Tween24.playByGroup("boxes")
            ).play();
            
            // ----------------------------------------------------> */
            
            
            
            
            
            /*
             * =============================================================================
             * 
             * 
             * イベント連動トゥイーン
             * 
             * 
             * -----------------------------------------------------------------------------
             */
            
            /* <====================================================
            
            createBoxes(1);
            _box1.x = 220;
            
            // マウスイベントに合わせてトゥイーンを再生
            // EventTween24.イベント(イベントターゲット、 シリアルトゥイーン)
            
            // RollOver
            EventTween24.onRollOver(_box1,
                Tween24.parallel(
                    Tween24.prop(_box1).$x( -20),
                    Tween24.tween(_box1, 0.4, Ease24._6_ExpoOut).$x(0),
                    Tween24.tween(_box1, 0.4).bright(0.5)
                )
            );
            
            // RollOut
            EventTween24.onRollOut(_box1,
                Tween24.parallel(
                    Tween24.tween(_box1, 0.4).bright(0),
                    Tween24.tween(_box1, 0.5, Ease24._ElasticOut).scale(1)
                )
            );
            
            // Click
            EventTween24.onClick(_box1,
                Tween24.parallel(
                    Tween24.prop(_box1).scale(1).rotation(0),
                    Tween24.tween(_box1, 0.5, Ease24._ElasticOut).scale(1.5),
                    Tween24.tween(_box1, 0.8, Ease24._6_ExpoInOut).rotation(180)
                )
            );
            
            // ----------------------------------------------------> */
            
        }
        
        
        
        // ---------------------------------------------------------------------
        
        
        
        /**
         * グリッドガイドを描画
         */
        private function drawGrid():void
        {
            graphics.beginFill(0xE6E6E6);
            graphics.drawRect(0, 0, 460, 460);
            graphics.endFill();
            
            graphics.beginFill(0xDDDDDD);
            graphics.drawRect(40, 40, 380, 380);
            graphics.endFill();
            
            graphics.lineStyle(1, 0xC6C6C6);
            
            var i:int;
            for (i = 0; i < 19; i++) graphics.drawRect(20 * i + 40, 40,  20, 380);
            for (i = 0; i < 19; i++) graphics.drawRect(40, 20 * i + 40, 380, 20);
        }
        
        /**
         * ■ を描画し、配列で取得
         * @param    num    ■ の数
         * @return
         */
        private function createBoxes(num:int):Array
        {
            var boxes:Array = [];
            for (var i:int = 0; i < num; i++) {
                var box:Sprite = this["_box" + (i + 1)] = drawBox();
                box.y = 260 - (60 * num) / 2 + 60 * i - 10 * (num % 2);
                boxes.push(box);
            }
            
            Tween24.addChild(this, boxes).play();
            
            return boxes;
        }
        
        /**
         * ■ を描画
         * @return
         */
        private function drawBox():Sprite
        {
            var box:Sprite = new Sprite();
            box.x = 60;
            box.graphics.beginFill(0x336699);
            box.graphics.drawRect(-20, -20, 40, 40);
            return box;
        }
    }
}