/**
 * Copyright set0 ( http://wonderfl.net/user/set0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jpSg
 */

package  
{
	import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
	
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0x000000)]
    public class FlashTest5 extends Sprite
	{
		private var spark_list:Array = [];
		private var bar_list:Array = [];
		private var buffer:BitmapData = new BitmapData(465, 465, false, 0x000000);
		private var screen:Bitmap = new Bitmap(buffer);
		
		private var spark_shape:Shape;
		private var mouse_down:Boolean = false;
		
		private var old_x:Number;
		private var old_y:Number;
		
		public function FlashTest5()
		{
			spark_shape = new Shape()
			spark_shape.graphics.beginFill(0xffffff, 1.0);
			spark_shape.graphics.drawCircle(20, 20, 2);
			spark_shape.filters = [new GlowFilter(0xff2200, 0.8, 16, 16, 4)];
			
			addChild(screen);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function():void { mouse_down = true; old_x = stage.mouseX; old_y = stage.mouseY; } );
			stage.addEventListener(MouseEvent.MOUSE_UP, function():void{mouse_down = false});
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		public function makeBar(e:Event):void
		{
			spark_list.push(new Spark(stage.mouseX, stage.mouseY, spark_shape));
		}
		
		public function clear(e:Event):void
		{
			spark_list = [];
			buffer.colorTransform(buffer.rect, new ColorTransform(0, 0, 0, 0, 0, 0, 0, 0));
		}
		
		private function onEnterFrame(e:Event):void
		{
			if(mouse_down == true) {
				spark_list.push(new Spark(stage.mouseX, stage.mouseY, spark_shape));
				drawLines();
			}
			
			var max:int = spark_list.length;
			buffer.colorTransform(buffer.rect, new ColorTransform(0, 0, 0, 0, 0, 0, 0, 0));

			for (var i:int = 0; i < max; i++) {
				buffer.copyPixels(spark_list[i].bmp, spark_list[i].bmp.rect, new Point(spark_list[i].x, spark_list[i].y));
				if (spark_list[i].move() === false) {
					spark_list.splice(i, 1);
					i--;
					max--;
				}
			}
		}
		
		private function drawLines():void
        {
            var line_sp:Sprite = new Sprite();

           addChild(line_sp);            
           line_sp.graphics.lineStyle(2, 0xffffff, 0.8, false, "none");
           line_sp.graphics.moveTo (old_x, old_y);
           line_sp.graphics.lineTo(stage.mouseX, stage.mouseY);
            
           line_sp.filters = [new GlowFilter(0xff2200, 0.8, 16, 16, 4)];
            
           old_x = stage.mouseX;
           old_y = stage.mouseY;
            
           line_sp.addEventListener(Event.ENTER_FRAME, onEnterFrameLine);
       
        }
    
        private function onEnterFrameLine(event:Event):void
        {
            var line_sp:Sprite = event.target as Sprite;
             
            if(line_sp.alpha >= 0) {
                line_sp.alpha  -= 0.02;
            } else {
                line_sp.graphics.clear();
                line_sp.removeEventListener(Event.ENTER_FRAME, onEnterFrameLine);
                removeChild(line_sp);
                line_sp = null;
            }
        }
    }
}

import flash.display.*;
import flash.geom.*;
import flash.filters.*;

class Spark
{
    public var bmp:BitmapData;
	public var x:Number;
	public var y:Number;
	public var x0:Number;
	public var y0:Number;
	public var vx0:Number;
	public var vy0:Number;
	public var g:Number;
	public var dt:Number;
	public var t:Number;

    public function Spark(x:Number, y:Number, shape:Shape)
    {
        this.bmp = new BitmapData(40, 40, true, 0xffffff);
		this.bmp.draw(shape);
		
		this.x0 = x - 20;
		this.y0 = y - 20;
		this.vx0 = Math.random() * 15;
		this.vy0 = -60 + Math.random() * 40;
		this.g = 9.8;
		this.t = 0;
		this.dt = 0.2;
		
		this.x = this.x0;
		this.y = this.y0;
    }
	
	public function move():Boolean
	{
		this.t += this.dt;
		this.x = this.vx0 * this.t + this.x0;
		this.y = this.vy0 * this.t + 0.5 * this.g * this.t * this.t + this.y0;
		
		if (this.x >= 465 || this.y >= 465) {
			return false;
		}
		
		return true;
	}
}
