/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jp8K
 */

/*
そういえば、フォントのリストを取得できるのね。

太ったフォント、痩せたフォント、読めないフォント。
いつのまにかたくさん入ってる。

すぐに忘れちゃってごめんね。
こうやってたまには思い出すことにするよ。

Font class
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/text/Font.html
* */

package 
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.Font;
    import flash.utils.Timer;
    /**
     * ...
     * @author umhr
     */
    [SWF(backgroundColor="0xFDFAF9")]
    public class Main extends Sprite {
        private var fonts:Array;
        public function Main():void {
            //fontのリストを取得
            fonts = Font.enumerateFonts(true);
            //1秒に一度onTimerを呼び出す。
            var timer:Timer = new Timer(1000,0);
            timer.addEventListener(TimerEvent.TIMER,onTimer);
            timer.start();
        }
        private function onTimer(e:TimerEvent):void{
            while (this.numChildren > 0) {
                this.removeChildAt(0);
            }
            
            var canvasYMD:Sprite = new Sprite();
            var canvasTime:Sprite = new Sprite();
            
            //時刻を取得
            var date:Date = new Date();
            var times:Array = [String(date.getFullYear()),"/",String(date.getMonth()+1),"/",String(date.getDate()),String(date.getHours()),":",String(date.getMinutes()),".",String(date.getSeconds())];
            
            //ランダムを使って、フォントを設定。
            for (var i:int = 0; i < times.length; i++) {
                var tf:TextField = new TextField();
                tf.text = times[i];
                var fontNumber:int = Math.floor(fonts.length * Math.random());
                tf.selectable = false;
                tf.textColor = 0x42261C;
                if(i < 5){
                    tf.setTextFormat(new TextFormat(fonts[fontNumber].fontName, 21));
                    tf.autoSize = "right";
                    tf.x = canvasYMD.width;
                    canvasYMD.addChild(tf);
                }else {
                    tf.setTextFormat(new TextFormat(fonts[fontNumber].fontName, 68));
                    tf.autoSize = "right";
                    tf.x = canvasTime.width;
                    tf.y = canvasYMD.height;
                    canvasTime.addChild(tf);
                }
                
            }
            canvasYMD.x = (canvasTime.width - canvasYMD.width) / 2;
            canvasTime.addChild(canvasYMD);
            //画面真ん中に
            canvasTime.x =     (stage.stageWidth-canvasTime.width)/2;
            canvasTime.y =     (stage.stageHeight-canvasTime.height)/2;
            this.addChild(canvasTime);
        }
    }
}
