/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jnUR
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import alternativ7.engine3d.containers.ConflictContainer
    import alternativ7.engine3d.core.View
    import alternativ7.engine3d.core.Camera3D
    import alternativ7.engine3d.controllers.SimpleObjectController
    import alternativ7.engine3d.primitives.Box
    import alternativ7.engine3d.materials.FillMaterial
    
    
    /**
     * TokyoTeraco11 その3
     * マウスでぐりぐり動かしてみよう！
     *
     * @author narutohyper
     */
    public class Main extends Sprite
    {
        
        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            //ルートオブジェクト（Root Object）
            var container:ConflictContainer = new ConflictContainer();

            //ビューを作る
            var view:View = new View(stage.stageWidth, stage.stageHeight);
            addChild(view);

            //カメラを作る
            var camera:Camera3D = new Camera3D();

            //カメラとビューを関連付ける
            camera.view = view;

            //カメラを撮影する3D空間に配置する
            container.addChild(camera);

            //カメラの位置を調整
            camera.x = 0;
            camera.y = -500;
            camera.z = 0;

            //カメラをコントローラ
            var cameraController:SimpleObjectController = new SimpleObjectController(stage, camera, 10);
            cameraController.mouseSensitivity = 0
            cameraController.unbindAll()
            cameraController.lookAtXYZ(0, 0, 0)
            
            //オブジェクトを作成して3D空間（コンテナ）に追加
            var box:Box=new Box()
            container.addChild(box)


            var material:FillMaterial = new FillMaterial(0x666666, 1, 0,0x0);
            //オブジェクトにマテリアルを設定
            box.setMaterialToAllFaces(material);

            //オブジェクトコントローラを追加
            var objectController:SimpleObjectController = new SimpleObjectController(stage, box, 10);
            objectController.mouseSensitivity = 1
            objectController.unbindAll()

            addEventListener(Event.ENTER_FRAME, onEnterFrame)

            var RADIAN:Number = Math.PI/180

            function onEnterFrame(e:Event):void
            {
                //カメラコントローラの操作をコントロールオブジェクトに反映
                cameraController.update();
                
                //オブジェクトコントローラの操作をコントロールオブジェクトに反映
                objectController.update();
                
                //レンダリング
                camera.render();
            }
                    
        }
        

        
    }
    
}
