/**
 * Copyright talte ( http://wonderfl.net/user/talte )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jnSp
 */

package {
  import flash.display.Sprite
  import flash.events.Event
  import flash.events.MouseEvent
  import flash.events.SampleDataEvent
  import flash.media.Sound
  import flash.media.SoundChannel
  
  public class SoundDraw extends Sprite {
    private var sound:Sound
    private var channel:SoundChannel
    private var click:Boolean = false
    private var pos:Number = 0.5
    private var pos2:Number = 0.5
    private var c:Number = 0
    
    public function SoundDraw() {
      stage.showDefaultContextMenu = false
      stage.focus = this
      this.addEventListener(Event.ADDED_TO_STAGE, this.onInit)
    }
    
    public function onInit(event:Event):void {
      this.graphics.lineStyle(3, 0x000000)
      
      this.sound = new Sound()
      this.sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onSampling)
      
      stage.addEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown)
      stage.addEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove)
      stage.addEventListener(MouseEvent.MOUSE_UP, this.onMouseUp)
    }
    private function onSampling(event:SampleDataEvent):void {
      for (var i:int = 0; i < 8192; i++) {
        c += Math.pow(2.0, pos2 * 0.003) * 0.06
        var s:Number = Math.sin(c) * 0.6
        event.data.writeFloat(s)
        pos2 += (pos - pos2) * 0.0002
      }
    }
    private function onMouseDown(event:MouseEvent):void {
      this.click = true
      this.pos = event.localX - event.localY
      this.graphics.moveTo(event.localX, event.localY)
      this.channel = this.sound.play()
    }
    private function onMouseUp(event:MouseEvent):void {
      this.click = false
      this.channel.stop()
    }
    private function onMouseMove(event:MouseEvent):void {
      if (this.click) {
        this.graphics.lineTo(event.localX, event.localY)
        this.pos = event.localX - event.localY
      }
    }
  }
}