/**
 * Copyright xxxYukihiroxxx ( http://wonderfl.net/user/xxxYukihiroxxx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jnCS
 */

/*
 * 200909271431
 *
 * Bitmapのお勉強。
 *
 * This file is for personal, free, non-commercial use.
 * Please contact the author if you plan to use the file in other situations.
 * Feel free to donate to the cause. 
 */

package 
{
    import flash.display.*;
    import flash.display.BitmapData;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.events.*;

    import flash.utils.Timer;
    import flash.filters.*;
    import caurina.transitions.Tweener;
    
    [SWF(width = "465", height = "465", backgroundColor = "0xFFFFFF", frameRate = "120")]
	
    public class BitmapSnapShot extends MovieClip {
        public var box:Sprite;
	public var img:MovieClip;
	private var bitmapimg:BitmapData;
	private var pictures:Array = new Array();
	private var total:uint;
	private var count:uint = total;
	private var posx:uint;
	private var posy:uint;

	private  var minuteTimer:Timer;
	private var cols:Number;
	private var rows:Number;
	private var bw:Number = 440;
	private var bh:Number = 400;

	public var snapSize:Number = 40;
		
	public function BitmapSnapShot() {
		init(snapSize);
	}

	public function init(snapSize):void {
		box = new Sprite();
		box.graphics.beginFill(0x000000);
		box.graphics.drawRect(0, 0, bw, bh);
		box.graphics.endFill();
		box.x = 12;
		box.y = 12;
		addChild(box);
			
		cols = box.width / snapSize;
		rows = box.height / snapSize;
		total = cols * rows;
		count = total;
			
		bitmapimg = new BitmapData(snapSize, snapSize, false, 0x000000);

		for (var i:uint = 0; i < total; i++) {
                    img = new MovieClip();
		    addChild(img);
                    var myBitmap:Bitmap = new Bitmap(bitmapimg);
                    img.addChild(myBitmap);
                    pictures.push(img);
                    pictures[i].x = box.x + (i % cols) * snapSize;
                    pictures[i].y = box.y + Math.floor(i / rows) * snapSize;
                    pictures[i].alpha = .9;
                    bitmapimg.draw(box);
		}

		//hide the original box
		box.visible = false;
		startAnimation();
	}
		
	private function startAnimation():void {
		var calcTime:Number = total+1;
                minuteTimer = new Timer(1, calcTime);
                
                
		// designates listeners for the interval and completion events
                minuteTimer.addEventListener(TimerEvent.TIMER, Animate);
                minuteTimer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
                
                
		// starts the timer ticking
                minuteTimer.start();
	}

	private function ranDom(min:Number, max:Number):Number {
		//generates a random number between min and max
		var randomNum:Number = Math.floor(Math.random() * (max - min )) + min;
		return randomNum;
	}

	private function Animate(e:TimerEvent):void {
		
		if (count >= 0) {
			var clip:MovieClip = pictures[count];
			var rot:Number = ranDom(-200, 250);
			//tween out
			Tweener.addTween(clip,{rotation:rot,time:5,transition:"linear"});
			Tweener.addTween(clip,{ y:stage.stageHeight+80,time:1.5,transition:"easeInOutBack", transitionParams:{overshoot:0.1}});
			Tweener.addTween(clip,{alpha:0,time:1,transition:"easeInQuart"});
			Tweener.addTween(clip,{_blur_blurX:10,_blur_blurY:10,time:.2,transition:"linear"});
			//
			if(count <= 0){ 
				AllDone();
			}
			count--;			}
		}
	
		public function onTimerComplete(event:TimerEvent):void {
			minuteTimer.stop();
			removeEventListener(TimerEvent.TIMER, Animate);
			removeEventListener(TimerEvent.TIMER_COMPLETE, onTimerComplete);
		}
		
		private function AllDone():void {
			//reset everything and take fla to 2nd frame
			count = 0;
			total = 0;
			rows = 0;
			cols = 0;
			pictures = [];
			dispatchEvent(new Event("all done animation")); 
		}
	}
}