/**
 * Copyright sonali ( http://wonderfl.net/user/sonali )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jmkC
 */

// forked from bradsedito's forked from: Tilt Shift
// forked from bongiovi015's Tilt Shift
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Shader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.DropShadowFilter;
    import flash.filters.ShaderFilter;
    import flash.geom.Point;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.ByteArray;
    
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0)]
    public class TiltShift extends Sprite {
        
        //--------------------------------------
        // CLASS CONSTANTS
        //--------------------------------------
        public var loaderImage : Loader = new Loader;
        public var loaderShader : URLLoader = new URLLoader;
        private var shader:Shader;
        private var tiltShader:ShaderFilter;
        private var spSensor:Sprite;
        private var bmpd:BitmapData;
        private var pointStart:Point;
        private var pointEnd:Point;
        private var tiltFilter:ShaderFilter;
        private var bmp:Bitmap;
        private var tfDebug:TextField;
        private var format:TextFormat;
        
        public function TiltShift() {
            graphics.beginFill(0, 1);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            format = new TextFormat("Arial", 12, 0xFFFFFF);
            tfDebug = TextField(addChild(new TextField));
            tfDebug.defaultTextFormat = format;
            tfDebug.text = "Loading Image ... ";
            tfDebug.x = 5;
            tfDebug.y = 5;
            tfDebug.autoSize = "left";
            tfDebug.filters = [new DropShadowFilter(1, 45, 0, .8, 3, 3, 1, 3)];
            
            loaderImage.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
            loaderImage.load(new URLRequest("http://www.bongiovi.tw/wonderfl/champs465.jpg"), new LoaderContext(true));
        }
        
        private function imgLoaded(e:Event) : void {
            tfDebug.text = "Loading Shader ... ";
            bmp = Bitmap(loaderImage.content);
            loaderShader.addEventListener(Event.COMPLETE, shaderLoaded);
            loaderShader.dataFormat = URLLoaderDataFormat.BINARY;
            loaderShader.load(new URLRequest("http://www.bongiovi.tw/wonderfl/TiltShift.pbj"));
        }
        
        
        private function shaderLoaded(e:Event) : void {
            shader = new Shader();
            shader.byteCode = ByteArray(loaderShader.data);
            addChild(bmp);
            bmpd = bmp.bitmapData.clone();
            bmpd.applyFilter(bmpd, bmpd.rect, new Point, new BlurFilter(6, 6, 3));
            
            tiltFilter = new ShaderFilter(shader);
            spSensor = Sprite(addChild(new Sprite));
            __initControl();
            
            addChild(tfDebug);
            tfDebug.text = "Click and Drag to see the effect.";
        }
        
        
        private function __initControl() : void {
            __resetSensor();
            spSensor.addEventListener(MouseEvent.MOUSE_DOWN, __onDownHandler);
        }
        
        
        private function __onDownHandler(e:MouseEvent) : void {
            pointStart = new Point(stage.mouseX, stage.mouseY);
            addEventListener(Event.ENTER_FRAME, __loop);
            stage.addEventListener(MouseEvent.MOUSE_UP, __onUpHandler);
        }
        
        
        private function __onUpHandler(e:MouseEvent) : void {
            
            removeEventListener(Event.ENTER_FRAME, __loop);
            stage.removeEventListener(MouseEvent.MOUSE_UP, __onUpHandler);
            pointEnd = new Point(stage.mouseX, stage.mouseY);
            
            __resetSensor();
            render();
        }
        
        
        public function render() : void {
            var slope:Number;
            if(pointEnd.x != pointStart.x) {
                slope = (pointEnd.y - pointStart.y) / (pointEnd.x - pointStart.x);
            } else {
                slope = 999999;
            }

            shader.data.srcBlur.input = bmpd;
            shader.data.slope.value = [slope];
            shader.data.offset.value = [pointStart.x, pointStart.y];
            shader.data.radius.value = [200];
            bmp.filters = [tiltFilter];
        }
        
        
        private function __loop(e:Event) : void {
            spSensor.graphics.clear();
            spSensor.graphics.lineStyle(1, 0xFFFFFF, 1);
            spSensor.graphics.beginFill(0x990000, 1);
            spSensor.graphics.drawCircle(pointStart.x, pointStart.y, 5);
            spSensor.graphics.moveTo(pointStart.x, pointStart.y);
            spSensor.graphics.lineTo(stage.mouseX, stage.mouseY);
            spSensor.graphics.drawCircle(stage.mouseX, stage.mouseY, 5);
        }
        
        
        private function __resetSensor() : void {
            spSensor.graphics.clear();
            spSensor.graphics.beginFill(0x990000, 0);
            spSensor.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            spSensor.graphics.endFill();
        }
        
    }
    
}


/*

<languageVersion : 1.0;>

kernel TiltShift
<   namespace : "bongiovi.tw";
    vendor : "bongiovi";
    version : 1;
    description : "Tilt Shift Effect";
>
{
    input image4 src;       
    input image4 srcBlur;   
    output pixel4 dst;         
    
    #define PI 3.141592653589793                                             
    #define findAngle(p0, p1) acos(dot(p0, p1) / (length(p0) * length(p1) ))
    
    parameter float radius
    <
        minValue:0.0;
        maxValue:1000.0;
        defaultValue:200.0;
    >;             

                               
    parameter float slope
    <
        minValue:-25.0;
        maxValue:25.0;
        defaultValue:1.0;
    >;                                   
    
    
    parameter float2 offset
    <
        minValue:float2(0.0, 0.0);
        maxValue:float2(1000.0, 1000.0);
        defaultValue:float2(0.0, 0.0);
    >;
    

    void
    evaluatePixel()
    {                
        float2 pos = outCoord();                               
        float4 color = sampleLinear(src, pos);
        float4 blur = sampleLinear(srcBlur, pos);
        float2 target = float2(1.0, slope);   
        pos -= offset;
        float angle = findAngle(pos, target);
        float lengthToLine = length(pos) * sin(angle);
        float offsetBlur = sin(clamp(lengthToLine/radius, 0.0, 1.0)* PI * .5 );
        
        dst = mix(color, blur, offsetBlur);
    }
}

*/
