/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jmWp
 */

// forked from flashisobar's fire effect
package {
    import flash.display.Shape;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.display.Shader;
    import flash.events.Event;
    import flash.net.*;
    import net.hires.debug.Stats;
    
    [SWF(width=465,height=465,frameRate=60)]
    public class Main extends Sprite {
        private const FILTER_URL:String = "";
        private var _loader:URLLoader;
        private var _shader:Shader;
        private var fire:Fire;
        
        public function Main() {
            var bg:Shape = new Shape();
            bg.graphics.beginFill(0);
            bg.graphics.drawRect(0,0,465,465);
            bg.graphics.endFill();
            addChild(bg);

            addChild(new Stats());

            //filterLoad();
            createFire();
        }
        
        private function createFire():void {
            fire = new Fire(_shader);
            fire.fireX = 200;
            fire.fireY = 400;
            addChild(fire);
        }

        
        private function filterLoad():void{
            _loader = new URLLoader;
            _loader.addEventListener(Event.COMPLETE, onLoaded);
            _loader.dataFormat = URLLoaderDataFormat.BINARY;
            _loader.load(new URLRequest(FILTER_URL));
        }

        private function onLoaded(e:Event):void{
            _loader.removeEventListener(Event.COMPLETE, onLoaded);
            // CreateFilter
            _shader = new Shader(_loader.data);            
            createFire();
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.display.Shader;
class Fire extends Sprite {
    private static const FRAME_CREATE_PARTICLE_N:int = 1;
    private var particles:Vector.<Particle>;
    private var _fireX:Number = 0;
    private var _fireY:Number = 0;
    private var _shader:Shader;
    private var _pool:SpritePool;
    
    public function Fire(__shader:Shader) {
        //_shader = __shader;
        _pool = new SpritePool(Particle,300);
        particles = new Vector.<Particle>(false);
        this.filters = [new BlurFilter(4, 16, 1)];
        addEventListener(Event.ENTER_FRAME, update);
    }
    
    private function update(e:Event):void {
        createParticles();
        moveParticles();
    }
    
    private function createParticles():void {
        var p:Particle;
        for (var i:int = 0; i < FRAME_CREATE_PARTICLE_N; i++) {
            p = _pool.getSprite() as Particle;
            p.scaleX = p.scaleY = 1;
            p.alpha = Math.random() * 0.5 + 0.5;
            //p.alpha = Math.random() * 0.5 + 0.5;
            //p.x = _fireX + Math.random() * 40 - 20;
            //p.y = _fireY + Math.random() * 10 - 5;
            p.x = _fireX;
            p.y = _fireY;
            //p.blendMode = "add";
            //p.blendShader = _shader;
            particles.push(p);
            addChild(p);
        }
        
    }
    
    private function moveParticles():void {
        _fireX = mouseX - 50;
        _fireY = mouseY - 35;
        var p:Particle;
        for (var i:int = 0; i < particles.length; i++) {
            p = particles[i];
            p.alpha -= Math.random() * 0.02;
            
            p.x += Math.random() * 2 - 1;
            p.y -= 5;
            p.scaleX -= Math.random() * 0.05;
            p.scaleY = p.scaleX;
            
            if (p.scaleX <= 0) {
                _pool.returnSprite(p);
                removeChild(p);
                particles.splice(i, 1);
            }
        }
    }
    
    public function set fireX(value:Number):void {
        _fireX = value;
    }
    
    public function get fireY():Number {
        return _fireY;
    }
    
    public function set fireY(value:Number):void {
        _fireY = value;
    }

}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;
import frocessing.color.ColorHSV;
class Particle extends Bitmap
{
    private static const PARTICLE_NUM:int = 3;
    private var color:ColorHSV;
    public function Particle():void
    {
        color = new ColorHSV();
        var c:Sprite = new Sprite();
        var s:Shape;
        for (var i:int = 0; i < PARTICLE_NUM; i++) 
        {
            s = new Shape();
            color.h = Math.random() * 15;
            color.v = Math.random() * 0.7 + 0.3;
            s.graphics.beginFill(color.toRGB().value);
            //s.graphics.beginFill((Math.random()*0xffffff)&0xff2222);
            s.graphics.drawCircle(50, 35, Math.random() * 10 + 20);
            s.graphics.endFill();
            s.alpha = Math.random() * 0.5 + 0.5;
            s.x = Math.random() * 40 - 20;
            s.y = Math.random() * 10 - 5;
            s.blendMode = "add";
            c.addChild(s);
        }
        this.bitmapData = new BitmapData(100, 70, true, 0x0);
        this.bitmapData.draw(c);
        this.blendMode = "add";
        
    }    

}

import flash.display.DisplayObject;
class SpritePool
{
  private var pool:Array;
  private var counter:int;
  
  public function SpritePool(type:Class, len:int)
  {
    pool = new Array();
    counter = len;
    
    var i:int = len;
    while(--i > -1)
      pool[i] = new type();
  }
  
  public function getSprite():DisplayObject
  {
    if(counter > 0)
      return pool[--counter];
    else
      throw new Error("You exhausted the pool!");
  }
  
  public function returnSprite(s:DisplayObject):void
  {
    pool[counter++] = s;
  }
}