/**
 * Copyright darman ( http://wonderfl.net/user/darman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jm4L
 */

/*
[CM]-------------------------------------------
週刊 フラッシュ コレクション創刊

毎号送られてくるパーツを、
ステップ・バイ・ステップで組み立てるオモシロさ。

有名フラッシャーの作品まで再現したこだわりの完成度。
マガジンにはファイル管理の仕方や、ちょっとした小ワザなど満載。
毎号送られてくるサンプルを、忠実に再現していけばあなたもフルフラッシュサイトが作れる！

創刊号は590円
オカゴスティーニ♪
----------------------------------------------

■第2号：商品概要
創刊号では画像一枚を艶やかにローディングしたが、
第2号では一枚と言わず複数枚画像を読み込もう
読み込んだ画像達をそのままにせずスライドショーで表示させよう

〓パーツ
・読み込み状況を楽しく確実に表示する「レインボー！プログレスバー！」
・読み込み用の画像[犬・カンガルー・大宇宙」で、
　絶対に呼び出してやろうというやる気に満ち溢れる！
（/bin/assets/素材達）

〓ステップ・バイ・ステップ
・画像3枚を読み込む
1.以前と同様に、画像の読み込みにはLoaderクラスを使おう
2.プログレスバーを滑らかにアニメーションさせ、華麗にローディングさせよう
3.画像をフェードインとフェードアウトで超絶に切り替えよう


★使用上の注意
・出来る限り関数毎なり一行毎なりコメントを入れるようにして下さい。
・casalibやTweenerなどのライブラリはまだ使用しないでください。
　早い段階でライブラリを使ってしまうと確実に命を落とします。
・毎週月曜日に送付されます。お問い合わせは、その週に送付された号の内容に限ります。
　バックナンバーのお問い合わせは対応しかねる場合がございますので、ご了承ください。

オカゴスティーニでは、毎週月曜日に組み立てキットをお送りいたしますが、
解答例としてオカゴスティーニ社長自らが組み立てたフラッシュを、
その「月の最後」にお送りいたします。
ご安心ください。
（あくまで、いち解答ですので皆様は気にせず自分なりのフラッシュをお作りください。）

しかし、定期購読者様には、
月の最後あたりで何かしらのアウトプットを要求いたしますので、お気をつけください。
現段階では、今まで送られてきたキットを使って何か作っていただきたいと考えております。

以上の点を踏まえ、
「週刊 フラッシュ コレクション」をお楽しみください。


※おそらく、このシリーズは100号で完結します。 
*/ 


package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.events.Event;
    
    public class FlashTest extends Sprite {
		
		//読み込み状況を表示するスプライト
		private var _progressBar:ProgressBar;
		
		private var _pathList:Array = 
		[
			"http://assets.wonderfl.net/images/related_images/5/5e/5e1d/5e1dfe87ed012e51e2f2296e6531479273185c36"
			,"http://assets.wonderfl.net/images/related_images/7/7e/7e48/7e4849004f0246f6a5a77fee861622c9849b38e3"
			,"http://assets.wonderfl.net/images/related_images/1/1c/1c61/1c61a6fd277efcd8558837de9953deb690c71a2e"
		];
		
		
		public function FlashTest() {
			// write as3 code here..
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.align = StageAlign.TOP_LEFT;
			stage.quality = StageQuality.HIGH;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			//プログレスバーの作成
			_progressBar = new ProgressBar(stage.stageWidth - 70 , 15);
			_progressBar.x = stage.stageWidth / 2 - _progressBar.width / 2;
			_progressBar.y = stage.stageHeight / 2 - _progressBar.height / 2;
			_progressBar.scaleX = 0;
			addChild(_progressBar);
			
			_progressBar.addEventListener(Event.ENTER_FRAME, _update );
		}
		
		private function _update(e:Event):void{
			
			e.target.scaleX += 0.01;
			if(e.target.scaleX >= 1){
				e.target.removeEventListener(Event.ENTER_FRAME, _update );
			}
		}
		
		
		
		
		
		
		
    }
}


//華やかさを一層引き立てる レインボー プログレスバー
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.geom.Matrix;
import flash.display.Sprite;
class ProgressBar extends Sprite
{
	public function ProgressBar(barW:uint=100, barH:uint=15)
	{
		var fillType:String = GradientType.LINEAR;
		//各グラデーションコントロールの色
  		var colors:Array = [0xFF0000,0xFFFF00,0x00FF00,0x00FFFF,0x0000FF,0xFF00FF,0xFF0000];
  		//各グラデーションコントロールの不透明度
  		var alphas:Array = [1,1,1,1,1,1,1];
  		//0～255段階での割合
  		var ratios:Array = [0,39,91,125,168,210,255];
  		var mat:Matrix = new Matrix();
  		//Matrixを使用したグラデーションの設定　createGradientBox(横幅,縦幅,角度,Xのオフセット値,Yのオフセット値);
  		mat.createGradientBox(barW, 15,0,0,0);
  		var spreadMethod:String = SpreadMethod.PAD;
		
		graphics.beginGradientFill(fillType, colors, alphas, ratios, mat, spreadMethod);
		graphics.drawRect(0, 0, barW, barH);
		graphics.endFill();
	}
}