/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jler
 */

package {
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.utils.ByteArray;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.utils.getTimer;
   
    public class FlashTest extends Sprite {
        
        public var cardMaxNum:int = 27;
        public var boardMaxNum:int = 9;
        
        public var cardIndentX:int = 20;
        public var cardIndentY:int = 20;
        
        public var gameBoardArray:Array;
        public var cards:Array = [];
        public var setArray:Array = [];
        public var originalSetArray:Array = [];
        
        public var selectedCards:Array = [];
        
        public var setButton:PushButton;
        public var completeButton:PushButton;
        public var nextGameButton:PushButton;
        public var cheatButton:PushButton;
        
        public var gameLabel:Label;
        public var gameNum:int = 1;
        public var scoreLabel:Label;
        public var score:int = 0;
        public var timeLabel:Label;
        public var startTime:uint;
        
        public var wrongGuessLabel:Label;
        public var wrongGuess:int = 0;
        
        public var historyLabel:Label;
        public var cheatLabel:Label;
        public var versionLabel:Label;
        public var homepageLabel:Label;
        
        public var whiteColt:ColorTransform;
        public var redColt:ColorTransform;
        
        public var isGameOver:Boolean = false;

        public function FlashTest() {
            // write as3 code here..
            stage.scaleMode = "noScale";
            
            var bgSprite:Sprite = new Sprite();
            addChild(bgSprite);
            var bitmap:Bitmap = new Bitmap(new BitmapData(465, 465, false, 0xA7DECC));
            bgSprite.addChild(bitmap);
            
            drawUI();
            
            initGame();
            startTime = getTimer();          
            
            addEventListener(Event.ENTER_FRAME, onTimer);
        }
        
        private function onTimer(e:Event):void
        {
            var nowTime:uint = getTimer() - startTime;
            
            var seconds:int = nowTime / 1000;
            var minutes:int = seconds / 60;
            seconds -= minutes * 60;
            
            var secondsString:String = String(seconds);
            if (seconds < 10)
            {
                secondsString = "0" + secondsString;
            }
            
            var minutesString:String = String(minutes);
            if (minutes < 10)
            {
                minutesString = "0" + minutesString;
            }
            
            timeLabel.text = "Time " + minutesString + ":" + secondsString;
            
        }

        
        private function drawUI():void
        {
            setButton = new PushButton(this, cardIndentX, 380, "Set", onSet);
            setButton.height *= 2;
            setButton.enabled = false;
            completeButton = new PushButton(this, setButton.x + setButton.width + 20, setButton.y, "Complete!", onCompleteClaim);
            completeButton.height *= 2;
            nextGameButton = new PushButton(this, completeButton.x + completeButton.width + 20, completeButton.y, "Next Game", onNextGame);
            nextGameButton.height *= 2;
            nextGameButton.enabled = false;
            cheatButton = new PushButton(this, nextGameButton.x + nextGameButton.width + 20, nextGameButton.y, "Cheat", onCheat);
            cheatButton.width *= 0.5;
            cheatButton.height *= 2;
            gameLabel = new Label(this, setButton.x, setButton.y + setButton.height, "Game " + gameNum);
            wrongGuessLabel = new Label(this, gameLabel.x, gameLabel.y + gameLabel.height, "Wrong Guess : 0");
            scoreLabel = new Label(this, completeButton.x, completeButton.y + completeButton.height, "Score : " + score);
            timeLabel = new Label(this, scoreLabel.x, scoreLabel.y + scoreLabel.height, "Time ");
            historyLabel = new Label(this, 380, cardIndentY, "History");
            cheatLabel = new Label(this, 380, 200, "");
            versionLabel = new Label(this, cheatButton.x + cheatButton.width, scoreLabel.y, "Version 1.02 - 20160117");
            homepageLabel = new Label(this, versionLabel.x, versionLabel.y + versionLabel.height, "http://greentec.egloos.com");
            versionLabel.x -= versionLabel.width;
            homepageLabel.x -= homepageLabel.width;
            
            redColt = new ColorTransform(0, 0, 0, 1, 255, 0, 0, 0);
            whiteColt = new ColorTransform(0, 0, 0, 1, 96, 200, 180, 0);
            
            cheatLabel.transform.colorTransform = redColt;
            versionLabel.transform.colorTransform = whiteColt;
            homepageLabel.transform.colorTransform = whiteColt;
            
        }
        
        private function onCheat(e:Event):void
        {
            nextGameButton.enabled = true;
            completeButton.enabled = false;
            cheatButton.enabled = false;
            
            var cheatString:String = "Cheat";
            var i:int;

            

            score -= originalSetArray.length - setArray.length;
            drawScore();

           
            for (i = originalSetArray.length-1; i >-1; i -=1)
            {
                var str:String = originalSetArray.splice(i, 1); 
                cheatString += "\n" + String(parseInt(str.substr(0, 1)) + 1) + " " + String(parseInt(str.substr(2, 1)) + 1) + " " + String(parseInt(str.substr(4, 1)) + 1);
            }
            
            cheatLabel.text = cheatString;
            
            isGameOver = true;
        }
        
        private function onNextGame(e:Event):void
        {
            nextGameButton.enabled = false;
            completeButton.enabled = true;
            cheatButton.enabled = true;
            cheatLabel.text = "";
            gameNum += 1;
            gameLabel.text = "Game " + gameNum;
            historyLabel.text = "History";

           startTime = getTimer();

           selectedCards = [];
            
            gameBoardArray = printRandomNumber(cardMaxNum, boardMaxNum);
            
            
            var i:int;
            for (i = 0; i < gameBoardArray.length; i += 1)
            {
                cards[i].id = gameBoardArray[i];
                cards[i].draw();
                cards[i].outerLine.visible = false;
               cards[i].selected = false;
            }
            
            checkSet(gameBoardArray);
            //initGame();
            
            isGameOver = false;
            
            
        }
        
        private function onCompleteClaim(e:Event):void
        {
            if (setArray.length == 0)
            {

               score += 3;
                historyLabel.text += "\n Complete!";
                setButton.enabled = false;
                completeButton.enabled = false;
                nextGameButton.enabled = true;
                cheatButton.enabled = false;
                
                isGameOver = true;
            }
            else
            {
                score -= 1;
                
                wrongGuess += 1;
                wrongGuessLabel.text = "Wrong Guess : " + String(wrongGuess);
            }
            
            drawScore();
        }
        
        private function drawScore():void
        {
            scoreLabel.text = "Score : " + score;
        }
        
        private function onSet(e:Event):void

        {
           if (selectedCards.length != 3)
            {
                //do nothing
                
                //score -= 1;
                //drawScore();
            }
            else
            {
                selectedCards.sort();
                var selectedCardsString:String = selectedCards[0] + " " + selectedCards[1] + " " + selectedCards[2];
                var i:int, j:int;
                var cleared:Boolean = false;
                
                for (i = 0; i < setArray.length; i += 1)
                {
                    if (setArray[i] == selectedCardsString) // correct Answer! +1 point
                    {
                        score += 1;
                        drawScore();
                        var str:String = setArray.splice(i, 1);
                        historyLabel.text += "\n" + String(parseInt(str.substr(0, 1)) + 1) + " " + String(parseInt(str.substr(2, 1)) + 1) + " " + String(parseInt(str.substr(4, 1)) + 1);
                        cleared = true;
                        

                       
                        break;
                    }
                }
                
                if (cleared == false)
                {
                    score -= 1;
                    
                    wrongGuess += 1;
                    wrongGuessLabel.text = "Wrong Guess : " + String(wrongGuess);

                    drawScore();
                }
                
                for (j = selectedCards.length - 1; j > -1; j -= 1)//unselect everything
                {
                    cards[selectedCards[j]].outerLine.visible = false;
                    cards[selectedCards[j]].selected = false;
                    selectedCards.splice(j, 1);
                }
                
                setButton.enabled = false;
            }
        }
        
        private function initGame():void
        {
            initGameBoard();
        }
        
        private function initGameBoard():void
        {
            gameBoardArray = printRandomNumber(cardMaxNum, boardMaxNum);
            
            //trace(gameBoardArray); trace("HI");
            
            showGameBoard();

           
            checkSet(gameBoardArray);

           
        }
        
        private function checkSet(gameBoardArray:Array):void
        {
            var i:int, j:int, k:int;
            var setNum:int = 0;
            setArray = [];
            
            for (i = 0; i < boardMaxNum - 2; i += 1)
            {

                for (j = i + 1; j < boardMaxNum - 1; j += 1)

               {

                    for (k = j + 1; k < boardMaxNum; k += 1)

                    {

                       if ( (cards[i].backColor + cards[j].backColor + cards[k].backColor) % 3 == 0 &&
                       (cards[i].polygonColor + cards[j].polygonColor + cards[k].polygonColor) % 3 == 0 &&
                       (cards[i].polygonShape + cards[j].polygonShape + cards[k].polygonShape) % 3 == 0 )
                        {
                            setNum += 1;
                            setArray.push(String(i + " " + j + " " + k));
                        }
                        //trace(i, j, k);
                    }
               }
            }
            
            originalSetArray = clone(setArray);
            
            //trace(setArray);
        }
        
        private function printRandomNumber(n:int, k:int) : Array
        {
            var original:Array=[];
            var result:Array=[];
            var i:int;
            var randInt:int;
            var temp:Object;
            
            for (i = 0; i < n; i += 1)
            {
                original.push(i);
            }
            
            for (i = 0; i < k; i += 1)
            {
                randInt = Math.random()*(n-i) + i;
                temp = original[i];
                original[i] = original[randInt];
                original[randInt] = temp;
                result.push(original[i]);
            }
            
            return result;
        }
        
        private function showGameBoard():void //first init cards - not exist second call
        {
            var i:int;
            var card:Card;
            
            for (i = 0; i < boardMaxNum; i += 1)
            {
                card = new Card(gameBoardArray[i]);
                card.position = i;
                card.positionLabel.text = String(i+1);
                card.x = (i % 3) * 120 + cardIndentX;
                card.y = int(i / 3) * 120 + cardIndentY;
                addChild(card);
                card.addEventListener(MouseEvent.MOUSE_OVER, onCardMouseOver);
                card.addEventListener(MouseEvent.MOUSE_OUT, onCardMouseOut);
                card.addEventListener(MouseEvent.CLICK, onCardMouseClick);
                
                cards.push(card);
                
            }
        }
        
        private function onCardMouseOver(e:Event):void
        {
            e.target.alpha = 0.5;
        }
        
        private function onCardMouseOut(e:Event):void
        {
            e.target.alpha = 1;
        }
        
        private function onCardMouseClick(e:Event):void
        {
            var card:Card = Card(e.target.parent);
                
            if (card.selected == true)
            {
                card.selected = false;
                card.outerLine.visible = false;
                
                for (var i:int = 0; i < selectedCards.length; i += 1)
                {
                    if (selectedCards[i] == card.position)
                    {
                        selectedCards.splice(i, 1);
                        break;
                    }
                }
            }
            else
            {
                if (selectedCards.length < 3)
                {
                    
                    selectedCards.push(card.position);
                    card.outerLine.visible = true;
                    card.selected = true;
                }
                else
                {
                    var removeCard:int = selectedCards.splice(0, 1);
                    //var removeCard:Card = selectedCards.splice(0, 1);
                    cards[removeCard].outerLine.visible = false;
                    cards[removeCard].selected = false;
                    
                    selectedCards.push(card.position);
                    card.outerLine.visible = true;
                    card.selected = true;
                }
            }
            
            setButton.enabled = false;
            if (selectedCards.length == 3 && isGameOver == false)
            {
                setButton.enabled = true;
            }
            //trace(selectedCards);
        }
        
        public function clone(source:Object):*
        {
            var myBA:ByteArray = new ByteArray();
            myBA.writeObject(source);
            myBA.position = 0;
            return(myBA.readObject()); 
        }
    }
}

Class
{
    import com.bit101.components.Label;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.geom.Matrix;
    
    /**
     * ...
     * @author ypc
     */
    class Card extends Sprite
    {
        public var position:int;
        public var id:int;
        //public var G:Graphics;
        public var backColor:int;
        public var polygonColor:int;
        public var polygonShape:int;
        public var outerLine:Sprite;
        public var cardSprite:Sprite;
        public var selected:Boolean = false;
        public var positionLabel:Label;
        
        public function Card(id:int) 
        {
            this.id = id;
            this.mouseEnabled = false;
            //G = this.graphics;
            
            outerLine = new Sprite();
            drawOuterLine();
            addChild(outerLine);
            outerLine.visible = false;
            outerLine.mouseEnabled = false;
            
            cardSprite = new Sprite();
            draw();
            addChild(cardSprite);
            
            positionLabel = new Label(this, -15, -20, "");
            positionLabel.scaleX = positionLabel.scaleY = 2;
            
            
        }
        
        private function drawOuterLine():void
        {
            outerLine.graphics.beginGradientFill("radial", [0xff9900, 0xffff00], [1, 1], [0, 255], new Matrix(0.0691, 0.0691, -0.0691, 0.0691, 80.0000, 80.0000), "reflect", "rgb", -0.7);
            
            outerLine.graphics.drawRoundRect( -8, -8, 116, 116, 20, 20);
            
            outerLine.graphics.endFill();
        }
        
        public function draw():void
        {
            
            var G:Graphics = cardSprite.graphics;
            G.clear();
            
            this.backColor = this.id % 3;
            this.polygonColor = int(this.id / 3) % 3;
            this.polygonShape = int(this.id / 9);
            
            switch(backColor)
            {
                case 0:
                    G.beginFill(0x000000);
                    break;
                    
                case 1:
                    G.beginFill(0x808080);
                    break;
                    
                case 2:
                    G.beginFill(0xffffff);
                    break;
            }
            
            G.drawRect(0, 0, 100, 100);
            G.endFill();
            
            switch(polygonColor)
            {
                case 0:
                    G.beginFill(0xCD3170); //red
                    break;
                    
                case 1:
                    G.beginFill(0xf7bc05); //yellow
                    break;
                    
                case 2:
                    G.beginFill(0x15C7EF); //blue
                    break;
            }
            
            switch(polygonShape)
            {
                case 0:
                    G.drawRect(25, 25, 50, 50); // rectangle
                    break;
                    
                case 1:
                    G.drawCircle(50, 50, 25); // circle
                    break;
                    
                case 2:
                    G.moveTo(50, 25);
                    G.lineTo(20, 75);
                    G.lineTo(80, 75);
                    G.lineTo(50, 25);
                    break;
                    
            }

           G.endFill();
            
            //trace(this.id, backColor, polygonColor, polygonShape);
            
        }
        

   }

}
