/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jkwE
 */

package {
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.DisplayShortcuts;
	
	import com.adobe.serialization.json.JSON;
	import com.bit101.components.ColorChooser;
	import com.bit101.components.PushButton;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;

	/**
        * 曲は夢幻のオルゴール工房さんにて配布されているmp3ファイルを使用しています
        * http://www.dream-orgel.net/diary.cgi?no=120&continue=on
        */
	[SWF(width="465", height="465", backgroundColor="#000000", frameRate=30)]
	public class LineReader extends Sprite
	{
		private var _field:Sprite = new Sprite();
		private var _paintField:Sprite = new Sprite();
		private var _uiField:Sprite = new Sprite();
		private var _stopUiField:Sprite = new Sprite();
		private var _startField:Sprite = new Sprite();
		
		//Clearエフェクト
		private var _clearEffBmp:Bitmap = new Bitmap();
		private var _clearBmd:BitmapData = new BitmapData(465,465,true,0);
		
		//座標リスト
		private var _pointListList:Array = new Array();
		private var _currentListIndex:int = 0;
		private var _actionFlg:Boolean = true;
		/**
		 * params
		 */
		private var _col:Number = 0xFFFFFF;
		/**
		 * Sound parts
		 */
		private var player:Object = new Object();
		private var loader:Loader = new Loader();
		private var bA:ByteArray;
		private var spectrum:Array;
		public static var lowVal:Number=0;
		public static var middleVal:Number=0;
		public static var highVal:Number = 0;
		private var sound:Sound;
		private var _ch:SoundChannel;
		
		/**
		 * UI
		 */
		private var _colSelector:ColorSelector;
		private var _colChooser:ColorChooser;
		
		/**
		 * RECORD
		 */ 
		private var _rec:DrawRecoder = new DrawRecoder();
		private var _player:DrawPlayer = new DrawPlayer();
		
		/**
		 * TIMER
		 */
		private var _startTime:int;
		
		public function LineReader()
		{
			init();
			setupDisplay();
		}
		
		public function init():void {
			DisplayShortcuts.init();
			Security.loadPolicyFile("http://swimmingbird.heteml.jp/crossdomain.xml");
			
			_field.graphics.clear();
			_field.graphics.beginFill(0xCCCCCC,0);
			_field.graphics.drawRect(0,0,465,465);
			_field.graphics.endFill();
			
			
			//UI Starting
			var _startButton:PushButton = new PushButton(_startField,20,20,"start", startHandler);
			//UI Playing
			//			var _actionBtn:PushButton = new PushButton(_uiField,20,20,"action",actionHandler);
			//			var _noActionBtn:PushButton = new PushButton(_uiField,20,45,"noAction",noActionHandler);
			var _clearBtn:PushButton = new PushButton(_uiField,20,20,"clear",clearHandler);
			var _plotBtn:PushButton = new PushButton(_uiField,20,45,"plot",plotHandler);
			var _stopBtn:PushButton = new PushButton(_uiField,20,120,"stop",stopHandler);
			//UI Stop
			var _playDataBtn:PushButton = new PushButton(_stopUiField,20,20,"play",playDataHandler);
			var _stopDrawBtn:PushButton = new PushButton(_stopUiField,20,45,"stop",stopDrawHandler);
			
			_colSelector = new ColorSelector();
			//			_colChooser = new ColorChooser(_uiField,20,145);
			
			//Effect Init
			_clearEffBmp.bitmapData = _clearBmd;
			_clearEffBmp.visible = false;
			_clearEffBmp.alpha = 0;
			//座標リスト
			var comListString:String = '[{"childlist":[{"time":1797,"x":104,"y":166},{"time":1818,"x":103,"y":174},{"time":1838,"x":102,"y":181},{"time":1858,"x":102,"y":183},{"time":1899,"x":102,"y":184},{"time":2103,"x":101,"y":184},{"time":2123,"x":96,"y":184},{"time":2143,"x":92,"y":186},{"time":2163,"x":86,"y":188},{"time":2183,"x":82,"y":190},{"time":2203,"x":80,"y":191},{"time":2223,"x":77,"y":193},{"time":2243,"x":74,"y":196},{"time":2263,"x":71,"y":198},{"time":2283,"x":68,"y":200},{"time":2303,"x":67,"y":201},{"time":2549,"x":70,"y":202},{"time":2569,"x":76,"y":205},{"time":2589,"x":81,"y":206},{"time":2609,"x":87,"y":207},{"time":2629,"x":88,"y":208},{"time":2649,"x":89,"y":208},{"time":2669,"x":91,"y":208},{"time":2689,"x":92,"y":208},{"time":2710,"x":93,"y":208},{"time":2731,"x":94,"y":208},{"time":2772,"x":95,"y":208},{"time":2855,"x":96,"y":208},{"time":2896,"x":97,"y":208},{"time":2917,"x":98,"y":208},{"time":2957,"x":99,"y":208},{"time":3060,"x":99,"y":209},{"time":3081,"x":99,"y":214},{"time":3101,"x":99,"y":220},{"time":3122,"x":99,"y":227},{"time":3142,"x":99,"y":232},{"time":3162,"x":99,"y":236},{"time":3182,"x":100,"y":241},{"time":3202,"x":101,"y":242},{"time":3242,"x":101,"y":243},{"time":3262,"x":102,"y":244},{"time":3283,"x":102,"y":246},{"time":3303,"x":103,"y":246},{"time":3405,"x":103,"y":247},{"time":3489,"x":104,"y":246},{"time":3509,"x":108,"y":242},{"time":3529,"x":111,"y":239},{"time":3550,"x":114,"y":233},{"time":3570,"x":117,"y":229},{"time":3590,"x":118,"y":224},{"time":3610,"x":119,"y":222},{"time":3630,"x":120,"y":219},{"time":3651,"x":120,"y":218},{"time":3692,"x":121,"y":218},{"time":3734,"x":121,"y":217},{"time":3755,"x":121,"y":216},{"time":3858,"x":121,"y":215},{"time":3941,"x":121,"y":216},{"time":3961,"x":123,"y":220},{"time":3981,"x":126,"y":223},{"time":4001,"x":130,"y":229},{"time":4021,"x":134,"y":233},{"time":4041,"x":137,"y":235},{"time":4061,"x":141,"y":238},{"time":4081,"x":145,"y":240},{"time":4102,"x":148,"y":242},{"time":4122,"x":151,"y":244},{"time":4142,"x":152,"y":245},{"time":4164,"x":154,"y":245},{"time":4185,"x":155,"y":245},{"time":4225,"x":156,"y":245},{"time":4268,"x":157,"y":245},{"time":4614,"x":145,"y":206},{"time":4625,"x":144,"y":205},{"time":4637,"x":142,"y":203},{"time":4649,"x":141,"y":203},{"time":4661,"x":140,"y":202},{"time":4674,"x":139,"y":201},{"time":4688,"x":138,"y":201},{"time":4716,"x":137,"y":201},{"time":4730,"x":136,"y":200},{"time":4745,"x":135,"y":200},{"time":4776,"x":134,"y":200},{"time":5134,"x":137,"y":193},{"time":5158,"x":140,"y":188},{"time":5181,"x":143,"y":185},{"time":5204,"x":145,"y":182},{"time":5226,"x":147,"y":179},{"time":5247,"x":148,"y":178},{"time":5268,"x":148,"y":177},{"time":5289,"x":149,"y":177},{"time":5310,"x":149,"y":176},{"time":5351,"x":149,"y":175},{"time":5569,"x":147,"y":175},{"time":5587,"x":145,"y":175},{"time":5607,"x":143,"y":176},{"time":5626,"x":141,"y":177},{"time":5646,"x":138,"y":178},{"time":5666,"x":136,"y":179},{"time":5687,"x":134,"y":179},{"time":5707,"x":133,"y":180},{"time":5727,"x":132,"y":180},{"time":5748,"x":131,"y":181},{"time":5768,"x":129,"y":181},{"time":5788,"x":126,"y":182},{"time":5809,"x":124,"y":183},{"time":5832,"x":122,"y":184},{"time":5852,"x":121,"y":184},{"time":5872,"x":121,"y":185},{"time":5892,"x":120,"y":185},{"time":5914,"x":119,"y":186},{"time":5934,"x":118,"y":186},{"time":6160,"x":118,"y":182},{"time":6181,"x":117,"y":179},{"time":6201,"x":116,"y":177},{"time":6221,"x":115,"y":175},{"time":6241,"x":114,"y":174},{"time":6262,"x":113,"y":174},{"time":6283,"x":112,"y":173},{"time":6303,"x":112,"y":172},{"time":6323,"x":111,"y":172},{"time":6343,"x":109,"y":171},{"time":6384,"x":108,"y":170},{"time":6404,"x":107,"y":170},{"time":6444,"x":106,"y":169},{"time":6465,"x":105,"y":169},{"time":6485,"x":104,"y":169},{"time":6505,"x":102,"y":168},{"time":6546,"x":101,"y":168},{"time":6649,"x":102,"y":166}],"id":0,"type":"draw","col":16777010,"time":1636,"fx":105,"fy":161},{"childlist":[{"time":7805,"x":267,"y":144},{"time":7826,"x":266,"y":144},{"time":7848,"x":262,"y":148},{"time":7868,"x":258,"y":154},{"time":7888,"x":255,"y":158},{"time":7908,"x":254,"y":162},{"time":7933,"x":253,"y":165},{"time":7973,"x":252,"y":166},{"time":7993,"x":252,"y":167},{"time":8014,"x":251,"y":168},{"time":8035,"x":251,"y":169},{"time":8341,"x":249,"y":169},{"time":8368,"x":240,"y":168},{"time":8389,"x":235,"y":168},{"time":8410,"x":228,"y":170},{"time":8431,"x":223,"y":171},{"time":8452,"x":220,"y":172},{"time":8472,"x":218,"y":173},{"time":8493,"x":217,"y":173},{"time":8515,"x":215,"y":175},{"time":8535,"x":214,"y":175},{"time":8555,"x":212,"y":176},{"time":8575,"x":211,"y":176},{"time":8597,"x":210,"y":177},{"time":8904,"x":213,"y":180},{"time":8924,"x":216,"y":183},{"time":8944,"x":222,"y":186},{"time":8967,"x":227,"y":187},{"time":8988,"x":230,"y":188},{"time":9009,"x":233,"y":189},{"time":9032,"x":235,"y":190},{"time":9053,"x":236,"y":190},{"time":9073,"x":237,"y":190},{"time":9094,"x":238,"y":191},{"time":9115,"x":239,"y":191},{"time":9135,"x":241,"y":191},{"time":9175,"x":242,"y":192},{"time":9199,"x":243,"y":192},{"time":9219,"x":244,"y":192},{"time":9239,"x":245,"y":192},{"time":9281,"x":246,"y":192},{"time":9322,"x":247,"y":192},{"time":9429,"x":247,"y":193},{"time":9451,"x":241,"y":198},{"time":9472,"x":235,"y":205},{"time":9503,"x":231,"y":213},{"time":9523,"x":230,"y":220},{"time":9542,"x":229,"y":226},{"time":9563,"x":229,"y":227},{"time":9583,"x":229,"y":229},{"time":9603,"x":229,"y":231},{"time":9624,"x":229,"y":232},{"time":9644,"x":229,"y":234},{"time":9890,"x":231,"y":233},{"time":9911,"x":237,"y":230},{"time":9932,"x":241,"y":227},{"time":9953,"x":246,"y":223},{"time":9973,"x":250,"y":220},{"time":9993,"x":252,"y":217},{"time":10015,"x":257,"y":212},{"time":10035,"x":259,"y":210},{"time":10056,"x":260,"y":209},{"time":10100,"x":261,"y":209},{"time":10327,"x":263,"y":214},{"time":10348,"x":266,"y":219},{"time":10368,"x":268,"y":223},{"time":10389,"x":271,"y":227},{"time":10410,"x":275,"y":231},{"time":10433,"x":278,"y":233},{"time":10454,"x":279,"y":234},{"time":10475,"x":280,"y":236},{"time":10494,"x":281,"y":237},{"time":10515,"x":283,"y":238},{"time":10535,"x":283,"y":239},{"time":10555,"x":284,"y":239},{"time":10598,"x":285,"y":239},{"time":10681,"x":286,"y":239},{"time":10702,"x":287,"y":238},{"time":10723,"x":290,"y":232},{"time":10743,"x":291,"y":229},{"time":10767,"x":291,"y":223},{"time":10787,"x":291,"y":219},{"time":10808,"x":291,"y":217},{"time":10833,"x":290,"y":214},{"time":10853,"x":289,"y":211},{"time":10872,"x":288,"y":209},{"time":10893,"x":287,"y":206},{"time":10913,"x":287,"y":205},{"time":10934,"x":287,"y":204},{"time":10974,"x":287,"y":202},{"time":10995,"x":286,"y":201},{"time":11016,"x":286,"y":200},{"time":11036,"x":285,"y":199},{"time":11056,"x":284,"y":197},{"time":11097,"x":284,"y":196},{"time":11117,"x":283,"y":195},{"time":11179,"x":282,"y":195},{"time":11301,"x":282,"y":194},{"time":11342,"x":284,"y":193},{"time":11366,"x":292,"y":189},{"time":11387,"x":298,"y":186},{"time":11408,"x":300,"y":184},{"time":11432,"x":301,"y":184},{"time":11452,"x":302,"y":184},{"time":11472,"x":304,"y":183},{"time":11493,"x":305,"y":183},{"time":11514,"x":306,"y":182},{"time":11534,"x":307,"y":182},{"time":11554,"x":308,"y":182},{"time":11575,"x":310,"y":182},{"time":11600,"x":311,"y":182},{"time":11642,"x":312,"y":182},{"time":11766,"x":312,"y":181},{"time":11786,"x":311,"y":179},{"time":11806,"x":309,"y":176},{"time":11826,"x":307,"y":174},{"time":11847,"x":303,"y":172},{"time":11866,"x":300,"y":171},{"time":11886,"x":295,"y":169},{"time":11906,"x":292,"y":169},{"time":11927,"x":289,"y":168},{"time":11948,"x":288,"y":167},{"time":11968,"x":286,"y":167},{"time":11989,"x":282,"y":167},{"time":12009,"x":280,"y":167},{"time":12030,"x":278,"y":167},{"time":12051,"x":277,"y":167},{"time":12133,"x":276,"y":167},{"time":12340,"x":276,"y":166},{"time":12361,"x":274,"y":163},{"time":12382,"x":272,"y":158},{"time":12403,"x":271,"y":154},{"time":12423,"x":270,"y":153},{"time":12443,"x":270,"y":152},{"time":12487,"x":269,"y":151},{"time":12508,"x":268,"y":149},{"time":12532,"x":268,"y":148},{"time":12552,"x":267,"y":146},{"time":12573,"x":266,"y":145},{"time":12697,"x":265,"y":145},{"time":12718,"x":265,"y":144},{"time":12737,"x":265,"y":143}],"id":0,"type":"draw","col":16777010,"time":7700,"fx":268,"fy":144},{"childlist":[{"time":14445,"x":123,"y":309},{"time":14468,"x":127,"y":313},{"time":14489,"x":131,"y":315},{"time":14510,"x":135,"y":317},{"time":14534,"x":139,"y":318},{"time":14554,"x":143,"y":318},{"time":14574,"x":151,"y":319},{"time":14594,"x":155,"y":319},{"time":14614,"x":160,"y":320},{"time":14635,"x":167,"y":321},{"time":14655,"x":171,"y":321},{"time":14676,"x":178,"y":321},{"time":14700,"x":182,"y":321},{"time":14720,"x":185,"y":321},{"time":14740,"x":187,"y":321},{"time":14759,"x":193,"y":320},{"time":14780,"x":199,"y":318},{"time":14800,"x":203,"y":316},{"time":14821,"x":207,"y":314},{"time":14842,"x":212,"y":312},{"time":14868,"x":217,"y":310},{"time":14888,"x":221,"y":308},{"time":14907,"x":226,"y":305},{"time":14934,"x":230,"y":302},{"time":14954,"x":235,"y":299},{"time":14974,"x":238,"y":297},{"time":14994,"x":241,"y":296},{"time":15015,"x":244,"y":293},{"time":15035,"x":249,"y":290},{"time":15055,"x":250,"y":288},{"time":15076,"x":251,"y":287},{"time":15101,"x":253,"y":284},{"time":15121,"x":255,"y":282},{"time":15141,"x":257,"y":279},{"time":15161,"x":258,"y":277},{"time":15182,"x":259,"y":276},{"time":15202,"x":259,"y":275},{"time":15222,"x":260,"y":274},{"time":15261,"x":260,"y":273},{"time":15284,"x":260,"y":272},{"time":15304,"x":260,"y":271},{"time":15345,"x":260,"y":270},{"time":15601,"x":261,"y":271},{"time":15622,"x":262,"y":272},{"time":15641,"x":263,"y":273},{"time":15666,"x":264,"y":275},{"time":15687,"x":265,"y":276},{"time":15707,"x":265,"y":278},{"time":15727,"x":266,"y":279},{"time":15748,"x":267,"y":280},{"time":15769,"x":267,"y":282},{"time":15789,"x":267,"y":283},{"time":15809,"x":268,"y":284},{"time":15831,"x":268,"y":287},{"time":15850,"x":268,"y":288},{"time":15870,"x":269,"y":290},{"time":15890,"x":269,"y":291},{"time":15910,"x":270,"y":294},{"time":15934,"x":270,"y":298},{"time":15954,"x":270,"y":300},{"time":15974,"x":270,"y":303},{"time":15994,"x":270,"y":304},{"time":16015,"x":269,"y":308},{"time":16035,"x":269,"y":310},{"time":16055,"x":269,"y":311},{"time":16076,"x":268,"y":313},{"time":16099,"x":266,"y":317},{"time":16120,"x":263,"y":322},{"time":16140,"x":261,"y":325},{"time":16168,"x":257,"y":331},{"time":16188,"x":253,"y":335},{"time":16207,"x":250,"y":338},{"time":16234,"x":245,"y":343},{"time":16253,"x":242,"y":346},{"time":16274,"x":237,"y":350},{"time":16294,"x":228,"y":357},{"time":16316,"x":223,"y":361},{"time":16336,"x":220,"y":363},{"time":16357,"x":216,"y":365},{"time":16377,"x":210,"y":366},{"time":16402,"x":204,"y":368},{"time":16422,"x":199,"y":370},{"time":16441,"x":196,"y":371},{"time":16473,"x":186,"y":372},{"time":16493,"x":182,"y":373},{"time":16514,"x":177,"y":373},{"time":16536,"x":174,"y":373},{"time":16555,"x":172,"y":373},{"time":16575,"x":169,"y":372},{"time":16601,"x":162,"y":370},{"time":16621,"x":160,"y":369},{"time":16641,"x":156,"y":367},{"time":16666,"x":154,"y":366},{"time":16686,"x":151,"y":365},{"time":16706,"x":149,"y":363},{"time":16725,"x":148,"y":363},{"time":16748,"x":147,"y":362},{"time":16769,"x":145,"y":361},{"time":16789,"x":143,"y":360},{"time":16809,"x":141,"y":358},{"time":16832,"x":138,"y":355},{"time":16852,"x":137,"y":354},{"time":16871,"x":136,"y":353},{"time":16891,"x":134,"y":352},{"time":16911,"x":132,"y":350},{"time":16934,"x":131,"y":348},{"time":16954,"x":130,"y":347},{"time":16974,"x":129,"y":346},{"time":16994,"x":128,"y":344},{"time":17015,"x":127,"y":342},{"time":17035,"x":126,"y":342},{"time":17055,"x":126,"y":341},{"time":17076,"x":125,"y":340},{"time":17101,"x":124,"y":338},{"time":17122,"x":123,"y":336},{"time":17142,"x":122,"y":335},{"time":17187,"x":122,"y":333},{"time":17208,"x":121,"y":333},{"time":17234,"x":120,"y":331},{"time":17253,"x":120,"y":330},{"time":17272,"x":120,"y":329},{"time":17292,"x":119,"y":328},{"time":17312,"x":119,"y":326},{"time":17334,"x":118,"y":325},{"time":17353,"x":118,"y":324},{"time":17374,"x":118,"y":323},{"time":17402,"x":118,"y":322},{"time":17422,"x":118,"y":320},{"time":17442,"x":118,"y":319},{"time":17468,"x":118,"y":318},{"time":17508,"x":118,"y":316},{"time":17531,"x":119,"y":315},{"time":17550,"x":119,"y":314},{"time":17755,"x":121,"y":312}],"id":0,"type":"draw","col":16777010,"time":14316,"fx":121,"fy":306},{"childlist":[{"time":19677,"x":57,"y":247},{"time":19722,"x":56,"y":247},{"time":19743,"x":55,"y":248},{"time":19769,"x":55,"y":249},{"time":19789,"x":54,"y":250},{"time":19808,"x":54,"y":251},{"time":19835,"x":54,"y":252},{"time":19854,"x":54,"y":253},{"time":19874,"x":55,"y":254},{"time":19894,"x":57,"y":256},{"time":19915,"x":58,"y":257},{"time":19935,"x":59,"y":257},{"time":19956,"x":60,"y":257},{"time":19976,"x":61,"y":257},{"time":20002,"x":63,"y":257},{"time":20022,"x":64,"y":257},{"time":20042,"x":65,"y":257},{"time":20068,"x":66,"y":256},{"time":20088,"x":66,"y":254},{"time":20107,"x":67,"y":253},{"time":20127,"x":67,"y":252},{"time":20149,"x":67,"y":251},{"time":20170,"x":67,"y":250},{"time":20191,"x":67,"y":249},{"time":20211,"x":66,"y":249},{"time":20234,"x":66,"y":248},{"time":20253,"x":65,"y":248},{"time":20272,"x":63,"y":247},{"time":20292,"x":62,"y":247},{"time":20312,"x":61,"y":247},{"time":20356,"x":60,"y":247}],"id":0,"type":"draw","col":16777010,"time":19659,"fx":58,"fy":247},{"childlist":[{"time":20860,"x":83,"y":270},{"time":20903,"x":82,"y":270},{"time":20924,"x":81,"y":271},{"time":20945,"x":80,"y":273},{"time":20970,"x":80,"y":275},{"time":20990,"x":81,"y":276},{"time":21010,"x":83,"y":278},{"time":21032,"x":87,"y":278},{"time":21052,"x":90,"y":278},{"time":21072,"x":92,"y":278},{"time":21094,"x":93,"y":278},{"time":21116,"x":94,"y":277},{"time":21156,"x":95,"y":274},{"time":21177,"x":95,"y":273},{"time":21200,"x":95,"y":272},{"time":21221,"x":95,"y":271},{"time":21261,"x":94,"y":270},{"time":21282,"x":91,"y":269},{"time":21302,"x":87,"y":268},{"time":21323,"x":84,"y":268}],"id":0,"type":"draw","col":16777010,"time":20839,"fx":84,"fy":270},{"childlist":[{"time":21893,"x":119,"y":270},{"time":21915,"x":117,"y":271},{"time":21936,"x":115,"y":272},{"time":21958,"x":114,"y":273},{"time":21979,"x":114,"y":274},{"time":22002,"x":114,"y":275},{"time":22023,"x":115,"y":278},{"time":22043,"x":116,"y":279},{"time":22068,"x":117,"y":280},{"time":22089,"x":118,"y":280},{"time":22110,"x":121,"y":281},{"time":22132,"x":122,"y":281},{"time":22153,"x":124,"y":281},{"time":22174,"x":125,"y":281},{"time":22241,"x":126,"y":280},{"time":22260,"x":127,"y":280},{"time":22282,"x":127,"y":278},{"time":22303,"x":127,"y":277},{"time":22324,"x":127,"y":276},{"time":22344,"x":127,"y":274},{"time":22368,"x":124,"y":269},{"time":22388,"x":124,"y":268},{"time":22408,"x":122,"y":267},{"time":22432,"x":120,"y":267},{"time":22452,"x":117,"y":266},{"time":22471,"x":116,"y":266},{"time":22491,"x":114,"y":266},{"time":22511,"x":112,"y":266}],"id":0,"type":"draw","col":16777010,"time":21851,"fx":120,"fy":269},{"time":23408,"type":"clear"},{"childlist":[{"time":25140,"x":152,"y":242},{"time":25156,"x":151,"y":242},{"time":25189,"x":150,"y":242},{"time":25207,"x":145,"y":242},{"time":25229,"x":137,"y":242},{"time":25260,"x":128,"y":238},{"time":25290,"x":124,"y":233},{"time":25318,"x":121,"y":227},{"time":25346,"x":120,"y":219},{"time":25372,"x":120,"y":215},{"time":25396,"x":120,"y":211},{"time":25421,"x":120,"y":209},{"time":25444,"x":120,"y":208},{"time":25467,"x":122,"y":201},{"time":25489,"x":123,"y":199},{"time":25511,"x":126,"y":195},{"time":25531,"x":128,"y":191},{"time":25552,"x":132,"y":187},{"time":25573,"x":135,"y":184},{"time":25593,"x":141,"y":179},{"time":25615,"x":143,"y":177},{"time":25634,"x":147,"y":175},{"time":25654,"x":152,"y":174},{"time":25674,"x":155,"y":173},{"time":25693,"x":160,"y":173},{"time":25713,"x":162,"y":173},{"time":25731,"x":166,"y":173},{"time":25750,"x":169,"y":173},{"time":25768,"x":172,"y":175},{"time":25787,"x":176,"y":176},{"time":25806,"x":180,"y":179},{"time":25824,"x":182,"y":181},{"time":25844,"x":186,"y":184},{"time":25864,"x":188,"y":186},{"time":25885,"x":190,"y":188},{"time":25906,"x":193,"y":192},{"time":25926,"x":194,"y":195},{"time":25948,"x":195,"y":196},{"time":25969,"x":196,"y":199},{"time":25990,"x":196,"y":200},{"time":26011,"x":196,"y":202},{"time":26031,"x":196,"y":204},{"time":26053,"x":196,"y":206},{"time":26074,"x":196,"y":208},{"time":26097,"x":195,"y":211},{"time":26118,"x":192,"y":214},{"time":26139,"x":191,"y":216},{"time":26159,"x":190,"y":218},{"time":26181,"x":189,"y":219},{"time":26202,"x":185,"y":222},{"time":26222,"x":181,"y":226},{"time":26242,"x":179,"y":229},{"time":26263,"x":178,"y":229},{"time":26283,"x":176,"y":231},{"time":26304,"x":171,"y":234},{"time":26325,"x":167,"y":236},{"time":26346,"x":160,"y":239},{"time":26367,"x":157,"y":240},{"time":26387,"x":155,"y":240},{"time":26409,"x":154,"y":240},{"time":26431,"x":151,"y":240},{"time":26452,"x":150,"y":240}],"id":0,"type":"draw","col":16777010,"time":25131,"fx":153,"fy":241},{"childlist":[{"time":27224,"x":318,"y":233},{"time":27245,"x":317,"y":232},{"time":27268,"x":312,"y":232},{"time":27289,"x":308,"y":231},{"time":27310,"x":299,"y":228},{"time":27330,"x":296,"y":227},{"time":27350,"x":291,"y":224},{"time":27370,"x":287,"y":222},{"time":27391,"x":284,"y":219},{"time":27411,"x":280,"y":215},{"time":27433,"x":277,"y":209},{"time":27453,"x":275,"y":202},{"time":27475,"x":274,"y":198},{"time":27498,"x":274,"y":195},{"time":27519,"x":274,"y":191},{"time":27539,"x":274,"y":189},{"time":27560,"x":275,"y":186},{"time":27581,"x":277,"y":182},{"time":27601,"x":280,"y":178},{"time":27621,"x":283,"y":174},{"time":27643,"x":287,"y":171},{"time":27664,"x":290,"y":169},{"time":27684,"x":294,"y":167},{"time":27705,"x":296,"y":165},{"time":27725,"x":299,"y":164},{"time":27747,"x":302,"y":162},{"time":27769,"x":306,"y":160},{"time":27790,"x":310,"y":159},{"time":27811,"x":313,"y":158},{"time":27833,"x":315,"y":158},{"time":27854,"x":317,"y":158},{"time":27875,"x":320,"y":159},{"time":27900,"x":325,"y":162},{"time":27920,"x":329,"y":164},{"time":27940,"x":333,"y":168},{"time":27964,"x":337,"y":173},{"time":27985,"x":341,"y":178},{"time":28006,"x":343,"y":182},{"time":28026,"x":346,"y":186},{"time":28048,"x":346,"y":187},{"time":28070,"x":347,"y":190},{"time":28092,"x":348,"y":191},{"time":28113,"x":348,"y":193},{"time":28134,"x":348,"y":195},{"time":28154,"x":348,"y":198},{"time":28174,"x":347,"y":201},{"time":28197,"x":344,"y":206},{"time":28219,"x":341,"y":211},{"time":28240,"x":336,"y":215},{"time":28260,"x":327,"y":222},{"time":28282,"x":317,"y":229},{"time":28302,"x":314,"y":231},{"time":28322,"x":311,"y":232},{"time":28342,"x":309,"y":232}],"id":0,"type":"draw","col":16777010,"time":27171,"fx":319,"fy":233},{"childlist":[{"time":29559,"x":158,"y":281},{"time":29579,"x":164,"y":279},{"time":29601,"x":171,"y":276},{"time":29621,"x":174,"y":274},{"time":29642,"x":176,"y":271},{"time":29664,"x":177,"y":270},{"time":29685,"x":178,"y":269},{"time":30017,"x":178,"y":270},{"time":30038,"x":178,"y":271},{"time":30059,"x":178,"y":272},{"time":30080,"x":178,"y":273},{"time":30100,"x":179,"y":275},{"time":30122,"x":179,"y":277},{"time":30142,"x":181,"y":279},{"time":30166,"x":182,"y":283},{"time":30186,"x":185,"y":288},{"time":30206,"x":187,"y":291},{"time":30226,"x":189,"y":294},{"time":30248,"x":193,"y":297},{"time":30269,"x":195,"y":299},{"time":30290,"x":201,"y":303},{"time":30311,"x":203,"y":304},{"time":30333,"x":208,"y":307},{"time":30353,"x":212,"y":308},{"time":30373,"x":215,"y":309},{"time":30393,"x":218,"y":309},{"time":30415,"x":222,"y":310},{"time":30436,"x":226,"y":310},{"time":30457,"x":230,"y":310},{"time":30479,"x":238,"y":308},{"time":30499,"x":241,"y":307},{"time":30519,"x":245,"y":306},{"time":30540,"x":247,"y":306},{"time":30560,"x":248,"y":305},{"time":30582,"x":251,"y":304},{"time":30602,"x":256,"y":302},{"time":30622,"x":260,"y":300},{"time":30642,"x":262,"y":299},{"time":30664,"x":265,"y":298},{"time":30685,"x":267,"y":297},{"time":30705,"x":271,"y":294},{"time":30726,"x":275,"y":292},{"time":30748,"x":277,"y":291},{"time":30769,"x":279,"y":290},{"time":30789,"x":280,"y":289},{"time":30810,"x":283,"y":285},{"time":30830,"x":285,"y":284},{"time":30851,"x":286,"y":282},{"time":30872,"x":287,"y":281},{"time":30892,"x":288,"y":280},{"time":30914,"x":290,"y":274},{"time":30935,"x":291,"y":273},{"time":30955,"x":292,"y":271},{"time":30977,"x":292,"y":270},{"time":31018,"x":293,"y":268},{"time":31039,"x":293,"y":267},{"time":31100,"x":293,"y":265},{"time":31121,"x":294,"y":263},{"time":31378,"x":294,"y":264},{"time":31400,"x":297,"y":267},{"time":31420,"x":298,"y":268},{"time":31441,"x":299,"y":269},{"time":31465,"x":301,"y":269},{"time":31485,"x":302,"y":270},{"time":31507,"x":303,"y":270},{"time":31530,"x":305,"y":270},{"time":31550,"x":306,"y":270},{"time":31570,"x":308,"y":270},{"time":31590,"x":309,"y":270},{"time":31611,"x":310,"y":270},{"time":31633,"x":311,"y":270},{"time":31673,"x":312,"y":270},{"time":31693,"x":313,"y":270},{"time":31735,"x":314,"y":269},{"time":32119,"x":314,"y":270},{"time":32140,"x":313,"y":270},{"time":32159,"x":313,"y":272},{"time":32183,"x":312,"y":273},{"time":32203,"x":312,"y":274},{"time":32223,"x":312,"y":275},{"time":32243,"x":311,"y":276},{"time":32266,"x":311,"y":277},{"time":32286,"x":310,"y":279},{"time":32306,"x":309,"y":282},{"time":32325,"x":308,"y":284},{"time":32346,"x":307,"y":289},{"time":32367,"x":305,"y":294},{"time":32388,"x":304,"y":297},{"time":32409,"x":304,"y":300},{"time":32431,"x":303,"y":303},{"time":32450,"x":303,"y":306},{"time":32471,"x":302,"y":308},{"time":32491,"x":302,"y":311},{"time":32512,"x":302,"y":312},{"time":32532,"x":301,"y":314},{"time":32552,"x":301,"y":317},{"time":32572,"x":300,"y":323},{"time":32592,"x":300,"y":325},{"time":32613,"x":299,"y":329},{"time":32633,"x":299,"y":331},{"time":32654,"x":299,"y":334},{"time":32674,"x":299,"y":338},{"time":32697,"x":299,"y":343},{"time":32717,"x":299,"y":348},{"time":32737,"x":299,"y":351},{"time":32757,"x":299,"y":353},{"time":32778,"x":299,"y":354},{"time":32800,"x":299,"y":355},{"time":32820,"x":300,"y":358},{"time":32840,"x":300,"y":361},{"time":32864,"x":300,"y":365},{"time":32885,"x":300,"y":367},{"time":32905,"x":300,"y":368},{"time":32925,"x":300,"y":370},{"time":32946,"x":300,"y":372},{"time":32966,"x":300,"y":373},{"time":32986,"x":301,"y":375},{"time":33006,"x":301,"y":377},{"time":33026,"x":301,"y":380},{"time":33047,"x":301,"y":382},{"time":33067,"x":301,"y":383},{"time":33340,"x":301,"y":384},{"time":33361,"x":301,"y":386},{"time":33382,"x":301,"y":388},{"time":33402,"x":301,"y":389},{"time":33422,"x":301,"y":390},{"time":33443,"x":301,"y":391},{"time":33465,"x":301,"y":392},{"time":33486,"x":301,"y":393},{"time":33506,"x":302,"y":395},{"time":33526,"x":302,"y":396},{"time":33549,"x":302,"y":398},{"time":33569,"x":303,"y":401},{"time":33590,"x":304,"y":401},{"time":33610,"x":304,"y":402},{"time":33633,"x":304,"y":403},{"time":33653,"x":305,"y":406},{"time":33673,"x":306,"y":407},{"time":33701,"x":307,"y":408},{"time":33722,"x":307,"y":409},{"time":33742,"x":308,"y":410},{"time":33765,"x":309,"y":411},{"time":33869,"x":309,"y":412},{"time":33911,"x":310,"y":412},{"time":34054,"x":308,"y":412},{"time":34075,"x":303,"y":412},{"time":34101,"x":297,"y":411},{"time":34121,"x":291,"y":410},{"time":34141,"x":285,"y":409},{"time":34165,"x":281,"y":408},{"time":34186,"x":275,"y":406},{"time":34206,"x":269,"y":403},{"time":34226,"x":263,"y":401},{"time":34248,"x":260,"y":400},{"time":34268,"x":254,"y":398},{"time":34288,"x":247,"y":397},{"time":34309,"x":239,"y":397},{"time":34334,"x":232,"y":397},{"time":34354,"x":225,"y":397},{"time":34375,"x":221,"y":397},{"time":34400,"x":215,"y":397},{"time":34419,"x":212,"y":398},{"time":34439,"x":206,"y":399},{"time":34459,"x":201,"y":401},{"time":34481,"x":198,"y":402},{"time":34502,"x":194,"y":404},{"time":34522,"x":188,"y":407},{"time":34542,"x":184,"y":409},{"time":34565,"x":183,"y":410},{"time":34585,"x":181,"y":411},{"time":34606,"x":180,"y":412},{"time":34626,"x":179,"y":412},{"time":34649,"x":178,"y":413},{"time":34669,"x":177,"y":414},{"time":34690,"x":176,"y":414},{"time":34710,"x":176,"y":415},{"time":34734,"x":175,"y":415},{"time":34968,"x":175,"y":411},{"time":34988,"x":176,"y":405},{"time":35009,"x":176,"y":401},{"time":35034,"x":176,"y":393},{"time":35053,"x":176,"y":386},{"time":35072,"x":177,"y":381},{"time":35092,"x":178,"y":373},{"time":35113,"x":178,"y":366},{"time":35134,"x":178,"y":362},{"time":35154,"x":177,"y":356},{"time":35174,"x":176,"y":351},{"time":35201,"x":176,"y":347},{"time":35220,"x":174,"y":341},{"time":35240,"x":173,"y":337},{"time":35259,"x":172,"y":334},{"time":35281,"x":171,"y":330},{"time":35302,"x":171,"y":329},{"time":35322,"x":170,"y":326},{"time":35342,"x":169,"y":321},{"time":35368,"x":168,"y":316},{"time":35389,"x":166,"y":311},{"time":35409,"x":165,"y":307},{"time":35434,"x":164,"y":305},{"time":35453,"x":164,"y":304},{"time":35473,"x":163,"y":302},{"time":35492,"x":163,"y":300},{"time":35514,"x":162,"y":298},{"time":35535,"x":161,"y":297},{"time":35555,"x":161,"y":296},{"time":35576,"x":161,"y":294},{"time":35598,"x":160,"y":293},{"time":35618,"x":159,"y":292},{"time":35639,"x":159,"y":291},{"time":35659,"x":158,"y":290},{"time":35681,"x":158,"y":289},{"time":35701,"x":157,"y":288},{"time":35721,"x":156,"y":287},{"time":35741,"x":156,"y":286},{"time":35789,"x":155,"y":285},{"time":35809,"x":155,"y":284},{"time":35873,"x":154,"y":283},{"time":36168,"x":154,"y":282}],"id":0,"type":"draw","col":16777010,"time":29427,"fx":156,"fy":282}]';
			
			var comList:Array = JSON.decode(comListString);
			
			_player.setCommandList(comList);
			musicStart();
			_ch.stop();
		}
		
		private function musicStart():void {
			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars.mp3"), new SoundLoaderContext(10000, true));
//			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars_long.mp3"), new SoundLoaderContext(10000, true));
			_ch = sound.play();
			bA = new ByteArray();
			//			stage.quality = StageQuality.LOW;
			stage.fullScreenSourceRect=new Rectangle(0,0,465,465); 
			addEventListener(Event.ENTER_FRAME, updateSpectrum);
			
			//timer start
			_startTime = getTimer();
			
			/**
			 * action setup
			 */
			_field.addEventListener(MouseEvent.MOUSE_DOWN, _fieldDownHandler);
			_field.addEventListener(MouseEvent.MOUSE_UP, _fieldUpHandler);
			_field.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
			
			//Play Draw
			_player.addEventListener(DrawPlayer.DO_ROOT, _rootEventHandler);
			_player.addEventListener(DrawPlayer.DO_NODE, _nodeEventHandler);
			_player.addEventListener(DrawPlayer.DO_CLEAR, _clearEventHandler);
		}
		
		public function setupDisplay():void {
			addChild(_paintField);
			addChild(_field);
			addChild(_clearEffBmp);
			addChild(_uiField);
			addChild(_stopUiField);
			addChild(_startField);
			_uiField.addChild(_colSelector);
			_colSelector.x = 20;
			_colSelector.y = 85;
			_stopUiField.visible = true;
			_uiField.visible = false;
			_startField.visible = false;
		}
		/**
		 * mouse Action
		 */
		private function _fieldDownHandler(event:MouseEvent):void {
			addRoot();
			_col = _colSelector.currentColor;
			_field.addEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
			var currentTime:int = getTimer() - _startTime;
			var id:int=0;
			_rec.startLineRec(id,mouseX,mouseY,_colSelector.currentColor,currentTime);
		}
		private function _fieldUpHandler(event:MouseEvent):void {
			//今書いたものにベクトル情報追加
			_field.removeEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
		}
		private function _fieldMoveHandler(event:MouseEvent):void {
			addNode(_field.mouseX, _field.mouseY);
			//rec
			var currentTime:int = getTimer() - _startTime;
			_rec.addPoint(_field.mouseX, _field.mouseY, currentTime);
		}
		/**
		 * play Action
		 */
		private function _rootEventHandler(event:Event):void {
			addRoot();
			_col = _player.cur_Col;
		}
		private function _nodeEventHandler(event:Event):void {
			addNode(_player.cur_x, _player.cur_y);	
		}
		private function _clearEventHandler(event:Event):void {
			clear();
		}
		/**
		 * node Action
		 */
		private function addRoot():void {
			trace("adRoot");
			_currentListIndex = _pointListList.length;
			_pointListList.push(new Array());
		}
		private function addNode(px:Number, py:Number):void {
			trace("addNode");
			var _list:Array = _pointListList[_currentListIndex];
			_list.push(new LinePoint(px, py));
			var i:int = _list.length-1;
			_list[i].color = _col;
			if(_list[i-1]) {
				var _pt:LinePoint = _list[i];
				var _dx:Number = _list[i].x - _list[i-1].x;
				var _dy:Number = _list[i].y - _list[i-1].y;
				var _distance:Number = Math.sqrt(_dx*_dx+_dy*_dy);
				_pt.vx = _list[i].x - _list[i-1].x;
				_pt.vy = _list[i].y - _list[i-1].y;
				//				_pt.vx = _dx/_distance;
				//				_pt.vy = _dy/_distance;
				_pt.genRotation();
			}
		}
		private function _enterFrameHandler(event:Event):void {
			var i:int;
			var len:int = _pointListList.length;
			_paintField.graphics.clear();
			_paintField.graphics.lineStyle(1,0xFFFFFF);
			var _list:Array;
			var j:int;
			var _listlen:int;
			var nx:Number;
			var ny:Number;
			var dist:Number;
			if(_actionFlg) {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.lineStyle(1,_list[0].color);
						_paintField.graphics.moveTo(_list[0].x, _list[0].y);
						//スペクトラムずらす
						for(j=_listlen-1;j>0;j--) {
							_list[j].spectrum = _list[j-1].spectrum;
						}
						_list[0].spectrum = spectrum[10];
						for(j=0;j<_listlen;j++) {
							//							_paintField.graphics.moveTo(_list[j].x, _list[j].y);
							if(_list[j].r){
								nx = -(_list[j].vy);
								ny = _list[j].vx;
								dist = Math.sqrt(nx*nx+ny*ny);
								//							    _list[j].spectrum = spectrum[j];//スペクトラム直でまっぴんぐ
								_paintField.graphics.lineTo(_list[j].x+nx*_list[j].spectrum*7, _list[j].y+ny*_list[j].spectrum*7);
								//							    _paintField.graphics.lineTo(_list[j].x+_list[j].spectrum*2*nx/dist, _list[j].y+40*_list[j].spectrum*2*ny/dist);
							}
						}
					}
				}
			} else {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.moveTo(_list[0].x, _list[0].y); 
						for(j=0;j<_listlen;j++) {
							_paintField.graphics.lineTo(_list[j].x, _list[j].y);
						}
					}
				}
			}
		}
		
		private function updateSpectrum(e:Event):void {
			SoundMixer.computeSpectrum(bA,false,0);
			spectrum = [];
			var i:int;
			for(i=0; i<256; i++){
				spectrum[i] = bA.readFloat();
			}
			for(i=256; i<512; i++){
				spectrum[i] = bA.readFloat();
			}
			bA.position=0;
			lowVal = spectrum[0];
			middleVal = spectrum[1];
			highVal = spectrum[2];
		} 
		
		/**
		 * ui Action
		 */
		private function startHandler(event:MouseEvent):void {
			_startField.visible = false;
			_uiField.visible = true;
			musicStart();
		}
		private function actionHandler(event:MouseEvent):void {
			_actionFlg = true;
		}
		private function noActionHandler(event:MouseEvent):void {
			_actionFlg = false;
		}
		private function clearHandler(event:MouseEvent):void {
			_rec.addClear(getTimer()-_startTime)
			clear();
		}
		private function plotHandler(event:MouseEvent):void {
			_rec.outPut();
		}
		private function stopHandler(event:MouseEvent):void {
			_ch.stop();
			clear();
			_player.setCommandList(_rec.commandList);
			Tweener.addTween(_uiField, {_autoAlpha:0, time:0.5, transition:Equations.easeOutQuint});
			Tweener.addTween(_stopUiField, {_autoAlpha:1, time:0.5, transition:Equations.easeOutQuint});
		}
		private function playDataHandler(event:MouseEvent):void {
			_ch = sound.play(0);
			_player.playStart();
		}
		private function stopDrawHandler(event:MouseEvent):void {
			clear();
			_currentListIndex = 0;
			_ch.stop();
			_player.playStop();
		}
		public var clearCnt:Number = 0;
		private function clear():void {
			_clearBmd.fillRect(new Rectangle(0,0,465,465),0);
			_clearBmd.draw(_paintField);
			_clearEffBmp.visible = true;
			_clearEffBmp.alpha = 1;
			_clearEffBmp.scaleX = _clearEffBmp.scaleY = 1;
			Tweener.addTween(_clearEffBmp, {/*scaleX:2, scaleY:2, */_autoAlpha:0, time:1, transition:Equations.easeOutQuint});
			clearComp();
			//			var i:int;
			//			var len:int = _pointListList.length;
			//			var _list:Array;
			//			var _listlen:int;
			//			var j:int;
			//			var nx:int, ny:int;
			//			for(i=0; i<len; i++) {
			//				_list = _pointListList[i];
			//				_listlen = _list.length;
			//				for(j=0;j<_listlen;j++) {
			//					_list[j].endAction();
			//				}
			//			}
			//			Tweener.addTween(this, {clearCnt:10, time:0.8, transition:Equations.easeOutQuint, onComplete:clearComp});
		}
		private function clearComp():void {
			var i:int;
			var len:int = _pointListList.length;
			var _list:Array;
			var _listlen:int;
			var j:int;
			var nx:int, ny:int;
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_listlen = _list.length;
				for(j=0;j<_listlen;j++) {
					_list[j] = null;
				}
			}
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_list.length = 0;
				_list = null;
			}
			_pointListList.length = 0;
			_pointListList = new Array();
		}
	}
}
import caurina.transitions.Equations;
import caurina.transitions.Tweener;

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.external.ExternalInterface;
import flash.geom.Point;
import flash.utils.Timer;
import flash.utils.getTimer;

import org.osmf.events.TimeEvent;



class LinePoint extends Point {
	public var vx:Number, vy:Number, r:Number;
	public var spectrum:Number = 0;
	public var color:Number;
	public function LinePoint(x:Number=0, y:Number=0) {
		super(x,y);
	}
	public function genRotation():void {
		r = Math.atan2(vy, vx);
	}
	public function endAction():void {
		var _targetSp:Number = spectrum * 20;
		Tweener.addTween(this, {spectrum:_targetSp, time:0.5, transition:Equations.easeOutQuint});
	}
}

class ColorSelector extends Sprite {
	public var colorList:Array = new Array();
	public var currentColor:Number = 0xFFFF32;
	private var _colTotal:int = 5;
	private var _selectedColor:Sprite = new Sprite();
	
	public function ColorSelector() {
		init();
		setupDisplay();
	}
	public function init():void {
		var i:int;
		for(i=0; i<_colTotal; i++) {
			var block:Sprite = new Sprite();
			//			block.name = String(0xFF0000*Math.random());
			block.addEventListener(MouseEvent.CLICK, selectedHandler);
			colorList.push(block);
		}
		colorList[0].name = String(0xFFFF32);
		colorList[1].name = String(0xFFFF99);
		        colorList[2].name = String(0xFFFFCD);
		        colorList[3].name = String(0xFFCC32);
		        colorList[4].name = String(0xFFCC00);
		for(i=0; i<_colTotal; i++) {
			colorList[i].graphics.clear();
			colorList[i].graphics.beginFill(Number(colorList[i].name));
			colorList[i].graphics.drawRect(0,0,10,10);
			colorList[i].graphics.endFill();
		}
		
		currentColor = Number(colorList[0].name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
		
	}
	public function setupDisplay():void {
		addChild(_selectedColor);
		for(var i:int=0; i<_colTotal; i++) {
			addChild(colorList[i]);
			colorList[i].x = i*(colorList[i].width+1);
			colorList[i].y = 20;
		}
	}
	private function selectedHandler(event:MouseEvent):void {
		_selectedColor.graphics.clear();
		currentColor = Number(event.target.name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
	}
}

class DrawPlayer extends Sprite {
	
	public static const DO_ROOT:String = "DoRoot";
	public static const DO_NODE:String = "DoNode";
	public static const DO_CLEAR:String = "DoClear";
	private var _commandList:Array;
	private var _timer:Timer = new Timer(1);
	private var _rootIndex:int = 0;
	private var _nodeIndex:int = 0;
	private var _counter:int = 0;
	private var _watchTarget:int = 0; //0:親, 1:子
	
	//現在の命令
	public var cur_Command:int = 0; //0:親, 1:子
	public var cur_Col:Number;
	public var cur_x:Number;
	public var cur_y:Number;
	
	//timer
	private var _startTime:Number;
	
	public function DrawPlayer() {
		super();
	}
	
	public function setCommandList(list:Array):void {
		_commandList = list;
	}
	
	public function playStart():void {
		_counter = 0;
		_rootIndex = 0;
		_nodeIndex = 0;
		_watchTarget = 0;
		_startTime = getTimer();
		addEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	public function playStop():void {
		removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	
	private function _commandCheckHandler(event:Event):void {
		_counter = getTimer()-_startTime;
		//まだ終わってなかったら終わる
		if(_rootIndex == _commandList.length) {
			if(hasEventListener(Event.ENTER_FRAME))removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
			return;
		}
		if(_watchTarget==0) {
			if(_commandList[_rootIndex].time<=_counter) {
				switch(_commandList[_rootIndex].type) {
					case "clear":
						_watchTarget = 0;
						dispatchEvent(new Event(DO_CLEAR));
						_rootIndex++;
						break;
					case "draw":
						cur_Col = _commandList[_rootIndex].col;
						cur_x = _commandList[_rootIndex].fx;
						cur_y = _commandList[_rootIndex].fy;
						dispatchEvent(new Event(DO_ROOT));
						_watchTarget = 1;
						break;
				}
			}
		} else {
			var obj:Object = _commandList[_rootIndex][_nodeIndex];
			//マウス動かなかった時は親にそのまま向ける
			if(!_commandList[_rootIndex].childlist[_nodeIndex]){
				_rootIndex++;
				_nodeIndex=0;
				_watchTarget=0;
				return;
			}
			if(_commandList[_rootIndex].childlist[_nodeIndex].time<=_counter) {
				cur_x = _commandList[_rootIndex].childlist[_nodeIndex].x;
				cur_y = _commandList[_rootIndex].childlist[_nodeIndex].y;
				dispatchEvent(new Event(DO_NODE));
				_nodeIndex++;
				//最後尾到達で親監視に切り替え
				if(_nodeIndex==_commandList[_rootIndex].length-1) {
					//親も最後尾なら終了
					if(_rootIndex==_commandList.length-1) {
						_timer.removeEventListener(TimerEvent.TIMER, _commandCheckHandler);
						_timer.stop();
						return;
					} else {
						_watchTarget = 0;
						_rootIndex++;
					}
				}
			}
			
		}
	}
	
	private function _commandCheck():void{
		
	}
	
}

class DrawRecoder extends Sprite {
	private var _commandList:Array = new Array();
	public function get commandList():Array {
		return _commandList;
	}
	public function DrawRecoder() {
		
	}
	
	public function startLineRec(_id:int,_mx:Number,_my:Number,_col:Number, _time:Number):void {
		_commandList.push({type:"draw", id:_id,fx:_mx, fy:_my, col:_col, time:_time, childlist:new Array()});
	}
	public function addPoint(_mx:Number, _my:Number, _time:Number):void {
		var _currentList:Array = _commandList[_commandList.length-1].childlist;
		_currentList.push({x:_mx, y:_my, time:_time});
	}
	public function addClear(_time:Number):void {
		_commandList.push({type:"clear", time:_time});
	}
	public function endLineRec():void {
		
	}
	
	public function outPut():void {
		var i:int;
		var j:int;
	}
}