/**
 * Copyright Matt_Wakeling ( http://wonderfl.net/user/Matt_Wakeling )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jkXI
 */

package
{
    // Import External Classes
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.geom.ColorTransform;
    import flash.net.URLRequest;
    import flash.system.ApplicationDomain;
    import flash.system.LoaderContext;
    import flash.system.Security;


    import net.hires.debug.Stats;
    
    // Reconfigure Stage Properties
    [SWF(width='465',height='465',backgroundColor='#000000',frameRate='60')]
    
    /**
     * Name           : Main
     * Coded By       : Matt Wakeling
     * Date           : 2nd May 2012
     * Description    : Main Class for the Application.
     *                  Simple Cube with Lighting Effect - Experiment In 3D.
     *
     * @author Matt Wakeling
     */
    public class Main extends Sprite
    {
        private var $cube:Sprite             = new Sprite;
        private var $faces:Array             = new Array(6);
        private var $maximum_lighting:uint   = 255; // -255 to 255 = 510
        
        private var $LoadedImages:uint       = 6;
                
        private var $arrURL:Array            = ["http://assets.wonderfl.net/images/related_images/5/57/5725/57252ca6ed0712f91f22ffda7ea5b2d7a40a07c0m",
                                                "http://assets.wonderfl.net/images/related_images/2/21/2115/2115b23cfc069a901e8cb5737e5fb806a01dc242m",
                                                "http://assets.wonderfl.net/images/related_images/8/82/82b1/82b15080a0f7e11637612accb5bd381589d66808m",
                                                "http://assets.wonderfl.net/images/related_images/c/cf/cf18/cf18bda79f50d3c4210596a855c01c676be7573bm",
                                                "http://assets.wonderfl.net/images/related_images/2/21/2161/216188386c9c9d7a6ba69f63dd8dca18ebccac4dm",
                                                "http://assets.wonderfl.net/images/related_images/0/00/00f2/00f22a97d1e2b1c1fc6253293f17dce8ed76fbb7m"];
                                                
        private var $arrImages:Array        = [];
        
        private var $ldrQueue:Array         = [];
            
            
        
        // Main Constructor
        public function Main()
        {
            // Constructor Code
            super();
            InitialiseMain();
        }
        
        // InitialiseMain Method
        private function InitialiseMain():void
        {
            if (stage)
                this.InitialiseStage();
            else
                addEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
        }
        
        private function InitialiseStage(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            // Black Screen for Wonderfl Capture
            this.graphics.beginFill(0x000000, 1);
            this.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();
            
            addChild(new Stats);
            
            loadQueue();
        }
        
        // loadQueue Method    
        private function loadQueue():void
        {
            for (var i:uint = 0; i < $LoadedImages; i++)
            {
                var $ImageLoader:Loader = new Loader;
                $ImageLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoaded);
                $ldrQueue.push({Loader: $ImageLoader, URLRequest: $arrURL[i] });
            }

            loadNext();
        }

        // loadNext Method
        private function loadNext():void
        {
            if ($ldrQueue.length) {
                var $obj:Object = $ldrQueue.shift();
                var $URL:String = $obj.URLRequest;
                var $ImageLoader:Loader = $obj.Loader;
                
                $ImageLoader.load(new URLRequest ($URL), new LoaderContext(true));
            }
        }

        // initCube Method
        private function imageLoaded(evtImageLoaded:Event):void
        {
            $arrImages.push(evtImageLoaded.target.content);
                        
            $LoadedImages--;
            $LoadedImages ? loadNext() : initCube((stage.stageWidth * 0.5), (stage.stageHeight * 0.5));;
        }
    
        // initCube Method
        private function initCube($x:uint, $y:uint):void
        {
            var $shpRightFace:Sprite = rectFace($arrImages[1]);
            $shpRightFace.rotationY = 90;
            $shpRightFace.x += 100;
            $cube.addChild($shpRightFace);
            
            var $shpLeftFace:Sprite = rectFace($arrImages[4]);
            $shpLeftFace.rotationY = 90;
            $shpLeftFace.x -= 100;
            $cube.addChild($shpLeftFace);
            
            var $shpBottomFace:Sprite = rectFace($arrImages[2]);
            $shpBottomFace.rotationX = 90;
            $shpBottomFace.y += 100;
            $cube.addChild($shpBottomFace);
            
            var $shpTopFace:Sprite = rectFace($arrImages[3]);
            $shpTopFace.rotationX = 90;
            $shpTopFace.y -= 100;
            $cube.addChild($shpTopFace);
            
            var $shpBackFace:Sprite = rectFace($arrImages[0]);
            $shpBackFace.z += 100;
            $cube.addChild($shpBackFace);
            
            var $shpFrontFace:Sprite = rectFace($arrImages[5]);
            $shpFrontFace.z -= 100;
            $cube.addChild($shpFrontFace);
            
            $cube.x = $x;
            $cube.y = $y;
            $cube.z = 10000;
            
            addChild($cube);
            
            $faces[0] = ["RIGHT", $shpRightFace, null];
            $faces[1] = ["LEFT", $shpLeftFace, null];
            $faces[2] = ["BOTTOM", $shpBottomFace, null];
            $faces[3] = ["TOP", $shpTopFace, null];
            $faces[4] = ["BACK", $shpBackFace, null];
            $faces[5] = ["FRONT", $shpFrontFace, null];
            
            this.addEventListener(Event.ENTER_FRAME, FrameEvent);
        }
        
        // FrameEvent Method
        private function FrameEvent(e:Event):void
        {
            rotateCube();
        }
        
        // rotateCube Method
        private function rotateCube():void
        {
            $cube.rotationX = ($cube.rotationX + 0.75);
            $cube.rotationY = ($cube.rotationY + 1);
            
            if ($cube.z != 0) $cube.z = ($cube.z - 100);
            
            for (var $row:int = 0; $row < $faces.length; $row++)
            {
                $faces[$row][2] = $faces[$row][1].transform.getRelativeMatrix3D(root).position.z;
                
                if ($cube.z == 0)
                {
                    var $Shade:uint = (((( -$faces[$row][2] + 100) / 200 * 100) / 100) * $maximum_lighting);
                
                    $faces[$row][1].transform.colorTransform = new ColorTransform( -1, -1, -1, 1, ($Shade * 0.5), ($Shade * 0.5), ($Shade * 0.5), 0);
                }
            }
            
            $faces.sortOn("2", Array.NUMERIC | Array.DESCENDING);
            
            for ($row = 0; $row < $faces.length; $row++)
            {
                $cube.setChildIndex($faces[$row][1], $row);
            }
        }
        
        // rectFace Method
        private function rectFace($bmpImage:Bitmap):Sprite
        {
            var $shpFace:Sprite = new Sprite;
            var $BitmapData:BitmapData = $bmpImage.bitmapData.clone();            
            var $bmpFace:Bitmap = new Bitmap($BitmapData, "auto", true);
            
            $bmpFace.x = -100;
            $bmpFace.y = -100;
            $bmpFace.width = 200;
            $bmpFace.height = 200;
            $shpFace.addChild($bmpFace);
            
            $shpFace.transform.colorTransform = new ColorTransform( -1, -1, -1, 1, ($maximum_lighting * 0.5), ($maximum_lighting * 0.5), ($maximum_lighting * 0.5), 0);
        
            return ($shpFace);
        }
    
        
    }
}