/**
 * Copyright talrnu ( http://wonderfl.net/user/talrnu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jkMq
 */

/*
 *    Testing speed at which variables can be passed and converted
 *    Uses testing code from http://wonderfl.net/c/AngK
 *
 *    Procedure: measure time elapsed while assigning a function's argument value to a class property.
 *    Parameters: data types of the original data, argument, and class property
 *    Results: passing data to class properties of the same type through untyped function arguments is
 *        (marginally) faster than using function arguments of the same type
 *
 *    Procedure: measure time elapsed while converting data between types
 *    Parameters: data types of the original data, argument, and class property
 *    Results: explicit conversion from an untyped function argument occurred in the shortest time
 *
 *    Example output on test developer's machine:
 *
 *    [ Passing Number as Number ] --> 119 ms
 *    [ Passing Number as Untyped ] --> 116 ms
 *    [ Passing Number in Object ] --> 137 ms
 *    
 *    [ Passing String as String ] --> 123 ms
 *    [ Passing String as Untyped ] --> 122 ms
 *    [ Passing String in Object ] --> 144 ms
 *    
 *    [ Passing Number to String through untyped ] --> 149 ms
 *    [ Explicit conversion of untyped Number to String ] --> 147 ms
 *    [ Explicit conversion of Number to String ] --> 155 ms
 *    
 *    [ Passing Number to String through untyped ] --> 166 ms
 *    [ Explicit conversion of untyped String to Number ] --> 163 ms
 *    [ Explicit conversion of String to Number ] --> 165 ms
 */

package {

    import flash.display.*;
    import flash.text.*;
    import flash.utils.*;
    
    public class Main extends Sprite {
        
        private const reps:Number = 1000000;
        private var debugText:TextField;
        private var timeElapsed:uint;
        
        private var testNumber:Number = 5;
        private var testString:String = "5";
        private var numberReceptacle:Number;
        private var stringReceptacle:String;
        
        public function Main():void {
            
            initDebugger();
            
            //Test Numbers:
            _measure("Passing Number as Number", function (testVal:Number):void
            {
                numberReceptacle = testVal;
            }, reps, testNumber);
            _measure("Passing Number as Untyped", function (testVal:*):void
            {
                numberReceptacle = testVal;
            }, reps, testNumber);
            _measure("Passing Number in Object", function (testObj:Object):void
            {
                numberReceptacle = testObj.testVal;
            }, reps, {testVal:testNumber});
            
            _debug(" ");
            
            //Test Strings:
            _measure("Passing String as String", function (testVal:String):void
            {
                stringReceptacle = testVal;
            }, reps, testString);
            _measure("Passing String as Untyped", function (testVal:*):void
            {
                stringReceptacle = testVal;
            }, reps, testString);
            _measure("Passing String in Object", function (testObj:Object):void
            {
                stringReceptacle = testObj.testVal;
            }, reps, {testVal:testString});
            
            _debug(" ");
            
            //Test type conversions from Number:
            _measure("Passing Number to String through untyped", function (testVal:*):void
            {
                stringReceptacle = testVal;
            }, reps, testNumber);
            _measure("Explicit conversion of untyped Number to String", function (testVal:*):void
            {
                stringReceptacle = String(testVal);
            }, reps, testNumber);
            _measure("Explicit conversion of Number to String", function (testVal:Number):void
            {
                stringReceptacle = String(testVal);
            }, reps, testNumber);
            
            _debug(" ");
            
            //Test type conversions from String:
            _measure("Passing Number to String through untyped", function (testVal:*):void
            {
                numberReceptacle = testVal;
            }, reps, testString);
            _measure("Explicit conversion of untyped String to Number", function (testVal:*):void
            {
                numberReceptacle = Number(testVal);
            }, reps, testString);
            _measure("Explicit conversion of String to Number", function (testVal:String):void
            {
                numberReceptacle = Number(testVal);
            }, reps, testString);
            
       }
        
        private function _measure(
            title:String, func:Function, numTimes:uint, ...params):void
        {
            timeElapsed = getTimer();
            
            for (var i:int = 0; i < numTimes; i++) {
                func.apply(null, params);
            }
            
            timeElapsed = getTimer() - timeElapsed;
            
            _debug("[ " + title + " ] --> " + timeElapsed + " ms");
        }
        
        private function _debug(log:String):void
        {
            debugText.appendText(log + "\n");
        }
        
        private function initDebugger():void {
            
            debugText = new TextField();
            debugText.width = stage.stageWidth;
            debugText.height = stage.stageHeight;
            
            var format:TextFormat = debugText.defaultTextFormat;
            format.font = "_sans";
            debugText.defaultTextFormat = format;
            
            addChild(debugText);
            
        }
       
        
    }

}