/**
 * Copyright nicoptere ( http://wonderfl.net/user/nicoptere )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jkE2
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.utils.getTimer;
	
	/**
	 * @author Nicolas Barradeau
	 * http://en.nicoptere.net
	 */
	public class PRNGTest extends Sprite 
	{
		private var bd:BitmapData;
		
		public function PRNGTest() 
		{
			
			var scale:Number = 10;
			bd = new BitmapData( stage.stageWidth / scale, stage.stageHeight / scale, false, 0 );
			
			var bmp:Bitmap = new Bitmap( bd );
			bmp.scaleX = bmp.scaleY = scale;
			addChild( bmp );
			
			addEventListener( Event.ENTER_FRAME, oef );
			
		}
		
		private function oef( event:Event = null ):void 
		{
			
			PRNG.seed = getTimer();
			
			bd.lock();
			
			for (var i:int = 0; i < bd.width; i++) 
			{
				for (var j:int = 0; j < bd.height; j++) 
				{
					bd.setPixel( i, j, PRNG.random() * 0xFFFFFF );
				}
			}
			
			bd.unlock();
			
		}
	}
}

/***********************************************************

PRNG CLASS

***********************************************************/
internal class PRNG
{
	
	static private var a:uint = 16807;			/* multiplier */
	static private var m:uint = 0x7FFFFFFF;		/* 2**31 - 1 */
	static private var q:uint = 127773; 		/* m div a */
	static private var r:uint = 2836;			/* m mod a */
	static private var randomnum:uint = 1;
	static private var div:Number = 1 / m;
	
	static private function nextlongrand( seed:uint ):uint
	{
		var lo:uint, hi:uint;
		
		lo = a * (seed & 0xFFFF);
		hi = a * (seed >> 16);
		lo += (hi & 0x7FFF) << 16;
		if (lo > m)
		{
			lo &= m;
			++lo;
		}
		lo += hi >> 15;
		if (lo > m)
		{
			lo &= m;
			++lo;
		}
		return lo;
		
	}
	
	static public function random():Number /* return next random number */
	{
		
		randomnum = nextlongrand(randomnum);
		return randomnum * div;
		
	}
	
	static public function set seed( value:uint ):void
	{
		
		randomnum = ( value <= 0 ) ? 1 : value;
		
	}
	
}