/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jjgG
 */

package {
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;

    [SWF(width = '465', height = '465', frameRate = '64')]
    public class Hilbert extends Sprite
    {
        private var hilbert : HilbertSpace;
        private var bmd0 : BitmapData = new BitmapData(256, 256, false, 0x989690);
        private var bmd1 : BitmapData = new BitmapData(256, 256, false, 0x383630);
        private var fcnt : int;
        private var morph : int;

        public function Hilbert()
        {
            hilbert = new HilbertSpace(bmd0, bmd1);
            hilbert.scaleX = hilbert.scaleY = 2;
            hilbert.opaqueBackground = 0x0;
            addChild(hilbert);

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void
        {
            fcnt++;

            if ((fcnt & 63) == 1)
            {
                morph++;

                hilbert.draw(1 + (morph & 7));
            }
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;


class HilbertSpace extends Bitmap {
    private var h : Number;
    private var w : int;
    private var px : int;
    private var py : int;
    private var bm : BitmapData;
    private var bmd0 : BitmapData;
    private var bmd1 : BitmapData;

    public function HilbertSpace(bmd0 : BitmapData, bmd1 : BitmapData) {
        this.bmd0 = bmd0;
        this.bmd1 = bmd1;

        super(null);
    }

    public function draw(t : int) : void {
        /* reset */

        bm = bmd1.clone();
        w = bmd0.width;

        px = 0;
        py = 0;

        h = 1;

        var i : int = 2;
        while (i++ <= t) {
            h /= 2 + h;
        }

        h *= w;

        /* process */

        rightUpLeft(t);

        /* display */

        bitmapData = bm.clone();
        bm.dispose();
    }

    private function rightUpLeft(i : int) : void {
        if (i != 0) upRightDown(i - 1);
        scanRelative(h, 0);
        if (i != 0) rightUpLeft(i - 1);
        scanRelative(0, h);
        if (i != 0) rightUpLeft(i - 1);
        scanRelative(-h, 0);
        if (i != 0) downLeftUp(i - 1);
    }

    private function downLeftUp(i : int) : void {
        if (i != 0) leftDownRight(i - 1);
        scanRelative(0, -h);
        if (i != 0) downLeftUp(i - 1);
        scanRelative(-h, 0);
        if (i != 0) downLeftUp(i - 1);
        scanRelative(0, h);
        if (i != 0) rightUpLeft(i - 1);
    }

    private function leftDownRight(i : int) : void {
        if (i != 0) downLeftUp(i - 1);
        scanRelative(-h, 0);
        if (i != 0) leftDownRight(i - 1);
        scanRelative(0, -h);
        if (i != 0) leftDownRight(i - 1);
        scanRelative(h, 0);
        if (i != 0) upRightDown(i - 1);
    }

    private function upRightDown(i : int) : void {
        if (i != 0) rightUpLeft(i - 1);
        scanRelative(0, h);
        if (i != 0) upRightDown(i - 1);
        scanRelative(h, 0);
        if (i != 0) upRightDown(i - 1);
        scanRelative(0, -h);
        if (i != 0) leftDownRight(i - 1);
    }

    private function scanRelative(dx : int, dy : int) : void {
        var ax : int;
        var ay : int;

        if (dx < 0) {
            for (ax = 0; (ax >= dx); ax--) {
                bm.setPixel(px + ax, py, bmd0.getPixel(px + ax, py));
            }
        } else if (dy < 0) {
            for (ay = 0; (ay >= dy); ay--) {
                bm.setPixel(px, py + ay, bmd0.getPixel(px, py + ay));
            }
        } else {
            for (ay = 0; ay <= dy; ay++) {
                for (ax = 0; ax <= dx; ax++) {
                    bm.setPixel(px + ax, py + ay, bmd0.getPixel(px + ax, py + ay));
                }
            }
        }

        px += dx;
        py += dy;
    }
}