/**
 * Copyright atsu ( http://wonderfl.net/user/atsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jjVJ
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    [SWF(frameRate="50")]
    public class Main100623 extends Sprite
    {
        private static const WIDTH:int = 465;
        private static const HEIGHT:int = 465;
        private static const NUM_PARTICLES:uint = 100;
        private static const NUM_PARTICLE_ONCE:uint = 1;
        private static const CTF:ColorTransform = new ColorTransform(0.9, 0.9, 0.9, 1, -100, -20, 0);
        private var _canvas:BitmapData;
        private var _particles:Array = new Array(); 
        public function Main100623()
        {
            init();
        }
        private function init():void
        {
            _canvas = new BitmapData(WIDTH, HEIGHT, false, 0x000000);
            addChild(new Bitmap(_canvas));
            addEventListener(Event.ENTER_FRAME, enterFrameHandler)
        }
        private function enterFrameHandler(e:Event):void
        {
            _canvas.lock();
            _canvas.colorTransform(_canvas.rect, CTF);
            for (var i:int = 0; i < NUM_PARTICLE_ONCE; i++) {
                createParticle();
            };
            while (_particles.length > NUM_PARTICLES)
            {
                var p:Particle = _particles.shift();
                p = null;
            }           
            var len:int = _particles.length;
            for (var j:int = 0; j < len; j++) {            
                var pos:Point= _particles[j].p;
                _particles[j].update();
                _canvas.setPixel(pos.x >> 0, pos.y >> 0, 0xFFFFFF);
            }
            _canvas.unlock();
        }
        private function createParticle():void
        {
            var radian:Number = Math.random() * Math.PI * 2;
            var dx:Number = Math.cos(radian);
            var dy:Number = Math.sin(radian);
            var p:Particle = new Particle();
            p.p.x = WIDTH / 2;
            p.p.y = HEIGHT / 2;
            _particles.push(p);
            p.dx = dx;
            p.dy = dy;
        }
    }
}
import flash.geom.Point;
class Particle
{
    public var p:Point = new Point();
    public var dx:Number;
    public var dy:Number;
    public function update():void
    {        
        p.x += dx * Math.random() * 5;
        p.y += dy * Math.random() * 5;
    }
}