/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jjUc
 */

package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    /**
     * KeyState クラス
     * 
     * @author tkinjo
     */
    public class Main extends Sprite
    {
        private var keyNameTextField:TextField;
        private var keyPressedTextField:TextField;
        private var keyRepeatedTextField:TextField;
        private var keyReleasedTextField:TextField;
        
        public function Main() 
        {
            initComponent();
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
            stage.addEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
        }
        
        private function initComponent():void {
            
            keyNameTextField = new TextField();
            keyNameTextField.autoSize = TextFieldAutoSize.LEFT;
            
            keyNameTextField.appendText( "key" + "\n" );
            keyNameTextField.appendText( "\n" );
            keyNameTextField.appendText( "z" + "\n" );
            keyNameTextField.appendText( "x" + "\n" );
            keyNameTextField.appendText( "←" + "\n" );
            keyNameTextField.appendText( "↑" + "\n" );
            keyNameTextField.appendText( "→" + "\n" );
            keyNameTextField.appendText( "↓" + "\n" );
            keyNameTextField.appendText( "Shift" + "\n" );
            
            addChild( keyNameTextField );
            
            
            
            keyPressedTextField = new TextField();
            keyPressedTextField.autoSize = TextFieldAutoSize.LEFT;
            keyPressedTextField.x = 50;
            
            keyRepeatedTextField = new TextField();
            keyRepeatedTextField.autoSize = TextFieldAutoSize.LEFT;
            keyRepeatedTextField.x = 100;
            
            keyReleasedTextField = new TextField();
            keyReleasedTextField.autoSize = TextFieldAutoSize.LEFT;
            keyReleasedTextField.x = 150;
            
            addChild( keyPressedTextField );
            addChild( keyRepeatedTextField );
            addChild( keyReleasedTextField );
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            keyPressedTextField.text = "";
            
            keyPressedTextField.appendText( "pressed" + "\n" );
            keyPressedTextField.appendText( "\n" );
            keyPressedTextField.appendText( getPressed( "z" ) + "\n" );
            keyPressedTextField.appendText( getPressed( "x" ) + "\n" );
            keyPressedTextField.appendText( getPressed( KeyState.LEFT  ) + "\n" );
            keyPressedTextField.appendText( getPressed( KeyState.UP    ) + "\n" );
            keyPressedTextField.appendText( getPressed( KeyState.RIGHT ) + "\n" );
            keyPressedTextField.appendText( getPressed( KeyState.DOWN  ) + "\n" );
            keyPressedTextField.appendText( getPressed( KeyState.SHIFT ) + "\n" );
            
            
            
            keyRepeatedTextField.text = "";
            
            keyRepeatedTextField.appendText( "repeated" + "\n" );
            keyRepeatedTextField.appendText( "\n" );
            keyRepeatedTextField.appendText( getRepeated( "z" ) + "\n" );
            keyRepeatedTextField.appendText( getRepeated( "x" ) + "\n" );
            keyRepeatedTextField.appendText( getRepeated( KeyState.LEFT  ) + "\n" );
            keyRepeatedTextField.appendText( getRepeated( KeyState.UP    ) + "\n" );
            keyRepeatedTextField.appendText( getRepeated( KeyState.RIGHT ) + "\n" );
            keyRepeatedTextField.appendText( getRepeated( KeyState.DOWN  ) + "\n" );
            keyRepeatedTextField.appendText( getRepeated( KeyState.SHIFT ) + "\n" );
            
            
            
            keyReleasedTextField.text = "";
            
            keyReleasedTextField.appendText( "released" + "\n" );
            keyReleasedTextField.appendText( "\n" );
            keyReleasedTextField.appendText( getReleased( "z" ) + "\n" );
            keyReleasedTextField.appendText( getReleased( "x" ) + "\n" );
            keyReleasedTextField.appendText( getReleased( KeyState.LEFT  ) + "\n" );
            keyReleasedTextField.appendText( getReleased( KeyState.UP    ) + "\n" );
            keyReleasedTextField.appendText( getReleased( KeyState.RIGHT ) + "\n" );
            keyReleasedTextField.appendText( getReleased( KeyState.DOWN  ) + "\n" );
            keyReleasedTextField.appendText( getReleased( KeyState.SHIFT ) + "\n" );
        }
        
        private function getPressed( string:String ):String {
            
            return KeyState.getPressed( string ) ? "○" : "－";
        }
        
        private function getRepeated( string:String ):String {
            
            return KeyState.getRepeated( string ) ? "○" : "－";
        }
        
        private function getReleased( string:String ):String {
            
            return KeyState.getReleased( string ) ? "○" : "－";
        }
        
        private function keyDownHandler( event:KeyboardEvent ):void {
            
            KeyState.pressAtKeyCode( event.keyCode );
        }
        
        private function keyUpHandler( event:KeyboardEvent ):void {
            
            KeyState.releaseAtKeyCode( event.keyCode );
        }
    }
    
}

class KeyState {
    
    private static var repeated:Vector.<Boolean> = new Vector.<Boolean>( 256 );
    private static var pressed :Vector.<Boolean> = new Vector.<Boolean>( 256 );
    private static var released:Vector.<Boolean> = new Vector.<Boolean>( 256 );
    
    /** --------------------------------------------------
     * 
     */
    
    public static const SHIFT:String = "shift";
    public static const CTRL :String = "ctrl";
    public static const ALT  :String = "alt";
    
    public static const LEFT :String = "left";
    public static const UP   :String = "up";
    public static const RIGHT:String = "right";
    public static const DOWN :String = "down";
    
    /** --------------------------------------------------
     * 
     */
    
    public static const KEY_SHIFT:uint = 16;
    public static const KEY_CTRL :uint = 17;
    public static const KEY_ALT  :uint = 18;
    
    public static const KEY_LEFT :uint = 37;
    public static const KEY_UP   :uint = 38;
    public static const KEY_RIGHT:uint = 39;
    public static const KEY_DOWN :uint = 40;
    
    
    
    public static const CHAR_LARGE_A:uint = 65;
    public static const CHAR_SMALL_A:uint = 97;
    public static const KEY_A       :uint = 65;
    
    public static const NUM_ALPHABET:uint = 26;
    
    
    
    public static const CHAR_0      :uint = 48;
    public static const KEY_0       :uint = 0;
    public static const KEY_NUMPAD_0:uint = 96;
    
    public static const NUM_NUMBER:uint = 10;
    
    
    /** ==================================================
     * 
     */
    
    public static function press( string:String ):void {
        
        var keyCode:Number = getKeyCode( string );
        
        if ( keyCode > 0 )
            pressAtKeyCode( keyCode );
    }
    
    public static function release( string:String ):void {
        
        var keyCode:Number = getKeyCode( string );
        
        if ( keyCode > 0 )
            releaseAtKeyCode( keyCode );
    }
    
    
    /** --------------------------------------------------
     * 
     */
    
    public static function pressAtKeyCode( keyCode:uint ):void {
        
        if ( repeated[ keyCode ] )
            return;
        
        repeated[ keyCode ] = true;
        pressed[  keyCode ] = true;
        released[ keyCode ] = false;
    }
    
    public static function releaseAtKeyCode( keyCode:uint ):void {
        
        repeated[ keyCode ] = false;
        pressed[  keyCode ] = false;
        released[ keyCode ] = true;
    }
    
    
    
    /** --------------------------------------------------
     * 
     */
    
    public static function getRepeated( string:String ):Boolean {
        
        var keyCode:Number = getKeyCode( string );
        
        if( keyCode > 0 )
            return getRepeatedAtKeyCode( keyCode );
        
        return false;
    }
    
    public static function getReleased( string:String ):Boolean {
        
        var keyCode:Number = getKeyCode( string );
        
        if( keyCode > 0 )
            return getReleasedAtKeyCode( keyCode );
        
        return false;
    }
    
    public static function getPressed( string:String ):Boolean {
        
        var keyCode:Number = getKeyCode( string );
        
        if( keyCode > 0 )
            return getPressedAtKeyCode( keyCode );
        
        return false;
    }
    
    
    
    /** --------------------------------------------------
     * 
     */
    
    public static function getRepeatedAtKeyCode( keyCode:uint ):Boolean {
        
        return repeated[ keyCode ];
    }
    
    public static function getReleasedAtKeyCode( keyCode:uint ):Boolean {
        
        var result:Boolean = released[ keyCode ];
        released[ keyCode ] = false;
        
        return result;
    }
    
    public static function getPressedAtKeyCode( keyCode:uint ):Boolean {
        
        var result:Boolean = pressed[ keyCode ];
        pressed[ keyCode ] = false;
        
        return result;
    }
    
    
    
    /** --------------------------------------------------
     * 
     */
    
    public static function getKeyCode( string:String ):Number {
        
        if( string.length == 1 ) {
            
            return charCodeToKeyCode( string.charCodeAt() );
        }
        
        switch ( string ) {
            
            case SHIFT:
                return KEY_SHIFT;
            
            case CTRL:
                return KEY_CTRL;
            
            case ALT:
                return KEY_ALT;
            
            case LEFT:
                return KEY_LEFT;
            
            case UP:
                return KEY_UP;
            
            case RIGHT:
                return KEY_RIGHT;
            
            case DOWN:
                return KEY_DOWN;
        }
        
        return -1;
    }
    
    
    
    public static function charCodeToKeyCode( charCode:uint ):Number {
        
        // A-Z
        if ( CHAR_LARGE_A <= charCode && ( charCode - CHAR_LARGE_A ) < NUM_ALPHABET ) {
            
            return charCode;
            
        // a-z
        } else if ( CHAR_SMALL_A <= charCode && ( charCode - CHAR_SMALL_A ) < NUM_ALPHABET ) {
            
            return KEY_A + ( charCode - CHAR_SMALL_A );
            
        // 0-9
        } else if ( CHAR_0 <= charCode && ( charCode - CHAR_0 ) < NUM_NUMBER ) {
            
            return charCode;
        }
        
        return -1;
    }
}