/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jjI5
 */

package {
    import flash.display.*;
    import flash.text.TextField;
    import flash.events.*;
    import flash.net.*;
    import mx.utils.*;
    
    import com.adobe.serialization.json.*;
    import jp.progression.commands.net.*;
    import com.bit101.components.*;

    [SWF(backgroundColor=0xaaaabb)]
    public class Test extends Sprite {
        private var _tf : TextField;
        private var _user : InputText;
        private var _submit : PushButton;
        
        private var _W : Number;
        private var _H : Number;

        public function Test() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            _W = stage.stageWidth;
            _H = stage.stageHeight;
            
            _user = new InputText(this, _W/2-60, _H/2-10, "uwitenpen");
            _user.width = 90;
            
            _submit = new PushButton(this, _W/2+40, _H/2-10, "search", onSubmit);
            _submit.width = 55;
            _submit.height = 17;
        }
        
        private var _results : Array = [];
        
        public function onSubmit(e : MouseEvent) : void
        {
            var q : String = _user.text;
            if(q == "")return;
            _results = [];
            onRequestComplete();
//            request(q, 1);
        }
        
        public function onRequestComplete() : void
        {
            tr(_results.length);
            tr(ObjectUtil.toString(_results));
            
            var g : Graphics = this.graphics;
            g.clear();
            g.beginFill(0x000000);
            g.drawCircle(_W/2, _H/2, 150);
            g.drawCircle(_W/2, _H/2, 100);
            g.endFill();
            
            var now : Number = (new Date().getTime()%(1000*86400))/(1000*86400);
            g.lineStyle(0xff0000);
            g.moveTo(_W/2+Math.sin(now*Math.PI*2)*150, _H/2-Math.cos(now*Math.PI*2)*150);
            g.lineTo(_W/2+Math.sin(now*Math.PI*2)*100, _H/2-Math.cos(now*Math.PI*2)*100);
        }
        
        public function request(q : String, page : uint) : void
        {
            var url : String = "http://search.twitter.com/search.json?q=from%3a" + q + "&page="+page;
            var lu : LoadURL = new LoadURL(new URLRequest(url), 
            {
                onComplete : function() : void {
                    var json : Object = JSON.decode(lu.data);
                    var lrets : Array = json.results;
                    var yes : Number = new Date().getTime() - 1000*86400;
                    var all : Boolean = lrets.length < 15;
                    for each(var r : Object in lrets){
                        var time : Number = Date.parse(r.created_at);
                        if(time >= yes){
                            _results.push(r);
                        }else{
                            all = true;
                        }
                    }
                    if(!all){
                        request(q, page + 1);
                    }else{
                        onRequestComplete();
                    }
                },
                catchError : function() : void {
                    tr("error!");
                }
            });
            lu.execute();
        }
            
        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
        }
    }
}