/**
 * Copyright ck1 ( http://wonderfl.net/user/ck1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jitw
 */

package {
    
  import flash.display.Sprite;
  import flash.display.Shape;
  import flash.events.*;
 
  public class Lawn extends Sprite
  {
    private var ball:Shape;
    private var rows:uint = 15;
    private var cols:uint = 40;
    private var xGrid:uint = 12;
    private var yGrid:uint = 23;
    private var offsetX:uint = 10;
    private var offsetY:uint = 100;
      
    public function Lawn()
    {
        graphics.beginFill(0x33391A);
        graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        graphics.endFill();
        
        ball = new Shape();
        ball.graphics.beginFill(0x111122, .8);
        ball.graphics.drawCircle(0,5,12);
        ball.graphics.beginFill(0x660000);
        ball.graphics.drawCircle(0,0,12);
        ball.graphics.beginFill(0xDDDDDD);
        ball.graphics.drawCircle(-3,-4,2);
        ball.graphics.endFill();
        stage.addEventListener(Event.ENTER_FRAME, setBall);
        
        //stage.addChild(new Output());
        
        for (var h:uint = 0; h < rows; h++)
        {
            for (var i:uint = 0; i < cols; i++)
            {
                //var s:BezierPath = new BezierPath(ball, output, 0x00 << 16 |  0x33 + Math.random()*0x22 + (h*0x11) << 8 | 0x00, this.stage);
                var s:BezierPath = new BezierPath(ball, 0x00 << 16 |  0x1A + (h*0x0D) << 8 | 0x00, this.stage);
                s.x = offsetX + i * xGrid + Math.random()*12;
                s.y = offsetY + h * yGrid + Math.random()*12;
            }
        }
    }
    
    private function setBall(e:Event):void
    {
        ball.x += (stage.mouseX - ball.x)/30;
        ball.y += (stage.mouseY - ball.y)/30;
        stage.addChildAt( ball, Math.round( (ball.y - offsetY + yGrid*.85) / yGrid ) * cols );
    }
  }
}


     import flash.display.Stage;
     import flash.events.*;
     import flash.display.Sprite;
     import flash.display.Shape;
     import mx.effects.Tween;
     import gs.TweenMax;
     import gs.easing.*;
     
     
     class BezierPath extends Shape
     { 
        public var xPos:Number = 0;
        private var left:Boolean = true;
        private var theStage:Stage;
        private var color:uint;
        private var dist:Number = 40;  
        private var ball:Shape;
        private var output:Output;
        
       public function BezierPath(ball:Shape, color:uint, theStage:Stage)
       {
            this.theStage = theStage;
            this.color = color;
            this.ball = ball;
            theStage.addChild(this);
            draw();
            theStage.addEventListener(Event.ENTER_FRAME, ballPos);
        }
        
        private function ballPos(e:Event):void
        {
           var xDist:Number = ball.x - this.x;
           var yDist:Number = ball.y - (this.y - 10);
            if ( Math.sqrt(yDist * yDist + xDist * xDist) < dist)
            {
               if ( (xDist < 0 && xPos < 0) || (xDist > 0 && xPos > 0) ) tweenBack(-xPos);
               else if (xDist < 0)
                {
                     tweenBack((dist + xDist)*.5);
                }
                else if (xDist > 0)
                {
                    tweenBack((-dist + xDist)*.5);
                }
            }
            else if (xPos != 0) tweenBack(0);
        }
        
        private function tweenBack(newX:Number):void
        {
            Output.trace("tweeen");
            theStage.removeEventListener(Event.ENTER_FRAME, ballPos);
            TweenMax.to(this, .5, {xPos:newX, onComplete:function():void {
                theStage.addEventListener(Event.ENTER_FRAME, ballPos); }, onUpdate:draw} );
        }                      
        
        private function draw():void
        {
            this.graphics.clear();
            this.graphics.beginFill(0x222211, .8);
            this.graphics.drawRect(-4,-2, 8, 4);
            this.graphics.beginFill(this.color);
            this.graphics.moveTo(-4, 0);
            this.graphics.curveTo(-4, -10, xPos - 3, -20);
            this.graphics.curveTo(xPos*1.5 - 3 , -30, xPos*1.3 - 2, -40);
            this.graphics.curveTo(xPos*1.1 - 1, -50, xPos*1.05, -60);
            this.graphics.curveTo(xPos*1.1 + 1, -50, xPos*1.3 + 2, -40);
            this.graphics.curveTo(xPos*1.5 + 3, -30, xPos + 3, -20);
            this.graphics.curveTo(4, -10, 4, 0);
            this.graphics.endFill();
        }
    }

    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.GradientType;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.text.TextFieldAutoSize;
    
    /**
     * Creates a pseudo Output panel in a publish
     * swf for displaying trace statements.
     * For the output panel to capture trace 
     * statements, you must use Output.trace()
     * and add an instance to the stage:
     * stage.addChild(new Output());
     *
     * Note: You may want to place Output in an
     * unnamed package to make it easier to
     * trace within your classes without having
     * to import com.senocular.utils.Output.
     */
    class Output extends Sprite {
        private var output_txt:TextField;
        private var titleBar:Sprite;
        private static var instance:Output;
        private static var autoExpand:Boolean = true;
        private static var maxLength:int = 1000;
        
        public function Output(outputHeight:uint = 150){
            if (instance && instance.parent){
                instance.parent.removeChild(instance);
            }
            
            instance = this;
            addChild(newOutputField(outputHeight));
            addChild(newTitleBar());
            
            addEventListener(Event.ADDED, added);
            addEventListener(Event.REMOVED, removed);
        }
        
        // public methods
        public static function trace(str:*):void {
            if (!instance) return;
            instance.output_txt.appendText(str+"\n");
            if (instance.output_txt.length > maxLength) {
                instance.output_txt.text = instance.output_txt.text.slice(-maxLength);
            }
            instance.output_txt.scrollV = instance.output_txt.maxScrollV;
            if (autoExpand && !instance.output_txt.visible) instance.toggleCollapse();
        }
        public static function clear():void {
            if (!instance) return;
            instance.output_txt.text = "";
        }
        
        private function newOutputField(outputHeight:uint):TextField {
            output_txt = new TextField();
            output_txt.type = TextFieldType.INPUT;
            output_txt.border = true;
            output_txt.borderColor = 0;
            output_txt.background = true;
            output_txt.backgroundColor = 0xFFFFFF;
            output_txt.height = outputHeight;
            var format:TextFormat = output_txt.getTextFormat();
            format.font = "_typewriter";
            output_txt.setTextFormat(format);
            output_txt.defaultTextFormat = format;
            return output_txt;
        }
        private function newTitleBar():Sprite {
            var barGraphics:Shape = new Shape();
            barGraphics.name = "bar";
            var colors:Array = new Array(0xE0E0F0, 0xB0C0D0, 0xE0E0F0);
            var alphas:Array = new Array(1, 1, 1);
            var ratios:Array = new Array(0, 50, 255);
            var gradientMatrix:Matrix = new Matrix();
            gradientMatrix.createGradientBox(18, 18, Math.PI/2, 0, 0);
            barGraphics.graphics.lineStyle(0);
            barGraphics.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, gradientMatrix);
            barGraphics.graphics.drawRect(0, 0, 18, 18);
            
            var barLabel:TextField = new TextField();
            barLabel.autoSize = TextFieldAutoSize.LEFT;
            barLabel.selectable = false;
            barLabel.text = "Output";
            var format:TextFormat = barLabel.getTextFormat();
            format.font = "_sans";
            barLabel.setTextFormat(format);
            
            titleBar = new Sprite();
            titleBar.addChild(barGraphics);
            titleBar.addChild(barLabel);
            return titleBar;
        }
        
        // Event handlers
        private function added(evt:Event):void {
            stage.addEventListener(Event.RESIZE, fitToStage);
            titleBar.addEventListener(MouseEvent.CLICK, toggleCollapse);
            fitToStage();
            toggleCollapse();
        }
        private function removed(evt:Event):void {
            stage.removeEventListener(Event.RESIZE, fitToStage);
            titleBar.removeEventListener(MouseEvent.CLICK, toggleCollapse);
        }
        private function toggleCollapse(evt:Event = null):void {
            if (!instance) return;
            output_txt.visible = !output_txt.visible;
            fitToStage(evt);
        }
        private function fitToStage(evt:Event = null):void {
            if (!stage) return;
            output_txt.width = stage.stageWidth;
            output_txt.y = stage.stageHeight - output_txt.height;
            titleBar.y = (output_txt.visible) ? output_txt.y - titleBar.height : stage.stageHeight - titleBar.height;
            titleBar.getChildByName("bar").width = stage.stageWidth;
        }
    }