/**
 * Copyright randomizer ( http://wonderfl.net/user/randomizer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jhEd
 */

package{
    import flash.events.*;
    import flash.display.*;
    import flash.ui.*;
    import mx.controls.Alert;

    [SWF(frameRate = "60")]

    public class test extends Sprite{
        public var swidth:int;
        public var sheight:int;

        public var frametime:Number = 1.0;

        public var px:Number;
        public var py:Number;
        public var vx:Number;
        public var vy:Number;
        public var floating:int;
        public var kup:int,kdown:int,kleft:int,kright:int;
        public var jumpok:int;
        public var rideon:int;
        public var b1:block,b2:block,b4:block,b5:block,b6:block,b7:block;
        public var b3:Array = new Array();
        public var blocks:Array = new Array();
        public var nblocks:int;
        public var scroll:int;

        public var balls:Array = new Array();
        public var ball_cnt:int;

        public function test() {
            var i:int;

            kup = kdown = kleft = kright = 0;

            sheight = 465;
            swidth = 465;

            scroll = 0;
            floating = 1;
            px = 100.0;
            py = 100.0;
            vx = 0.0;
            vy = 0.0;
            jumpok = 1;
            rideon = -1;

            b1 = new block();
            b2 = new block();
            b4 = new block();
            b5 = new block();
            b6 = new block();
            b7 = new block();

            b1.x1 = 150; b1.x2 = 250;
            b1.y1 = sheight - 30 - 60 - 80;
            b1.y2 = sheight - 30 - 60;

            b2.x1 = 300; b2.x2 = 400;
            b2.y1 = sheight - 50 - 60 - 50 - 100;
            b2.y2 = sheight - 50 - 60 - 100;

            b4.x1 = 465+7*100+100;
            b4.x2 = 465+7*100+160;
            b4.y1 = sheight - 260;
            b4.y2 = sheight - 10;

            b5.x1 = 465+7*100+160+1;
            b5.x2 = 465+7*100+160+1+30;
            b5.y1 = sheight - 160;
            b5.y2 = sheight - 130;

            b6.x1 = 465+7*100+100-1-30;
            b6.x2 = 465+7*100+100-1;
            b6.y1 = sheight - 160;
            b6.y2 = sheight - 130;

            b7.x1 = 465+7*100+160+31+300;
            b7.x2 = 465+7*100+160+31+300+30;
            b7.y1 = sheight - 160;
            b7.y2 = sheight - 130;

            blocks[0] = b1;
            blocks[1] = b2;
            blocks[10] = b4;
            blocks[11] = b5;
            blocks[12] = b6;
            blocks[13] = b7;

            for( i = 0 ; i < 8 ; i++ ) {
                b3[i] = new block;

                b3[i].x1 = 465+i*100;
                b3[i].x2 = 465+i*100+30;
                b3[i].y1 = sheight - 260;
                b3[i].y2 = sheight - 260 + 30;

                blocks[i+2] = b3[i];
            }

            nblocks = 14;

            for( i = 0 ; i < nblocks ; i++ ) {
                blocks[i]["visible"] = 1;
                blocks[i]["f_question"] = 0;
            }

            b6["visible"] = 0;

            for( i = 0 ; i < 100 ; i++ ) {
                balls[i] = new ball();
                balls[i]["isuse"] = 0;
            }

            b5.f_question = 1;
            b7.f_question = 1;

            ball_cnt = 0;

            stage.addEventListener( KeyboardEvent.KEY_DOWN , onKeyDown );
            stage.addEventListener( KeyboardEvent.KEY_UP , onKeyUp );
            addEventListener( Event.ENTER_FRAME , onIdle );
        }

        public function create_balls() : void {
            var i:int;

            if( ball_cnt != 0 ) return;

            for( i = 0 ; i < 100 ; i++ ) {
                balls[i].isuse = 1;
                balls[i].x = b7.x1+15;
                balls[i].y = b7.y1;
                balls[i].vx = (Math.round( Math.random()*100+0.5 ) /10.0-5.0);
                balls[i].vy = -(Math.round( Math.random()*100+0.5 ) /10.0) -4.0;
            }

            ball_cnt = 100;
        }

        public function onKeyDown( e:KeyboardEvent ) : void {
            trace( "aaa" );

            switch( e.keyCode ) {
            case Keyboard.UP:
                kup = 1;
                break;
            case Keyboard.DOWN:
                kdown = 1;
                break;
            case Keyboard.LEFT:
                kleft = 1;
                break;
            case Keyboard.RIGHT:
                kright = 1;
                break;
            }
        }

        public function onKeyUp( e:KeyboardEvent ) : void {
            switch( e.keyCode ) {
            case Keyboard.UP:
                kup = 0;
                break;
            case Keyboard.DOWN:
                kdown = 0;
                break;
            case Keyboard.LEFT:
                kleft = 0;
                break;
            case Keyboard.RIGHT:
                kright = 0;
                break;
            }
        }

        public function onIdle( e:Event ) : void {
            var i:int;

            px += vx*frametime;
            py += vy*frametime;

            if( px-scroll > swidth/2+100 ) {
                scroll = px-swidth/2-100;
            } else if( px-scroll < swidth/2-100 ) {
                scroll = px-swidth/2+100;
            }

            for( i = 0 ; i < nblocks ; i++ ) {
                var tbpath:int;

                if( blocks[i].visible == 0 ) continue;

                /* left hit */
                if( px+10.0 > Number(blocks[i].x1) &&
                    px+10.0 < Number(blocks[i].x2) &&
                    py > Number(blocks[i].y1) &&
                    py < Number(blocks[i].y2) ) {
                    px = Number(blocks[i].x1)-10.0;
                    vx = 0.0;
                    tbpath = 1;
                }
                /* right hit */
                if( px-10.0 < Number(blocks[i].x2) &&
                    px-10.0 > Number(blocks[i].x1) &&
                    py > Number(blocks[i].y1) &&
                    py < Number(blocks[i].y2) ) {
                    px = Number(blocks[i].x2)+10.0;
                    vx = 0.0;
                    tbpath = 1;
                }
                /* bottom hit */
                if( !tbpath && vy < 0.0 && py-10.0 < Number(blocks[i].y2) &&
                    py-10.0 > Number(blocks[i].y1) &&
                    px+10.0 > Number(blocks[i].x1) &&
                    px-10.0 < Number(blocks[i].x2) ) {
                    py = Number(blocks[i].y2)+10.0;
                    vy = 0.0;

                    if( i == 11 ) {
                        b6.visible = 1;
                    }
                    if( i == 13 ) {
                        create_balls();
                    }
                }
                /* top hit */
                if( !tbpath && vy > 0.0 && py+10.0 > Number(blocks[i].y1) &&
                    py+10.0 < Number(blocks[i].y2) &&
                    px+10.0 > Number(blocks[i].x1) &&
                    px-10.0 < Number(blocks[i].x2) ) {
                    py = Number(blocks[i].y1)-10.0;
                    floating = 0;
                    rideon = i;
                }
            }

            if( rideon >= 0 ) {
                if( !( px+10.0 > Number(blocks[rideon].x1) &&
                       px-10.0 < Number(blocks[rideon].x2) ) ) {
                    floating = 1;
                    rideon = -1;
                }
            }

            if( py+10.0 > Number(sheight) - 50.0 ) {
                floating = 0;
                rideon = -2;
                py = sheight - 50.0 - 10.0;
            }

            if( floating ) {
                if( vy < 10.0 ) {
                    vy += 1.0*frametime;
                }
            }

            if( kright ) {
                if( vx < 5.0 ) {
                    vx += 0.5*frametime;
                }
            } else if( kleft ) {
                if( vx > -5.0 ) {
                    vx -= 0.5*frametime;
                }
            } else if( vx != 0.0 ) {
                if( vx > 0 ) {
                    vx -= 0.5*frametime;
                    if( vx < 0.0 ) {
                        vx = 0.0;
                    }
                } else if( vx < 0 ) {
                    vx += 0.5*frametime;
                    if( vx > 0.0 ) {
                        vx = 0.0;
                    }
                }
            }

            if( kup && (!floating) && jumpok ) {
                floating = 1;
                rideon = -1;
                vy = -15.0;
                jumpok = 0;
            }

            if( (!kup) && (!jumpok) ) {
                jumpok = 1;
            }

            graphics.clear();
            graphics.lineStyle( 1 , 0 );

            var g:Graphics = graphics;

            g.moveTo( 0 , sheight-50 );
            g.lineTo( swidth , sheight-50 );

            g.drawEllipse( int(px-10.0-scroll) , int(py-10.0) ,
                     int(px+10.0-scroll)-int(px-10.0-scroll) , int(py+10.0)-int(py-10.0) );

            for( i = 0 ; i < nblocks ; i++ ) {
                if( blocks[i].visible == 0 ) continue;

                g.drawRect( blocks[i].x1-scroll , blocks[i].y1 ,
                           (blocks[i].x2-scroll)-blocks[i].x1+scroll , blocks[i].y2-blocks[i].y1 );

                if( blocks[i].f_question && blocks[i].x2-scroll > 0 &&
                    blocks[i].x1-scroll < swidth ) {
                        /*
                    char buf[] = "?";
                    RECT r;

                    r.left = g.blocks[i]->x1-g.scroll;
                    r.right = g.blocks[i]->x2-g.scroll;
                    r.top = g.blocks[i]->y1;
                    r.bottom = g.blocks[i]->y2;

                    DrawText( hback , buf , strlen(buf) , &r ,
                        DT_CENTER | DT_SINGLELINE | DT_VCENTER );
                    
                    */
                }
            }

            for( i = 0 ; i < 100 ; i++ ) {
                if( ball_cnt == 0 ) break;

                if( balls[i].isuse ) {
                    balls[i].x += balls[i].vx;
                    balls[i].y += balls[i].vy;
                    balls[i].vy += 0.5;

                    if( balls[i].x-scroll < Number(0-3) ||
                        balls[i].x-scroll > Number(swidth+3) ||
                        balls[i].y > Number(sheight+3) ) {
                        balls[i].isuse = 0;
                        ball_cnt--;
                    }

                    g.drawEllipse( int(balls[i].x-3-scroll) , int(balls[i].y-3) ,
                         int(balls[i].x+3-scroll)-int(balls[i].x-3-scroll) , int(balls[i].y+3)-int(balls[i].y-3) );
                }
            }
        }
    }
}

class block{
    public var x1:int;
    public var x2:int;
    public var y1:int;
    public var y2:int;

    public var visible:int;
    public var f_question:int;
}

class ball{
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;

    public var isuse:int;
}